/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.postcode;

import Gbt.core.ipmi.GbtIPMIOptions;
import Gbt.core.ipmi.GbtIpmiCommandResponseData;
import Gbt.utility.postcode.PostCodeCommand;

public enum PostCodeIpmiOptions implements GbtIPMIOptions<PostCodeCommand.Builder>
{
    GET_FIRST_CURRENT_DATA(0, "Get first current data"),
    GET_FIRST_PREVIOUS_DATA(1, "Get first previous data"),
    GET_NEXT_CURRENT_DATA(2, "Get next current data"),
    GET_NEXT_PREVIOUS_DATA(3, "Get next previous data"),
    GET_CURRENT_LENGTH(4, "Get current length"),
    GET_PREVIOUS_LENGTH(5, "Get previous Length");

    private static final byte NET_FN = 50;
    private static final byte CMD = 115;
    private final int optionCode;
    private final String item;

    private PostCodeIpmiOptions(int optionCode, String item) {
        this.optionCode = optionCode;
        this.item = item;
    }

    @Override
    public int getOptionCode() {
        return this.optionCode;
    }

    @Override
    public String getItem() {
        return this.item;
    }

    @Override
    public byte getNetFn() {
        return 50;
    }

    @Override
    public byte getCommandCode() {
        return 115;
    }

    @Override
    public byte[] rebuildRequestData(PostCodeCommand.Builder commandArgs) {
        return new byte[]{(byte)this.optionCode};
    }

    @Override
    public GbtIpmiCommandResponseData parserResponseData(GbtIpmiCommandResponseData gbtResponseData) {
        return gbtResponseData;
    }
}

