/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.power;

import com.fasterxml.jackson.annotation.JsonValue;

public enum PowerLimitExceptionActions {
    UNKNOWN("Unknown", 0),
    NOACTION("No action", 0),
    HARDPOWEROFFANDSEL("Hard Power Off system & log event to SEL", 1),
    LOGTOSEL("Log event to SEL", 17);

    private static final byte CODE_00 = 0;
    private static final byte CODE_01 = 1;
    private static final byte CODE_11 = 17;
    private final String value;
    private final byte code;

    private PowerLimitExceptionActions(String value, byte code) {
        this.value = value;
        this.code = code;
    }

    public byte getCode() {
        return this.code;
    }

    @JsonValue
    public String toString() {
        return this.value;
    }

    public static final PowerLimitExceptionActions parse(byte rawByte) {
        switch (rawByte) {
            case 0: {
                return NOACTION;
            }
            case 1: {
                return HARDPOWEROFFANDSEL;
            }
            case 17: {
                return LOGTOSEL;
            }
        }
        return UNKNOWN;
    }

    public static final PowerLimitExceptionActions parse(String rawString) {
        switch (rawString.toLowerCase()) {
            case "no": {
                return NOACTION;
            }
            case "off": {
                return HARDPOWEROFFANDSEL;
            }
            case "log": {
                return LOGTOSEL;
            }
        }
        return UNKNOWN;
    }
}

