/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.rest;

import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.rest.RESTServiceFactory;
import Gbt.core.rest.RESTServices;
import Gbt.core.rest.RESTServicesOptions;
import Gbt.utility.rest.options.ADGroupOptions;
import Gbt.utility.rest.options.ADUserOptions;
import Gbt.utility.rest.options.BIOSSetupServiceOptions;
import Gbt.utility.rest.options.BackupServiceOptions;
import Gbt.utility.rest.options.CAServiceOptions;
import Gbt.utility.rest.options.DNSGeneralOptions;
import Gbt.utility.rest.options.FanProfileOptions;
import Gbt.utility.rest.options.IPv6ServiceOptions;
import Gbt.utility.rest.options.LDAPGeneralServiceOptions;
import Gbt.utility.rest.options.LDAPGroupServiceOptions;
import Gbt.utility.rest.options.NTPServiceOptions;
import Gbt.utility.rest.options.NoServiceOptions;
import Gbt.utility.rest.options.PEFServiceOptions;
import Gbt.utility.rest.options.PamOrderServiceOptions;
import Gbt.utility.rest.options.PreserveCfgServiceOptions;
import Gbt.utility.rest.options.RaidServiceOptions;
import Gbt.utility.rest.options.SMTPServiceOptions;
import Gbt.utility.rest.options.TrapServiceOptions;
import Gbt.utility.rest.options.VmcliServiceOptions;
import Gbt.utility.rest.services.ADGroupService;
import Gbt.utility.rest.services.ADUserService;
import Gbt.utility.rest.services.AuditServices;
import Gbt.utility.rest.services.BIOSSetupService;
import Gbt.utility.rest.services.BackupService;
import Gbt.utility.rest.services.CAService;
import Gbt.utility.rest.services.DnsGeneralService;
import Gbt.utility.rest.services.EventServices;
import Gbt.utility.rest.services.FPGAInfoService;
import Gbt.utility.rest.services.FanProfileService;
import Gbt.utility.rest.services.GPUInfoService;
import Gbt.utility.rest.services.IPv6Services;
import Gbt.utility.rest.services.KVMService;
import Gbt.utility.rest.services.LDAPGeneralService;
import Gbt.utility.rest.services.LDAPGroupService;
import Gbt.utility.rest.services.LoadDefaultService;
import Gbt.utility.rest.services.MultinodeService;
import Gbt.utility.rest.services.NTPService;
import Gbt.utility.rest.services.NVSwitchInfoService;
import Gbt.utility.rest.services.NodeInfoService;
import Gbt.utility.rest.services.PEFServices;
import Gbt.utility.rest.services.PamOrderService;
import Gbt.utility.rest.services.PreserveCfgService;
import Gbt.utility.rest.services.RaidServices;
import Gbt.utility.rest.services.SMBIOSService;
import Gbt.utility.rest.services.SMTPServices;
import Gbt.utility.rest.services.TrapServices;
import Gbt.utility.rest.services.VmcliUtilService;
import Gbt.utility.rest.services.VmediaService;

public final class AMIRestServiceFactory
extends RESTServiceFactory {
    public static final String FACTORY_NAME = "AMIFactory";
    private static volatile AMIRestServiceFactory factory;

    private AMIRestServiceFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final AMIRestServiceFactory getFactory() {
        if (factory != null) return factory;
        Class<AMIRestServiceFactory> clazz = AMIRestServiceFactory.class;
        synchronized (AMIRestServiceFactory.class) {
            if (factory != null) return factory;
            factory = new AMIRestServiceFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return factory;
        }
    }

    @Override
    public String getFactoryName() {
        return FACTORY_NAME;
    }

    @Override
    public RESTServices createService(String serviceName, AbstractLoggerWriter loggerWriter) {
        if (serviceName == null) {
            return null;
        }
        switch (serviceName.toLowerCase()) {
            case "adgroup": {
                return new ADGroupService(loggerWriter);
            }
            case "aduser": {
                return new ADUserService(loggerWriter);
            }
            case "audit": {
                return new AuditServices(loggerWriter);
            }
            case "backup": {
                return new BackupService(loggerWriter);
            }
            case "dns": {
                return new DnsGeneralService(loggerWriter);
            }
            case "event": {
                return new EventServices(loggerWriter);
            }
            case "ipv6": {
                return new IPv6Services(loggerWriter);
            }
            case "ldapgeneral": {
                return new LDAPGeneralService(loggerWriter);
            }
            case "ldapgroup": {
                return new LDAPGroupService(loggerWriter);
            }
            case "loaddefault": {
                return new LoadDefaultService(loggerWriter);
            }
            case "ntp": {
                return new NTPService(loggerWriter);
            }
            case "pamorder": {
                return new PamOrderService(loggerWriter);
            }
            case "pef": {
                return new PEFServices(loggerWriter);
            }
            case "preserve": {
                return new PreserveCfgService(loggerWriter);
            }
            case "raid": {
                return new RaidServices(loggerWriter);
            }
            case "smbios": {
                return new SMBIOSService(loggerWriter);
            }
            case "smtp": {
                return new SMTPServices(loggerWriter);
            }
            case "trap": {
                return new TrapServices(loggerWriter);
            }
            case "vmcli": {
                return new VmcliUtilService(loggerWriter);
            }
            case "biosmenu": {
                return new BIOSSetupService(loggerWriter);
            }
            case "ca": {
                return new CAService(loggerWriter);
            }
            case "fanprofile": {
                return new FanProfileService(loggerWriter);
            }
            case "multinode": {
                return new MultinodeService(loggerWriter);
            }
            case "vmedia": {
                return new VmediaService(loggerWriter);
            }
            case "nodeinfo": {
                return new NodeInfoService(loggerWriter);
            }
            case "kvm": {
                return new KVMService(loggerWriter);
            }
            case "gpuinfo": {
                return new GPUInfoService(loggerWriter);
            }
            case "fpgainfo": {
                return new FPGAInfoService(loggerWriter);
            }
            case "nvswitchinfo": {
                return new NVSwitchInfoService(loggerWriter);
            }
        }
        return null;
    }

    @Override
    public RESTServicesOptions getServiceOptions(RESTServices services, String optionName) {
        if (services == null) {
            return NoServiceOptions.NullOption;
        }
        if (optionName == null) {
            return NoServiceOptions.NullOption;
        }
        switch (services.getServiceName()) {
            case "adgroup": {
                return ADGroupOptions.parse(optionName);
            }
            case "aduser": {
                return ADUserOptions.parse(optionName);
            }
            case "audit": {
                return NoServiceOptions.NoOptions;
            }
            case "backup": {
                return BackupServiceOptions.parse(optionName);
            }
            case "dns": {
                return DNSGeneralOptions.parse(optionName);
            }
            case "event": {
                return NoServiceOptions.NoOptions;
            }
            case "ipv6": {
                return IPv6ServiceOptions.parse(optionName);
            }
            case "ldapgeneral": {
                return LDAPGeneralServiceOptions.parse(optionName);
            }
            case "ldapgroup": {
                return LDAPGroupServiceOptions.parse(optionName);
            }
            case "loaddefault": {
                return NoServiceOptions.NoOptions;
            }
            case "ntp": {
                return NTPServiceOptions.parse(optionName);
            }
            case "pamorder": {
                return PamOrderServiceOptions.parse(optionName);
            }
            case "pef": {
                return PEFServiceOptions.parse(optionName);
            }
            case "preserve": {
                return PreserveCfgServiceOptions.parse(optionName);
            }
            case "raid": {
                return RaidServiceOptions.parse(optionName);
            }
            case "smbios": {
                return NoServiceOptions.NoOptions;
            }
            case "smtp": {
                return SMTPServiceOptions.parse(optionName);
            }
            case "trap": {
                return TrapServiceOptions.parse(optionName);
            }
            case "vmcli": {
                return VmcliServiceOptions.parse(optionName);
            }
            case "biosmenu": {
                return BIOSSetupServiceOptions.parse(optionName);
            }
            case "ca": {
                return CAServiceOptions.parse(optionName);
            }
            case "fanprofile": {
                return FanProfileOptions.parse(optionName);
            }
            case "multinode": {
                return NoServiceOptions.NoOptions;
            }
            case "vmedia": {
                return NoServiceOptions.NoOptions;
            }
            case "nodeinfo": {
                return NoServiceOptions.NoOptions;
            }
            case "kvm": {
                return NoServiceOptions.NoOptions;
            }
            case "gpuinfo": {
                return NoServiceOptions.NoOptions;
            }
            case "fpgainfo": {
                return NoServiceOptions.NoOptions;
            }
            case "nvswitchinfo": {
                return NoServiceOptions.NoOptions;
            }
        }
        return NoServiceOptions.NullOption;
    }
}

