/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.rest.options;

import Gbt.core.jsonapi.JacksonCommonUtil;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.rest.RESTServicesOptions;
import Gbt.utility.Update.UpdateType;
import Gbt.utility.Update.fwInfo.BIOSUpdateFWInfo;
import Gbt.utility.Update.fwInfo.BMCUpdateFWInfo;
import Gbt.utility.Update.fwInfo.CPLDUpdateFWInfo;
import Gbt.utility.Update.fwInfo.FpgaUpdateFWInfo;
import Gbt.utility.Update.fwInfo.PSUUpdateFWInfo;
import Gbt.utility.Update.fwInfo.PldmUpdateFWInfo;
import Gbt.utility.Update.fwInfo.SKUUpdateFWInfo;
import Gbt.utility.Update.fwInfo.ScpUpdateFWInfo;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.util.List;

public enum UpdateServiceOptions implements RESTServicesOptions
{
    UNKNOWN(UpdateType.UNKNOWN),
    BMC(UpdateType.BMC),
    BIOS(UpdateType.BIOS),
    SCP(UpdateType.SCP),
    CPLDBPB(UpdateType.CPLDBPB),
    CPLDMB(UpdateType.CPLDMB),
    CPLDSCM(UpdateType.CPLDSCM),
    PSU(UpdateType.PSU),
    SKU(UpdateType.SKU),
    FPGA(UpdateType.FPGA),
    EROT(UpdateType.EROT),
    VBIOS(UpdateType.VBIOS);

    private final UpdateType updateType;

    private UpdateServiceOptions(UpdateType updateType) {
        this.updateType = updateType;
    }

    @Override
    public String getOptionName() {
        return this.updateType.toString();
    }

    @Override
    public JavaType getRequestPayloadType() {
        switch (this) {
            case BMC: {
                return JacksonCommonUtil.getUtil().getTypeFactory().constructType(BMCUpdateFWInfo.class);
            }
            case BIOS: {
                return JacksonCommonUtil.getUtil().getTypeFactory().constructType(BIOSUpdateFWInfo.class);
            }
            case SCP: {
                return JacksonCommonUtil.getUtil().getTypeFactory().constructType(ScpUpdateFWInfo.class);
            }
            case CPLDBPB: {
                return JacksonCommonUtil.getUtil().getTypeFactory().constructType(CPLDUpdateFWInfo.class);
            }
            case CPLDMB: {
                return JacksonCommonUtil.getUtil().getTypeFactory().constructType(CPLDUpdateFWInfo.class);
            }
            case CPLDSCM: {
                return JacksonCommonUtil.getUtil().getTypeFactory().constructType(CPLDUpdateFWInfo.class);
            }
            case PSU: {
                return JacksonCommonUtil.getUtil().getTypeFactory().constructType(PSUUpdateFWInfo.class);
            }
            case SKU: {
                return JacksonCommonUtil.getUtil().getTypeFactory().constructType(SKUUpdateFWInfo.class);
            }
            case FPGA: {
                return JacksonCommonUtil.getUtil().getTypeFactory().constructType(FpgaUpdateFWInfo.class);
            }
            case EROT: 
            case VBIOS: {
                return JacksonCommonUtil.getUtil().getTypeFactory().constructType(PldmUpdateFWInfo.class);
            }
        }
        return JacksonCommonUtil.getUtil().getTypeFactory().constructType(NullJSONData.class);
    }

    @Override
    public List<JavaType> getRequestPayloadTypes() {
        return null;
    }

    @Override
    public CollectionType getRequestPayloadCollectionType() {
        switch (this) {
            case BMC: {
                return JacksonCommonUtil.getUtil().getTypeFactory().constructCollectionType(List.class, BMCUpdateFWInfo.class);
            }
            case BIOS: {
                return JacksonCommonUtil.getUtil().getTypeFactory().constructCollectionType(List.class, BIOSUpdateFWInfo.class);
            }
            case SCP: {
                return JacksonCommonUtil.getUtil().getTypeFactory().constructCollectionType(List.class, ScpUpdateFWInfo.class);
            }
            case CPLDBPB: {
                return JacksonCommonUtil.getUtil().getTypeFactory().constructCollectionType(List.class, CPLDUpdateFWInfo.class);
            }
            case CPLDMB: {
                return JacksonCommonUtil.getUtil().getTypeFactory().constructCollectionType(List.class, CPLDUpdateFWInfo.class);
            }
            case CPLDSCM: {
                return JacksonCommonUtil.getUtil().getTypeFactory().constructCollectionType(List.class, CPLDUpdateFWInfo.class);
            }
            case PSU: {
                return JacksonCommonUtil.getUtil().getTypeFactory().constructCollectionType(List.class, PSUUpdateFWInfo.class);
            }
            case SKU: {
                return JacksonCommonUtil.getUtil().getTypeFactory().constructCollectionType(List.class, SKUUpdateFWInfo.class);
            }
            case FPGA: {
                return JacksonCommonUtil.getUtil().getTypeFactory().constructCollectionType(List.class, FpgaUpdateFWInfo.class);
            }
            case EROT: 
            case VBIOS: {
                return JacksonCommonUtil.getUtil().getTypeFactory().constructCollectionType(List.class, PldmUpdateFWInfo.class);
            }
        }
        return JacksonCommonUtil.getUtil().getTypeFactory().constructCollectionType(List.class, NullJSONData.class);
    }

    @Override
    public List<CollectionType> getRequestPayloadCollectionTypes() {
        return null;
    }

    public static final UpdateServiceOptions parse(String optionName) {
        switch (UpdateType.parse(optionName)) {
            case BMC: 
            case CMC: {
                return BMC;
            }
            case BIOS: {
                return BIOS;
            }
            case SCP: {
                return SCP;
            }
            case CPLDBPB: {
                return CPLDBPB;
            }
            case CPLDMB: {
                return CPLDMB;
            }
            case CPLDSCM: {
                return CPLDSCM;
            }
            case PSU: {
                return PSU;
            }
            case SKU: {
                return SKU;
            }
            case FPGA: {
                return FPGA;
            }
            case EROT: {
                return EROT;
            }
            case VBIOS: {
                return VBIOS;
            }
        }
        return UNKNOWN;
    }

    public static final UpdateServiceOptions parse(UpdateType updateType) {
        switch (updateType) {
            case BMC: 
            case CMC: {
                return BMC;
            }
            case BIOS: {
                return BIOS;
            }
            case SCP: {
                return SCP;
            }
            case CPLDBPB: {
                return CPLDBPB;
            }
            case CPLDMB: {
                return CPLDMB;
            }
            case CPLDSCM: {
                return CPLDSCM;
            }
            case PSU: {
                return PSU;
            }
            case SKU: {
                return SKU;
            }
            case FPGA: {
                return FPGA;
            }
            case EROT: {
                return EROT;
            }
            case VBIOS: {
                return VBIOS;
            }
        }
        return UNKNOWN;
    }
}

