/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.rest.services;

import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.JacksonCommonUtil;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.rest.RESTException;
import Gbt.core.rest.RESTHttpMethods;
import Gbt.core.rest.RESTRequest;
import Gbt.core.rest.RESTRequestImpl;
import Gbt.core.rest.RESTServices;
import Gbt.core.rest.RESTServicesOptions;
import Gbt.utility.rest.models.AMIRestPEF;
import Gbt.utility.rest.options.PEFServiceOptions;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;

public final class PEFServices
extends RESTServices {
    public static final String SERVICE_NAME = "pef";
    private static final String PEF_RESOURCE_URI = "/api/settings/pef/event_filters";
    private List<AMIRestPEF> pefDataList = new ArrayList<AMIRestPEF>();

    public PEFServices(AbstractLoggerWriter loggerWriter) {
        super(loggerWriter);
    }

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }

    @Override
    public boolean readJsonData(AbstractJSONPOJO jsonData, RESTServicesOptions restServicesOptions) {
        return true;
    }

    @Override
    public boolean readJsonFiles(List<File> dataFiles, RESTServicesOptions restServicesOptions) {
        switch (restServicesOptions.getOptionName()) {
            case "put": {
                for (File dataFile : dataFiles) {
                    try {
                        this.pefDataList.add(JacksonCommonUtil.getUtil().readJSONFile(dataFile, AMIRestPEF.class));
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                return !this.pefDataList.isEmpty();
            }
            case "delete": {
                for (File dataFile : dataFiles) {
                    try {
                        this.pefDataList.add(JacksonCommonUtil.getUtil().readJSONFile(dataFile, AMIRestPEF.class));
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                return !this.pefDataList.isEmpty();
            }
        }
        return true;
    }

    @Override
    public boolean uploadFiles(List<File> uploadFiles, RESTServicesOptions restServicesOptions) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String ipAddress, RESTServicesOptions servicesOptions) {
        String logName = ipAddress + "_" + this.logDirPath + "_" + this.getServiceName();
        if (!(servicesOptions instanceof PEFServiceOptions)) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Unknown option of " + this.getServiceName() + " service.");
            this.jsonResults.add(new NullJSONData().setError(true).setMessages("Unknown option of " + this.getServiceName() + " service."));
            return false;
        }
        RESTRequestImpl request = null;
        Response response = null;
        switch ((PEFServiceOptions)servicesOptions) {
            case GET: {
                request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHttpMethods(RESTHttpMethods.GET)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(PEF_RESOURCE_URI).setCookies(this.sessionData)).setContentType("application/json")).build();
                try {
                    response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                    JsonNode resultNode = this.clientReceiver.deserializeAsJsonNode(response);
                    this.acceptJsonResults(resultNode, AMIRestPEF.class, ipAddress, logName);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Get PEF data success.");
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, this.getJsonResultsPrettyPrintString());
                    boolean bl = true;
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Get PEF data fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Get PEF data fail."));
                    boolean bl = false;
                    return bl;
                }
                finally {
                    response.close();
                }
            }
            case PUT: {
                for (AMIRestPEF upload : this.pefDataList) {
                    request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHttpMethods(RESTHttpMethods.PUT)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(PEF_RESOURCE_URI).setServiceId(upload.getId().intValue()).setRawJsonData(upload)).setCookies(this.sessionData)).setContentType("application/json")).build();
                    try {
                        response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                        AMIRestPEF dataList = this.clientReceiver.deserialize(response, new GenericType<AMIRestPEF>(){});
                        this.jsonResults.add(dataList);
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Put PEF data success.");
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, dataList.toString());
                    }
                    catch (RESTException re) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Put PEF data fail.");
                        this.restExceptionMessages(re, ipAddress, logName);
                        this.jsonResults.add(new NullJSONData().setError(true).setMessages("Put PEF data fail."));
                        boolean bl = false;
                        return bl;
                    }
                    finally {
                        response.close();
                    }
                }
                return true;
            }
            case DELETE: {
                for (AMIRestPEF deleteupload : this.pefDataList) {
                    request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHttpMethods(RESTHttpMethods.DELETE)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(PEF_RESOURCE_URI).setServiceId(deleteupload.getId().intValue()).setCookies(this.sessionData)).setContentType("application/json")).build();
                    try {
                        response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Delete PEF data success.");
                    }
                    catch (RESTException re) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Delete PEF data fail.");
                        this.restExceptionMessages(re, ipAddress, logName);
                        this.jsonResults.add(new NullJSONData().setError(true).setMessages("Delete PEF config fail."));
                        boolean bl = false;
                        return bl;
                    }
                    finally {
                        response.close();
                    }
                }
                return true;
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Unknown option of " + this.getServiceName() + " service.");
        this.jsonResults.add(new NullJSONData().setError(true).setMessages("Unknown option of " + this.getServiceName() + " service."));
        return false;
    }
}

