/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.rest.services;

import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.JacksonCommonUtil;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.rest.RESTException;
import Gbt.core.rest.RESTHttpMethods;
import Gbt.core.rest.RESTRequest;
import Gbt.core.rest.RESTRequestImpl;
import Gbt.core.rest.RESTServices;
import Gbt.core.rest.RESTServicesOptions;
import Gbt.utility.rest.models.AMIRestTrap;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;

public final class TrapServices
extends RESTServices {
    public static final String SERVICE_NAME = "trap";
    private static final String TRAP_RESOURCE_URI = "/api/settings/pef/lan_destinations";
    private List<AMIRestTrap> trapList = new ArrayList<AMIRestTrap>();

    public TrapServices(AbstractLoggerWriter loggerWriter) {
        super(loggerWriter);
    }

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }

    @Override
    public boolean readJsonData(AbstractJSONPOJO jsonData, RESTServicesOptions restServicesOptions) {
        return true;
    }

    @Override
    public boolean readJsonFiles(List<File> dataFiles, RESTServicesOptions restServicesOptions) {
        switch (restServicesOptions.getOptionName()) {
            case "put": {
                for (File dataFile : dataFiles) {
                    try {
                        this.trapList.add(JacksonCommonUtil.getUtil().readJSONFile(dataFile, AMIRestTrap.class));
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                return this.trapList != null;
            }
            case "post": {
                for (File dataFile : dataFiles) {
                    try {
                        this.trapList.add(JacksonCommonUtil.getUtil().readJSONFile(dataFile, AMIRestTrap.class));
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                return this.trapList != null;
            }
            case "delete": {
                for (File dataFile : dataFiles) {
                    try {
                        this.trapList.add(JacksonCommonUtil.getUtil().readJSONFile(dataFile, AMIRestTrap.class));
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                return this.trapList != null;
            }
        }
        return true;
    }

    @Override
    public boolean uploadFiles(List<File> uploadFiles, RESTServicesOptions restServicesOptions) {
        return true;
    }

    @Override
    public boolean execute(String ipAddress, RESTServicesOptions servicesOptions) {
        String logName = ipAddress + "_" + this.logDirPath + "_" + this.getServiceName();
        switch (servicesOptions.getOptionName()) {
            case "get": {
                RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHttpMethods(RESTHttpMethods.GET)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(TRAP_RESOURCE_URI).setCookies(this.sessionData)).setContentType("application/json")).build();
                try {
                    Response response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                    JsonNode resultNode = this.clientReceiver.deserializeAsJsonNode(response);
                    this.acceptJsonResults(resultNode, AMIRestTrap.class, ipAddress, logName);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Get Trap service success.");
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, this.getJsonResultsPrettyPrintString());
                    return true;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Get Trap service fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Get Trap service fail."));
                    return false;
                }
            }
            case "put": {
                for (AMIRestTrap upload : this.trapList) {
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHttpMethods(RESTHttpMethods.PUT)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(TRAP_RESOURCE_URI).setServiceId(upload.getId().intValue()).setRawJsonData(upload)).setCookies(this.sessionData)).setContentType("application/json")).build();
                    try {
                        Response response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                        JsonNode resultNode = this.clientReceiver.deserializeAsJsonNode(response);
                        this.acceptJsonResults(resultNode, AMIRestTrap.class, ipAddress, logName);
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Set Trap service success.");
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, this.getJsonResultsPrettyPrintString());
                    }
                    catch (RESTException re) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Set Trap service fail.");
                        this.restExceptionMessages(re, ipAddress, logName);
                        this.jsonResults.add(new NullJSONData().setError(true).setMessages("Set Trap service fail."));
                        return false;
                    }
                }
                return true;
            }
            case "post": {
                for (AMIRestTrap upload : this.trapList) {
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHttpMethods(RESTHttpMethods.POST)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(TRAP_RESOURCE_URI).setRawJsonData(upload)).setCookies(this.sessionData)).setContentType("application/json")).build();
                    try {
                        Response response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                        AMIRestTrap dataList = this.clientReceiver.deserialize(response, new GenericType<AMIRestTrap>(){});
                        this.jsonResults.add(dataList);
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Set Trap service success.");
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, dataList.toString());
                    }
                    catch (RESTException re) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Set Trap service fail.");
                        this.restExceptionMessages(re, ipAddress, logName);
                        this.jsonResults.add(new NullJSONData().setError(true).setMessages("Set Trap service fail."));
                        return false;
                    }
                }
                return true;
            }
            case "delete": {
                for (AMIRestTrap deleteupload : this.trapList) {
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHttpMethods(RESTHttpMethods.DELETE)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(TRAP_RESOURCE_URI).setServiceId(deleteupload.getId().intValue()).setCookies(this.sessionData)).setContentType("application/json")).build();
                    try {
                        Response response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                        AMIRestTrap dataList = this.clientReceiver.deserialize(response, new GenericType<AMIRestTrap>(){});
                        this.jsonResults.add(dataList);
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Delete Trap service success.");
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, dataList.toString());
                    }
                    catch (RESTException re) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Delete Trap service fail.");
                        this.restExceptionMessages(re, ipAddress, logName);
                        this.jsonResults.add(new NullJSONData().setError(true).setMessages("Delete Trap service fail."));
                        return false;
                    }
                }
                return true;
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Unknown option of " + this.getServiceName() + " service.");
        this.jsonResults.add(new NullJSONData().setError(true).setMessages("Unknown option of " + this.getServiceName() + " service."));
        return false;
    }
}

