/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.useraccounts;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.utility.Common.GbtCommonConverters;
import Gbt.utility.bmcinfo.BMCVendor;
import Gbt.utility.useraccounts.BMCAccessPrivJSONData;
import Gbt.utility.useraccounts.UserAccountCommandActions;
import Gbt.utility.useraccounts.UserAccountIPMIOption;
import Gbt.utility.useraccounts.UserAccountJSONData;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import com.veraxsystems.vxipmi.coding.commands.PrivilegeLevel;
import java.nio.charset.StandardCharsets;

public final class UserAccountCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "userapp";
    private final GbtIPMICommandReceiver ipmiReceiver;

    protected UserAccountCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = ((Builder)this.commandArgs).bmcIP + "_" + COMMAND_NAME;
        this.ipmiReceiver = GbtIPMICommandReceiver.getInstance();
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        if (!((Builder)this.commandArgs).checkArgs()) {
            return false;
        }
        return this.ipmiReceiver != null;
    }

    @Override
    public boolean execute() {
        ConnectionHandle handle = this.ipmiReceiver.createIPMIConnection(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, COMMAND_NAME, this.commandID);
        if (handle == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI connection fail.");
            return false;
        }
        BMCVendor bmcVendor = this.ipmiReceiver.getBmcVendor(handle, COMMAND_NAME, this.commandID);
        switch (bmcVendor) {
            case VERTIV: {
                break;
            }
            case AMI: {
                break;
            }
            case OPENBMC: {
                break;
            }
            default: {
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Fail to get BMC vendor.");
                return false;
            }
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start to execute user account command.");
        StringBuilder buffer = new StringBuilder();
        switch (((Builder)this.commandArgs).actions) {
            case LIST: {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] User Account List:");
                buffer.append(String.format("%-3s | ", "ID:")).append(String.format("%-12s | ", "Name:")).append(String.format("%-10s | ", "LAN State:")).append(String.format("%-14s | ", "LAN Callin:")).append(String.format("%-14s | ", "LAN Link Auth:")).append(String.format("%-14s | ", "LAN IPMI Mesg:")).append(String.format("%-17s | ", "LAN Channel Priv:")).append(String.format("%-13s | ", "Serial State:")).append(String.format("%-17s | ", "Serial Callin:")).append(String.format("%-17s | ", "Serial Link Auth:")).append(String.format("%-17s | ", "Serial IPMI Mesg:")).append(String.format("%-20s | ", "Serial Channel Priv:")).append(String.format("%-10s", "SOL State:"));
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, buffer.toString());
                buffer.setLength(0);
                for (int i = 1; i < 17; ++i) {
                    UserAccountJSONData commandData = new UserAccountJSONData();
                    buffer.append(String.format("%-3s | ", i));
                    for (int j = 6; j < 10; ++j) {
                        AbstractJSONPOJO temp;
                        AbstractJSONPOJO resp = this.ipmiReceiver.sendIPMIRawCommand(handle, UserAccountIPMIOption.parseInt(j), ((Builder)this.commandArgs).setAccountIDNumber((byte)i), COMMAND_NAME, this.commandID);
                        if (resp instanceof NullJSONData) {
                            temp = resp.castConcreteJSON(NullJSONData.class);
                            if (((NullJSONData)temp).isError()) {
                                if (bmcVendor.isAMI()) {
                                    this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] AMI FW User list get Empty User ID ... skip ");
                                    return true;
                                }
                                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                                return false;
                            }
                            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + ((NullJSONData)temp).getMessages());
                            continue;
                        }
                        if (resp instanceof UserAccountJSONData) {
                            temp = resp.castConcreteJSON(UserAccountJSONData.class);
                            if (j == 6) {
                                commandData.setUsername(((UserAccountJSONData)temp).getUsername());
                                buffer.append(String.format("%-12s | ", ((UserAccountJSONData)temp).getUsername()));
                            } else {
                                commandData.setSOLStatus(((UserAccountJSONData)temp).isSOLEnable());
                                buffer.append(((UserAccountJSONData)temp).isSOLEnable() != false ? "Enable" : "Disable");
                            }
                            temp = null;
                            continue;
                        }
                        if (!(resp instanceof BMCAccessPrivJSONData)) continue;
                        temp = resp.castConcreteJSON(BMCAccessPrivJSONData.class);
                        if (j == 7) {
                            commandData.setLanAccessAuthentication((BMCAccessPrivJSONData)temp);
                            buffer.append(String.format("%-10s | ", ((BMCAccessPrivJSONData)temp).isEnable() ? "Enable" : "Disable")).append(String.format("%-14s | ", ((BMCAccessPrivJSONData)temp).isIPMIAvailable() ? "Available" : "Unavailable")).append(String.format("%-14s | ", ((BMCAccessPrivJSONData)temp).isLinkAvailable() ? "Available" : "Unavailable")).append(String.format("%-14s | ", ((BMCAccessPrivJSONData)temp).isCallbackAvailable() ? "Available" : "Unavailable")).append(String.format("%-17s | ", new Object[]{((BMCAccessPrivJSONData)temp).getPrivilege()}));
                            continue;
                        }
                        commandData.setSerialAccessAuthentication((BMCAccessPrivJSONData)temp);
                        buffer.append(String.format("%-13s | ", ((BMCAccessPrivJSONData)temp).isEnable() ? "Enable" : "Disable")).append(String.format("%-17s | ", ((BMCAccessPrivJSONData)temp).isIPMIAvailable() ? "Available" : "Unavailable")).append(String.format("%-17s | ", ((BMCAccessPrivJSONData)temp).isLinkAvailable() ? "Available" : "Unavailable")).append(String.format("%-17s | ", ((BMCAccessPrivJSONData)temp).isCallbackAvailable() ? "Available" : "Unavailable")).append(String.format("%-20s | ", new Object[]{((BMCAccessPrivJSONData)temp).getPrivilege()}));
                    }
                    this.commandResults.add(commandData);
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, buffer.toString());
                    buffer.setLength(0);
                }
                break;
            }
            case SET: {
                for (int i = 0; i < 6; ++i) {
                    AbstractJSONPOJO resp = this.ipmiReceiver.sendIPMIRawCommand(handle, UserAccountIPMIOption.parseInt(i), this.commandArgs, COMMAND_NAME, this.commandID);
                    if (!(resp instanceof NullJSONData)) continue;
                    NullJSONData temp = resp.castConcreteJSON(NullJSONData.class);
                    this.commandResults.add(temp);
                    if (temp.isError()) {
                        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
                        this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                        return false;
                    }
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
                }
                break;
            }
            case ENABLE: {
                NullJSONData temp;
                AbstractJSONPOJO enableResp = this.ipmiReceiver.sendIPMIRawCommand(handle, UserAccountIPMIOption.SetUserEnableCommand, this.commandArgs, COMMAND_NAME, this.commandID);
                if (enableResp instanceof NullJSONData) {
                    temp = enableResp.castConcreteJSON(NullJSONData.class);
                    this.commandResults.add(temp);
                    if (temp.isError()) {
                        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
                        this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                        return false;
                    }
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
                }
                if (!((enableResp = this.ipmiReceiver.sendIPMIRawCommand(handle, UserAccountIPMIOption.SetUserSOLEnableCommand, this.commandArgs, COMMAND_NAME, this.commandID)) instanceof NullJSONData)) break;
                temp = enableResp.castConcreteJSON(NullJSONData.class);
                this.commandResults.add(temp);
                if (temp.isError()) {
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
                    this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                    return false;
                }
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
                break;
            }
            case DISABLE: {
                NullJSONData temp;
                AbstractJSONPOJO disableResp = this.ipmiReceiver.sendIPMIRawCommand(handle, UserAccountIPMIOption.SetUserEnableCommand, this.commandArgs, COMMAND_NAME, this.commandID);
                if (disableResp instanceof NullJSONData) {
                    temp = disableResp.castConcreteJSON(NullJSONData.class);
                    this.commandResults.add(temp);
                    if (temp.isError()) {
                        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
                        this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                        return false;
                    }
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
                }
                if (!((disableResp = this.ipmiReceiver.sendIPMIRawCommand(handle, UserAccountIPMIOption.SetUserSOLEnableCommand, this.commandArgs, COMMAND_NAME, this.commandID)) instanceof NullJSONData)) break;
                temp = disableResp.castConcreteJSON(NullJSONData.class);
                this.commandResults.add(temp);
                if (temp.isError()) {
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
                    this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                    return false;
                }
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
                break;
            }
            default: {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Unknown action of user account command.");
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                return false;
            }
        }
        this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
        return true;
    }

    @Override
    public void cancelHook(Object obj) {
    }

    @Override
    public void close() throws Exception {
        ((Builder)this.commandArgs).close();
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private String bmcIP;
        private String bmcUsername = "admin";
        private String bmcPassword = "password";
        protected String accountUsername;
        protected String accountPassword;
        protected byte accountID;
        protected PrivilegeLevel privLevel = PrivilegeLevel.NoAccess;
        protected Boolean enableUser;
        protected Boolean enableSol;
        private UserAccountCommandActions actions = UserAccountCommandActions.UNKNOWN;

        @Override
        public boolean checkArgs() {
            if (this.bmcIP == null) {
                return false;
            }
            if (this.args != null) {
                if (this.args.length < 1) {
                    return false;
                }
                this.actions = UserAccountCommandActions.parse(this.args[0]);
                switch (this.actions) {
                    case LIST: {
                        if (this.args.length == 1) break;
                        this.loggerWriter.appendPath(UserAccountCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + UserAccountCommand.COMMAND_NAME, "[" + this.bmcIP + "] Invalid length of list mode.");
                        return false;
                    }
                    case SET: {
                        if (this.args.length != 5) {
                            this.loggerWriter.appendPath(UserAccountCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + UserAccountCommand.COMMAND_NAME, "[" + this.bmcIP + "] Invalid length of set mode.");
                            return false;
                        }
                        this.setAccountName(this.args[1]);
                        this.setAccountPassword(this.args[2]);
                        this.setAccountIDNumber(GbtCommonConverters.stringToByte(this.args[3]));
                        this.setPrivilegeLevel(PrivilegeLevel.parseByRawString(this.args[4]));
                        this.setEnableUser(Boolean.TRUE);
                        this.setEnableSol(Boolean.TRUE);
                        break;
                    }
                    case ENABLE: {
                        if (this.args.length != 2) {
                            this.loggerWriter.appendPath(UserAccountCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + UserAccountCommand.COMMAND_NAME, "[" + this.bmcIP + "] Invalid length of list mode.");
                            return false;
                        }
                        this.setAccountIDNumber(GbtCommonConverters.stringToByte(this.args[1]));
                        this.setEnableUser(Boolean.TRUE);
                        this.setEnableSol(Boolean.TRUE);
                        break;
                    }
                    case DISABLE: {
                        if (this.args.length != 2) {
                            this.loggerWriter.appendPath(UserAccountCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + UserAccountCommand.COMMAND_NAME, "[" + this.bmcIP + "] Invalid length of list mode.");
                            return false;
                        }
                        this.setAccountIDNumber(GbtCommonConverters.stringToByte(this.args[1]));
                        this.setEnableUser(Boolean.FALSE);
                        this.setEnableSol(Boolean.FALSE);
                        break;
                    }
                    default: {
                        this.loggerWriter.appendPath(UserAccountCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + UserAccountCommand.COMMAND_NAME, "[" + this.bmcIP + "] Unknown option of the user account command.");
                        return false;
                    }
                }
            }
            switch (this.actions) {
                case LIST: {
                    break;
                }
                case SET: {
                    if (this.accountUsername.getBytes(StandardCharsets.US_ASCII).length > 16) {
                        this.loggerWriter.appendPath(UserAccountCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + UserAccountCommand.COMMAND_NAME, "[" + this.bmcIP + "] Invalid length of username, input over 16 chars please rename");
                        return false;
                    }
                    if (this.accountPassword.getBytes(StandardCharsets.US_ASCII).length > 16) {
                        this.loggerWriter.appendPath(UserAccountCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + UserAccountCommand.COMMAND_NAME, "[" + this.bmcIP + "] Invalid length of password, input over 16 chars please rename");
                        return false;
                    }
                    if (this.accountID > 16 || this.accountID < 1) {
                        this.loggerWriter.appendPath(UserAccountCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + UserAccountCommand.COMMAND_NAME, "[" + this.bmcIP + "] Invalid user ID number : " + GbtCommonConverters.bytesToHex(this.accountID));
                        return false;
                    }
                    if (this.privLevel == PrivilegeLevel.NoAccess) {
                        this.loggerWriter.appendPath(UserAccountCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + UserAccountCommand.COMMAND_NAME, "[" + this.bmcIP + "] Invalid privilege level setting.");
                        return false;
                    }
                    if (this.enableUser == null) {
                        this.enableUser = Boolean.TRUE;
                    }
                    if (this.enableSol != null) break;
                    this.enableSol = Boolean.TRUE;
                    break;
                }
                case ENABLE: {
                    if (this.accountID > 16 || this.accountID < 1) {
                        this.loggerWriter.appendPath(UserAccountCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + UserAccountCommand.COMMAND_NAME, "[" + this.bmcIP + "] Invalid user ID number : " + GbtCommonConverters.bytesToHex(this.accountID));
                        return false;
                    }
                    if (this.enableUser == null) {
                        this.enableUser = Boolean.TRUE;
                    }
                    if (this.enableSol != null) break;
                    this.enableSol = Boolean.TRUE;
                    break;
                }
                case DISABLE: {
                    if (this.accountID > 16 || this.accountID < 1) {
                        this.loggerWriter.appendPath(UserAccountCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + UserAccountCommand.COMMAND_NAME, "[" + this.bmcIP + "] Invalid user ID number : " + GbtCommonConverters.bytesToHex(this.accountID));
                        return false;
                    }
                    if (this.enableUser == null) {
                        this.enableUser = Boolean.FALSE;
                    }
                    if (this.enableSol != null) break;
                    this.enableSol = Boolean.FALSE;
                    break;
                }
                default: {
                    this.loggerWriter.appendPath(UserAccountCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.bmcIP + "_" + UserAccountCommand.COMMAND_NAME, "[" + this.bmcIP + "] Invalid action.");
                    return false;
                }
            }
            return true;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public UserAccountCommand build() {
            return new UserAccountCommand(this);
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.bmcIP = null;
            this.bmcUsername = null;
            this.bmcPassword = null;
            this.accountUsername = null;
            this.accountPassword = null;
            this.privLevel = null;
            this.actions = null;
            this.loggerWriter.close();
        }

        public Builder setBMCIP(String bmcIP) {
            this.bmcIP = bmcIP;
            return this.getThis();
        }

        public Builder setBMCUsername(String username) {
            this.bmcUsername = username;
            return this.getThis();
        }

        public Builder setBMCPassword(String password) {
            this.bmcPassword = password;
            return this.getThis();
        }

        public Builder setAction(UserAccountCommandActions action) {
            this.actions = action;
            return this.getThis();
        }

        public Builder setAccountName(String accountUsername) {
            this.accountUsername = accountUsername;
            return this.getThis();
        }

        public Builder setAccountPassword(String accountPassword) {
            this.accountPassword = accountPassword;
            return this.getThis();
        }

        public Builder setAccountIDNumber(byte userID) {
            this.accountID = userID;
            return this.getThis();
        }

        public Builder setAccountIDNumber(int userID) {
            this.accountID = (byte)userID;
            return this.getThis();
        }

        public Builder setPrivilegeLevel(PrivilegeLevel privLevel) {
            this.privLevel = privLevel;
            return this.getThis();
        }

        public Builder setEnableUser(Boolean enableUser) {
            this.enableUser = enableUser;
            return this.getThis();
        }

        public Builder setEnableSol(Boolean enableSol) {
            this.enableSol = enableSol;
            return this.getThis();
        }
    }
}

