/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.vmclitool;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.core.receivers.GbtLocalCommandReceiver;
import Gbt.utility.bmcinfo.BMCVendor;
import Gbt.utility.vmclitool.VmcliMountInfo;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;

public final class VmcliCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "vmcli";
    private final GbtIPMICommandReceiver ipmiReceiver;
    private final GbtLocalCommandReceiver localReceiver;

    protected VmcliCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = ((Builder)this.commandArgs).vmcliMountInfo.getBmcIP() + "_" + COMMAND_NAME;
        this.ipmiReceiver = GbtIPMICommandReceiver.getInstance();
        this.localReceiver = GbtLocalCommandReceiver.getInstance();
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        if (!((Builder)this.commandArgs).checkArgs()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).vmcliMountInfo.getBmcIP() + "] Command arguments check fail.");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        ConnectionHandle handle = this.ipmiReceiver.createIPMIConnection(((Builder)this.commandArgs).vmcliMountInfo.getBmcIP(), ((Builder)this.commandArgs).vmcliMountInfo.getBmcUsername(), ((Builder)this.commandArgs).vmcliMountInfo.getBmcPassword(), COMMAND_NAME, this.commandID);
        if (handle == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).vmcliMountInfo.getBmcIP() + "] IPMI connection fail.");
            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            return false;
        }
        BMCVendor bmcVendor = this.ipmiReceiver.getBmcVendor(handle, COMMAND_NAME, this.commandID);
        switch (bmcVendor) {
            case VERTIV: {
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                break;
            }
            case AMI: 
            case OPENBMC: {
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).vmcliMountInfo.getBmcIP() + "] Not support on " + bmcVendor.toString() + " FW.");
                return false;
            }
            default: {
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).vmcliMountInfo.getBmcIP() + "] Fail to get BMC vendor.");
                return false;
            }
        }
        if (((Builder)this.commandArgs).vmcliMountInfo.isMount()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).vmcliMountInfo.getBmcIP() + "] Start to mount virtual media.");
            if (((Builder)this.commandArgs).toolPath == null || "".equals(((Builder)this.commandArgs).toolPath)) {
                this.localReceiver.changeFilePermission("tools/vmcliUtility/*", COMMAND_NAME, this.commandID);
                boolean ok = this.localReceiver.vmcliMount(((Builder)this.commandArgs).vmcliMountInfo, COMMAND_NAME, this.commandID);
                this.commandResults.add(((Builder)this.commandArgs).vmcliMountInfo);
                return ok;
            }
            boolean ok = this.localReceiver.vmcliMount(((Builder)this.commandArgs).vmcliMountInfo, ((Builder)this.commandArgs).toolPath, COMMAND_NAME, this.commandID);
            this.commandResults.add(((Builder)this.commandArgs).vmcliMountInfo);
            return ok;
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).vmcliMountInfo.getBmcIP() + "] Start to unmount virtual media.");
        if (((Builder)this.commandArgs).toolPath == null || "".equals(((Builder)this.commandArgs).toolPath)) {
            return this.localReceiver.vmcliUnmount(((Builder)this.commandArgs).vmcliMountInfo.getBmcIP(), COMMAND_NAME, this.commandID);
        }
        return this.localReceiver.vmcliUnmount(((Builder)this.commandArgs).vmcliMountInfo.getBmcIP(), ((Builder)this.commandArgs).toolPath, COMMAND_NAME, this.commandID);
    }

    @Override
    public void cancelHook(Object obj) {
    }

    @Override
    public void close() throws Exception {
        ((Builder)this.commandArgs).close();
    }

    public static class Builder
    extends AbstractCommandBuilder<Builder> {
        private VmcliMountInfo vmcliMountInfo = new VmcliMountInfo();
        private String toolPath;

        public Builder() {
            this.vmcliMountInfo.setBmcUsername("admin");
            this.vmcliMountInfo.setBmcPassword("password");
            this.toolPath = null;
        }

        @Override
        public boolean checkArgs() {
            if (this.args != null) {
                if (this.args.length < 1) {
                    return false;
                }
                switch (this.args[0]) {
                    case "unmount": {
                        if (this.args.length > 1) {
                            return false;
                        }
                        this.vmcliMountInfo.setMount(false);
                        return true;
                    }
                    case "mount": {
                        if (this.args.length == 1) {
                            this.loggerWriter.appendPath(VmcliCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.vmcliMountInfo.getBmcIP() + "_" + VmcliCommand.COMMAND_NAME, "[" + this.vmcliMountInfo.getBmcIP() + "] No more arguments for mount operation, please see the help message or docs");
                            return false;
                        }
                        if ((this.args.length - 1) % 2 == 1) {
                            this.loggerWriter.appendPath(VmcliCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.vmcliMountInfo.getBmcIP() + "_" + VmcliCommand.COMMAND_NAME, "[" + this.vmcliMountInfo.getBmcIP() + "] Invalid data length for mount operation.");
                            return false;
                        }
                        block20: for (int i = 1; i < this.args.length; i += 2) {
                            switch (this.args[i]) {
                                case "port": {
                                    this.loggerWriter.appendPath(VmcliCommand.COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.vmcliMountInfo.getBmcIP() + "_" + VmcliCommand.COMMAND_NAME, "[" + this.vmcliMountInfo.getBmcIP() + "] Accept arguments : " + this.args[i] + ", which set as " + this.args[i + 1]);
                                    this.vmcliMountInfo.setPort(Integer.parseInt(this.args[i + 1]));
                                    continue block20;
                                }
                                case "cdrom": {
                                    this.loggerWriter.appendPath(VmcliCommand.COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.vmcliMountInfo.getBmcIP() + "_" + VmcliCommand.COMMAND_NAME, "[" + this.vmcliMountInfo.getBmcIP() + "] Accept arguments : " + this.args[i] + ", which set as " + this.args[i + 1]);
                                    this.vmcliMountInfo.setCdROM(this.args[i + 1]);
                                    continue block20;
                                }
                                case "floppy": {
                                    this.loggerWriter.appendPath(VmcliCommand.COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.vmcliMountInfo.getBmcIP() + "_" + VmcliCommand.COMMAND_NAME, "[" + this.vmcliMountInfo.getBmcIP() + "] Accept arguments : " + this.args[i] + ", which set as " + this.args[i + 1]);
                                    this.vmcliMountInfo.setFloppy(this.args[i + 1]);
                                    continue block20;
                                }
                                case "removable": {
                                    this.loggerWriter.appendPath(VmcliCommand.COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.vmcliMountInfo.getBmcIP() + "_" + VmcliCommand.COMMAND_NAME, "[" + this.vmcliMountInfo.getBmcIP() + "] Accept arguments : " + this.args[i] + ", which set as " + this.args[i + 1]);
                                    this.vmcliMountInfo.setRemovable(this.args[i + 1]);
                                    continue block20;
                                }
                                default: {
                                    this.loggerWriter.appendPath(VmcliCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.vmcliMountInfo.getBmcIP() + "_" + VmcliCommand.COMMAND_NAME, "[" + this.vmcliMountInfo.getBmcIP() + "] Invalid arguments : " + this.args[i] + ", which value is : " + this.args[i + 1]);
                                    return false;
                                }
                            }
                        }
                        this.vmcliMountInfo.setMount(true);
                        return true;
                    }
                }
                this.loggerWriter.appendPath(VmcliCommand.COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.vmcliMountInfo.getBmcIP() + "_" + VmcliCommand.COMMAND_NAME, "[" + this.vmcliMountInfo.getBmcIP() + "] Invalid sub mode of vmcli command");
                return false;
            }
            if (this.vmcliMountInfo.getBmcIP() == null) {
                return false;
            }
            if (this.vmcliMountInfo.isMount()) {
                return this.vmcliMountInfo.getPort() != 0 || this.vmcliMountInfo.getCdROM() != null || this.vmcliMountInfo.getFloppy() != null || this.vmcliMountInfo.getRemovable() != null;
            }
            return true;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public VmcliCommand build() {
            return new VmcliCommand(this);
        }

        public Builder setBMCIP(String bmcIP) {
            this.vmcliMountInfo.setBmcIP(bmcIP);
            return this.getThis();
        }

        public Builder setBMCUsername(String username) {
            this.vmcliMountInfo.setBmcUsername(username);
            return this.getThis();
        }

        public Builder setBMCPassword(String password) {
            this.vmcliMountInfo.setBmcPassword(password);
            return this.getThis();
        }

        public Builder setToolPath(String toolPath) {
            this.toolPath = toolPath;
            return this.getThis();
        }

        public Builder mount() {
            this.vmcliMountInfo.setMount(true);
            return this.getThis();
        }

        public Builder unmount() {
            this.vmcliMountInfo.setMount(false);
            return this.getThis();
        }

        public Builder setFreePort(int port) {
            this.vmcliMountInfo.setPort(port);
            return this.getThis();
        }

        public Builder setISOImages(String iso) {
            this.vmcliMountInfo.setCdROM(iso);
            return this.getThis();
        }

        public Builder setFloppyImages(String floppy) {
            this.vmcliMountInfo.setFloppy(floppy);
            return this.getThis();
        }

        public Builder setRemovableDev(String removable) {
            this.vmcliMountInfo.setRemovable(removable);
            return this.getThis();
        }

        public Builder setvmcliMountInfo(VmcliMountInfo vmcliMountInfo) {
            this.vmcliMountInfo = vmcliMountInfo;
            return this.getThis();
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.loggerWriter.close();
        }
    }
}

