/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.api.async;

import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import com.veraxsystems.vxipmi.api.async.InboundMessageListener;
import com.veraxsystems.vxipmi.api.async.IpmiResponseListener;
import com.veraxsystems.vxipmi.api.async.messages.IpmiError;
import com.veraxsystems.vxipmi.api.async.messages.IpmiResponse;
import com.veraxsystems.vxipmi.api.async.messages.IpmiResponseData;
import com.veraxsystems.vxipmi.coding.PayloadCoder;
import com.veraxsystems.vxipmi.coding.commands.PrivilegeLevel;
import com.veraxsystems.vxipmi.coding.commands.ResponseData;
import com.veraxsystems.vxipmi.coding.commands.session.GetChannelAuthenticationCapabilitiesResponseData;
import com.veraxsystems.vxipmi.coding.payload.IpmiPayload;
import com.veraxsystems.vxipmi.coding.protocol.PayloadType;
import com.veraxsystems.vxipmi.coding.security.CipherSuite;
import com.veraxsystems.vxipmi.connection.Connection;
import com.veraxsystems.vxipmi.connection.ConnectionException;
import com.veraxsystems.vxipmi.connection.ConnectionListener;
import com.veraxsystems.vxipmi.connection.ConnectionManager;
import com.veraxsystems.vxipmi.connection.Session;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;

public class IpmiAsyncConnector
implements ConnectionListener {
    public static final String FAILED_TO_RECEIVE_ANSWER_CAUSE_MESSAGE = "Failed to receive answer, cause:";
    private ConnectionManager connectionManager;
    private int retries;
    private final List<IpmiResponseListener> responseListeners = new ArrayList<IpmiResponseListener>();
    private final List<InboundMessageListener> inboundMessageListeners = new ArrayList<InboundMessageListener>();

    public IpmiAsyncConnector(int port) throws IOException {
        this.connectionManager = new ConnectionManager(port);
    }

    public IpmiAsyncConnector(int port, InetAddress address) throws IOException {
        this.connectionManager = new ConnectionManager(port, address);
    }

    public ConnectionHandle createConnection(InetAddress address, int port) {
        ConnectionHandle handle = this.connectionManager.createConnection(address, port);
        this.connectionManager.getConnection(handle).registerListener(this);
        return handle;
    }

    public List<CipherSuite> getAvailableCipherSuites(ConnectionHandle connectionHandle) throws ConnectionException {
        int tries = 0;
        List<CipherSuite> result = null;
        while (tries <= this.retries && result == null) {
            try {
                ++tries;
                result = this.connectionManager.getAvailableCipherSuites(connectionHandle);
            }
            catch (ConnectionException e) {
                if (tries <= this.retries) continue;
                throw e;
            }
        }
        return result;
    }

    public GetChannelAuthenticationCapabilitiesResponseData getChannelAuthenticationCapabilities(ConnectionHandle connectionHandle, List<CipherSuite> cipherSuites, PrivilegeLevel requestedPrivilegeLevel) throws ConnectionException {
        int tries = 0;
        GetChannelAuthenticationCapabilitiesResponseData result = null;
        while (tries <= this.retries && result == null) {
            try {
                ++tries;
                result = this.connectionManager.getChannelAuthenticationCapabilities(connectionHandle, cipherSuites, requestedPrivilegeLevel);
            }
            catch (ConnectionException ce) {
                if (tries <= this.retries) continue;
                throw ce;
            }
        }
        return result;
    }

    public Session openSession(ConnectionHandle connectionHandle, String username, String password, byte[] bmcKey) throws Exception {
        Session session = null;
        int tries = 0;
        boolean succeded = false;
        connectionHandle.setUser(username);
        connectionHandle.setPassword(password);
        while (tries <= this.retries && !succeded) {
            try {
                ++tries;
                int sessionId = this.connectionManager.startSession(connectionHandle, connectionHandle.getCipherSuite(), connectionHandle.getPrivilegeLevel(), username, password, bmcKey);
                session = this.connectionManager.registerSession(sessionId, connectionHandle);
                succeded = true;
            }
            catch (Exception e) {
                if (tries <= this.retries) continue;
                throw e;
            }
        }
        return session;
    }

    public Session getExistingSessionForCriteria(InetAddress remoteAddress, int remotePort, String user) {
        return this.connectionManager.getSessionForCriteria(remoteAddress, remotePort, user);
    }

    public void closeSession(ConnectionHandle connectionHandle) throws ConnectionException {
        if (!this.connectionManager.getConnection(connectionHandle).isSessionValid()) {
            return;
        }
        int tries = 0;
        boolean succeded = false;
        while (tries <= this.retries && !succeded) {
            try {
                ++tries;
                this.connectionManager.getConnection(connectionHandle).closeSession();
                this.connectionManager.unregisterSession(connectionHandle);
                succeded = true;
            }
            catch (ConnectionException ce) {
                if (tries <= this.retries) continue;
                throw ce;
            }
        }
    }

    public int sendMessage(ConnectionHandle connectionHandle, PayloadCoder request, boolean isOneWay) throws Exception {
        int tries = 0;
        int tag = -1;
        while (tries <= this.retries && tag < 0) {
            try {
                ++tries;
                while (tag < 0) {
                    tag = this.connectionManager.getConnection(connectionHandle).sendMessage(request, isOneWay);
                    if (tag >= 0) continue;
                    Thread.sleep(10L);
                }
            }
            catch (IllegalArgumentException iae) {
                throw iae;
            }
            catch (Exception e) {
                if (tries <= this.retries) continue;
                throw e;
            }
        }
        return tag;
    }

    public int retry(ConnectionHandle connectionHandle, int tag, PayloadType messagePayloadType) throws ConnectionException {
        return this.connectionManager.getConnection(connectionHandle).retry(tag, messagePayloadType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(IpmiResponseListener listener) {
        List<IpmiResponseListener> list = this.responseListeners;
        synchronized (list) {
            this.responseListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListener(IpmiResponseListener listener) {
        List<IpmiResponseListener> list = this.responseListeners;
        synchronized (list) {
            this.responseListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerIncomingPayloadListener(InboundMessageListener listener) {
        List<InboundMessageListener> list = this.inboundMessageListeners;
        synchronized (list) {
            this.inboundMessageListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterIncomingPayloadListener(InboundMessageListener listener) {
        List<InboundMessageListener> list = this.inboundMessageListeners;
        synchronized (list) {
            this.inboundMessageListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processResponse(ResponseData responseData, String handle, int tag, Exception exception) {
        IpmiResponse response = null;
        Connection connection = this.connectionManager.getConnection(handle);
        if (responseData == null || exception != null) {
            Exception notNullException = exception != null ? exception : new Exception("Empty response");
            response = new IpmiError(notNullException, tag, new ConnectionHandle(handle, connection.getRemoteMachineAddress(), connection.getRemoteMachinePort()));
        } else {
            response = new IpmiResponseData(responseData, tag, new ConnectionHandle(handle, connection.getRemoteMachineAddress(), connection.getRemoteMachinePort()));
        }
        List<IpmiResponseListener> list = this.responseListeners;
        synchronized (list) {
            for (IpmiResponseListener listener : this.responseListeners) {
                if (listener == null) continue;
                listener.notify(response);
            }
        }
    }

    @Override
    public void processRequest(String handle, IpmiPayload payload) {
        for (InboundMessageListener listener : this.inboundMessageListeners) {
            if (!listener.isPayloadSupported(payload)) continue;
            listener.notify(handle, payload);
        }
    }

    public void closeConnection(ConnectionHandle handle) {
        this.connectionManager.getConnection(handle).unregisterListener(this);
        this.connectionManager.closeConnection(handle);
    }

    public void tearDown() {
        this.connectionManager.close();
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public void setTimeout(ConnectionHandle handle, int timeout) {
        this.connectionManager.getConnection(handle).setTimeout(timeout);
    }

    public int sendRmcpPingMessage(ConnectionHandle connectionHandle) throws ConnectionException {
        return this.connectionManager.sendRmcpPingMessage(connectionHandle);
    }
}

