/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.api.sync;

import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import com.veraxsystems.vxipmi.api.async.IpmiResponseListener;
import com.veraxsystems.vxipmi.api.async.messages.IpmiError;
import com.veraxsystems.vxipmi.api.async.messages.IpmiResponse;
import com.veraxsystems.vxipmi.api.async.messages.IpmiResponseData;
import com.veraxsystems.vxipmi.coding.commands.ResponseData;
import com.veraxsystems.vxipmi.common.PropertiesManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MessageListener
implements IpmiResponseListener {
    private ConnectionHandle handle;
    private int tag;
    private IpmiResponse response;
    private final int max_retries;
    private static final int MAX_WAITING_COUNT = 3000;
    private List<IpmiResponse> quickMessages = new ArrayList<IpmiResponse>();

    public MessageListener(ConnectionHandle handle) throws IOException {
        PropertiesManager manager = PropertiesManager.getInstance();
        this.max_retries = Integer.parseInt(manager.getProperty("retries"));
        this.handle = handle;
        this.tag = -1;
        this.response = null;
    }

    public ResponseData waitForAnswer(int tag) throws Exception {
        if (tag < 0 || tag > 63) {
            throw new Exception("Corrupted message tag");
        }
        int retry = 0;
        this.tag = tag;
        do {
            int count = 0;
            for (IpmiResponse response : this.quickMessages) {
                this.notify(response);
            }
            while (this.response == null && count < 3000) {
                Thread.sleep(1L);
                ++count;
            }
        } while (++retry < this.max_retries && this.response == null);
        if (this.response instanceof IpmiResponseData) {
            this.tag = -1;
            this.quickMessages.clear();
            return ((IpmiResponseData)this.response).getResponseData();
        }
        throw ((IpmiError)this.response).getException();
    }

    @Override
    public synchronized void notify(IpmiResponse response) {
        if (response.getHandle().getConnectionHandleId().equals(this.handle.getConnectionHandleId())) {
            if (this.tag == -1) {
                this.quickMessages.add(response);
            } else if (response.getTag() == this.tag) {
                this.response = response;
            }
        }
    }
}

