/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.coding.commands;

import com.veraxsystems.vxipmi.coding.PayloadCoder;
import com.veraxsystems.vxipmi.coding.commands.IpmiVersion;
import com.veraxsystems.vxipmi.coding.commands.PrivilegeLevel;
import com.veraxsystems.vxipmi.coding.payload.IpmiPayload;
import com.veraxsystems.vxipmi.coding.payload.PlainMessage;
import com.veraxsystems.vxipmi.coding.payload.lan.IpmiLanResponse;
import com.veraxsystems.vxipmi.coding.payload.lan.NetworkFunction;
import com.veraxsystems.vxipmi.coding.protocol.AuthenticationType;
import com.veraxsystems.vxipmi.coding.protocol.IpmiMessage;
import com.veraxsystems.vxipmi.coding.protocol.PayloadType;
import com.veraxsystems.vxipmi.coding.security.CipherSuite;

public abstract class IpmiCommandCoder
extends PayloadCoder {
    public IpmiCommandCoder() {
    }

    public IpmiCommandCoder(IpmiVersion version, CipherSuite cipherSuite, AuthenticationType authenticationType) {
        super(version, cipherSuite, authenticationType);
    }

    @Override
    public PayloadType getSupportedPayloadType() {
        return PayloadType.Ipmi;
    }

    public boolean isCommandResponse(IpmiMessage message) {
        if (message.getPayload() instanceof IpmiPayload) {
            if (message.getPayload() instanceof IpmiLanResponse) {
                return ((IpmiLanResponse)message.getPayload()).getCommand() == this.getCommandCode();
            }
            return message.getPayload() instanceof PlainMessage;
        }
        return false;
    }

    public abstract byte getCommandCode();

    public abstract NetworkFunction getNetworkFunction();

    protected byte encodePrivilegeLevel(PrivilegeLevel privilegeLevel) {
        switch (privilegeLevel) {
            case MaximumAvailable: {
                return 0;
            }
            case Callback: {
                return 1;
            }
            case User: {
                return 2;
            }
            case Operator: {
                return 3;
            }
            case Administrator: {
                return 4;
            }
        }
        throw new IllegalArgumentException("Invalid privilege level");
    }
}

