/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.coding.protocol.encoder;

import com.veraxsystems.vxipmi.coding.protocol.AuthenticationType;
import com.veraxsystems.vxipmi.coding.protocol.IpmiMessage;
import com.veraxsystems.vxipmi.coding.protocol.Ipmiv15Message;
import com.veraxsystems.vxipmi.coding.protocol.encoder.ProtocolEncoder;
import com.veraxsystems.vxipmi.common.TypeConverter;
import java.security.InvalidKeyException;

public class Protocolv15Encoder
extends ProtocolEncoder {
    @Override
    public byte[] encode(IpmiMessage ipmiMessage) throws InvalidKeyException {
        byte[] payload;
        if (!(ipmiMessage instanceof Ipmiv15Message)) {
            throw new IllegalArgumentException("IPMIMessage must be in 1.5 version.");
        }
        Ipmiv15Message message = (Ipmiv15Message)ipmiMessage;
        byte[] raw = new byte[this.getMessageLength(message) - 1];
        raw[0] = this.encodeAuthenticationType(message.getAuthenticationType());
        int offset = 1;
        this.encodeSessionSequenceNumber(message.getSessionSequenceNumber(), raw, offset);
        this.encodeSessionId(message.getSessionID(), raw, offset += 4);
        offset += 4;
        if (message.getAuthenticationType() != AuthenticationType.None) {
            this.encodeAuthenticationCode(message.getAuthCode(), raw, offset);
            offset += message.getAuthCode().length;
        }
        if ((payload = message.getPayload().getEncryptedPayload()) == null) {
            message.getPayload().encryptPayload(message.getConfidentialityAlgorithm());
            payload = message.getPayload().getEncryptedPayload();
        }
        this.encodePayloadLength(payload.length, raw, offset);
        ++offset;
        offset = this.encodePayload(payload, raw, offset);
        return raw;
    }

    private int getMessageLength(IpmiMessage ipmiMessage) {
        int length = 11 + ipmiMessage.getConfidentialityAlgorithm().getConfidentialityOverheadSize(ipmiMessage.getPayloadLength()) + ipmiMessage.getPayloadLength();
        if (ipmiMessage.getAuthenticationType() != AuthenticationType.None) {
            length += 16;
        }
        return length;
    }

    private void encodeAuthenticationCode(byte[] authCode, byte[] message, int offset) {
        if (authCode.length + offset > message.length) {
            throw new IndexOutOfBoundsException("Message is too short");
        }
        System.arraycopy(authCode, 0, message, offset, authCode.length);
    }

    @Override
    protected void encodePayloadLength(int value, byte[] message, int offset) {
        message[offset] = TypeConverter.intToByte(value);
    }

    protected int encodeSessionTrailer(byte[] message, int offset) {
        if (1 + offset > message.length) {
            throw new IndexOutOfBoundsException("Message is too short");
        }
        message[offset] = 0;
        return offset + 1;
    }
}

