/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.coding.rmcp;

import com.veraxsystems.vxipmi.coding.rmcp.RmcpClassOfMessage;
import com.veraxsystems.vxipmi.coding.rmcp.RmcpMessage;
import com.veraxsystems.vxipmi.coding.rmcp.RmcpVersion;
import com.veraxsystems.vxipmi.common.TypeConverter;

public final class RmcpDecoder {
    private RmcpDecoder() {
    }

    public static RmcpMessage decode(byte[] rawMessage) {
        RmcpMessage message = new RmcpMessage();
        message.setVersion(RmcpDecoder.decodeVersion(rawMessage[0]));
        message.setSequenceNumber(RmcpDecoder.decodeSequenceNumber(rawMessage[2]));
        message.setClassOfMessage(RmcpDecoder.decodeClassOfMessage(rawMessage[3]));
        message.setData(RmcpDecoder.decodeData(rawMessage));
        return message;
    }

    private static RmcpVersion decodeVersion(byte version) {
        if (version == 6) {
            return RmcpVersion.RMCP1_0;
        }
        return RmcpVersion.UNKNOWN;
    }

    private static int decodeSequenceNumber(byte sequenceNumber) {
        return TypeConverter.byteToInt(sequenceNumber);
    }

    private static RmcpClassOfMessage decodeClassOfMessage(byte classOfMessage) {
        return RmcpClassOfMessage.parseInt(TypeConverter.byteToInt(classOfMessage) & 0x9F);
    }

    private static byte[] decodeData(byte[] rawMessage) {
        byte[] data = new byte[rawMessage.length - 4];
        System.arraycopy(rawMessage, 4, data, 0, data.length);
        return data;
    }
}

