/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.commands;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.DefaultLoggerWriter;

public abstract class AbstractCommandBuilder<T extends AbstractCommandBuilder<T>> {
    protected String[] args;
    protected AbstractLoggerWriter loggerWriter = new DefaultLoggerWriter(this.getClass());

    protected AbstractCommandBuilder() {
    }

    public final T setCommandLineArgs(String[] args) {
        this.args = args;
        return this.getThis();
    }

    public final T setLoggerWriter(AbstractLoggerWriter loggerWriter) {
        this.loggerWriter = loggerWriter;
        return this.getThis();
    }

    protected final String parseArgsByKeywords(String keywords) {
        for (String arg : this.args) {
            if (!arg.contains(keywords)) continue;
            return arg.substring(arg.lastIndexOf(keywords) + keywords.length());
        }
        return null;
    }

    public abstract boolean checkArgs();

    protected abstract T getThis();

    public abstract AbstractCommand<T> build();

    public abstract void close() throws Exception;
}

