/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.loggers;

public enum GbtLogLevel {
    TRACE(5, "trace"),
    DEBUG(4, "debug"),
    INFO(3, "info"),
    WARN(2, "warning"),
    ERROR(1, "error"),
    NONE(0, "none");

    public static final int TRACE_LEVEL = 5;
    public static final int DEBUG_LEVEL = 4;
    public static final int INFO_LEVEL = 3;
    public static final int WARN_LEVEL = 2;
    public static final int ERROR_LEVEL = 1;
    public static final int NONE_LEVEL = 0;
    public static final String TRACE_LEVEL_ITEM = "trace";
    public static final String DEBUG_LEVEL_ITEM = "debug";
    public static final String INFO_LEVEL_ITEM = "info";
    public static final String WARN_LEVEL_ITEM = "warning";
    public static final String ERROR_LEVEL_ITEM = "error";
    public static final String NONE_LEVEL_ITEM = "none";
    private final int level;
    private final String level_item;

    private GbtLogLevel(int level, String level_item) {
        this.level = level;
        this.level_item = level_item;
    }

    public int getLevel() {
        return this.level;
    }

    public String toString() {
        return this.level_item;
    }

    public static final GbtLogLevel parse(String logLevel) {
        if (logLevel == null) {
            return NONE;
        }
        switch (logLevel.toLowerCase()) {
            case "trace": {
                return TRACE;
            }
            case "debug": {
                return DEBUG;
            }
            case "info": {
                return INFO;
            }
            case "warning": {
                return WARN;
            }
            case "error": {
                return ERROR;
            }
            case "fatal": {
                return ERROR;
            }
        }
        return NONE;
    }

    public static final GbtLogLevel parse(int logLevel) {
        switch (logLevel) {
            case 5: {
                return TRACE;
            }
            case 4: {
                return DEBUG;
            }
            case 3: {
                return INFO;
            }
            case 2: {
                return WARN;
            }
            case 1: {
                return ERROR;
            }
        }
        return NONE;
    }
}

