/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.receivers;

import Gbt.core.engines.records.EngineRecordStates;
import Gbt.core.engines.records.EngineRecords;
import Gbt.core.engines.records.SSHCmdRecords;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.AbstractCommandReceiver;
import Gbt.core.receivers.GbtLocalCommandReceiver;
import Gbt.core.receivers.async.AsyncSshExecuteCmdTask;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.Future;

public final class GbtSSHCommandReceiver
extends AbstractCommandReceiver {
    private static volatile GbtSSHCommandReceiver sshReceiver;
    private static final int BUFFER_SIZE = 512;
    private volatile JSch jsch;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GbtSSHCommandReceiver() {
        if (this.jsch == null) {
            GbtSSHCommandReceiver gbtSSHCommandReceiver = this;
            synchronized (gbtSSHCommandReceiver) {
                if (this.jsch == null) {
                    this.jsch = new JSch();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final GbtSSHCommandReceiver getInstance() {
        if (sshReceiver != null) return sshReceiver;
        Class<GbtSSHCommandReceiver> clazz = GbtSSHCommandReceiver.class;
        synchronized (GbtSSHCommandReceiver.class) {
            if (sshReceiver != null) return sshReceiver;
            sshReceiver = new GbtSSHCommandReceiver();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sshReceiver;
        }
    }

    @Override
    public String getReceiverName() {
        return "Gbt SSH Receiver";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean closeReceivers() {
        if (sshReceiver != null) {
            Class<GbtSSHCommandReceiver> clazz = GbtSSHCommandReceiver.class;
            synchronized (GbtSSHCommandReceiver.class) {
                if (sshReceiver != null) {
                    try {
                        sshReceiver.close();
                        sshReceiver = null;
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return true;
                    }
                    catch (Exception e) {
                        this.taskPool.shutdownNow();
                        this.taskPool = null;
                        this.writeLogs(GbtLogLevel.ERROR, this.getReceiverName(), this.getReceiverName(), "Close " + this.getReceiverName() + " fail.", e);
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return false;
                    }
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return true;
            }
        }
        return true;
    }

    public Session openSession(String ipAddress, String username, String password, String commandName, String commandID) {
        Session session = null;
        try {
            session = this.jsch.getSession(username, ipAddress, 22);
            session.setConfig("StrictHostKeyChecking", "no");
            session.setPassword(password);
        }
        catch (JSchException je) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "[" + ipAddress + "] Create SSH session fail.");
            return session;
        }
        try {
            session.connect();
        }
        catch (JSchException je) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "[" + ipAddress + "] SSH session connection fail.");
            return session;
        }
        return session;
    }

    public Session openSession(String ipAddress, String username, String password) {
        return this.openSession(ipAddress, username, password, this.getReceiverName(), ipAddress + "_" + this.getReceiverName());
    }

    public void closeSession(Session session, String commandName, String commandID) {
        if (session == null) {
            this.writeLogs(GbtLogLevel.DEBUG, commandName, commandID, "The given session is null.");
            return;
        }
        if (session.isConnected()) {
            this.writeLogs(GbtLogLevel.DEBUG, commandName, commandID, "[" + session.getHost() + "] SSH session disconnected.");
            session.disconnect();
        }
    }

    public void closeSession(Session session) {
        this.closeSession(session, this.getReceiverName(), session.getHost() + "_" + this.getReceiverName());
    }

    public SSHCmdRecords executeCMD(Session session, String command, int timeout, boolean redirection, String commandName, String commandID) {
        SSHCmdRecords records = new SSHCmdRecords(commandID);
        if (redirection && !command.endsWith("2>&1")) {
            command = command + " 2>&1";
        }
        if (session == null) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "The given session instance is null.");
            return records.setStates(EngineRecordStates.Fail).addErrors("The given session instance is null.");
        }
        if (!session.isConnected()) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "[" + session.getHost() + "] SSH session is not connected.");
            return records.setStates(EngineRecordStates.Fail).addErrors("[" + session.getHost() + "] SSH session is not connected.");
        }
        byte[] bytesBuffer = new byte[512];
        StringBuilder resultBuffer = new StringBuilder();
        StringBuilder errorBuffer = new StringBuilder();
        ChannelExec channel = null;
        try {
            session.setTimeout(timeout);
            channel = (ChannelExec)session.openChannel("exec");
            channel.setErrStream((OutputStream)System.err);
            channel.setCommand(command);
            OutputStream writeStream = channel.getOutputStream();
            InputStream readStream = channel.getInputStream();
            InputStream errorStream = channel.getErrStream();
            channel.connect();
            writeStream.flush();
            block3: while (!Thread.currentThread().isInterrupted() && !channel.isClosed()) {
                int i;
                while (readStream.available() > 0 && (i = readStream.read(bytesBuffer, 0, bytesBuffer.length)) >= 0) {
                    resultBuffer.append(new String(bytesBuffer, 0, i));
                    if (resultBuffer.length() > 0) {
                        for (String lines : resultBuffer.toString().split("[\\r\\n]+")) {
                            records.addMessages(lines);
                            this.writeLogs(GbtLogLevel.TRACE, commandName, commandID, lines);
                        }
                        resultBuffer.setLength(0);
                    }
                    if (!Thread.currentThread().isInterrupted()) continue;
                    channel.disconnect();
                    this.closeSession(session, commandName, commandID);
                    this.writeLogs(GbtLogLevel.WARN, commandName, commandID, "[" + session.getHost() + "] Interrupted SSH connection while reading response.");
                    if (i < 0) {
                        if (writeStream != null) {
                            writeStream.close();
                            this.writeLogs(GbtLogLevel.WARN, commandName, commandID, "[" + session.getHost() + "] Interrupted SSH request write stream.");
                        }
                        if (readStream == null) break;
                        readStream.close();
                        this.writeLogs(GbtLogLevel.WARN, commandName, commandID, "[" + session.getHost() + "] Interrupted SSH normal response read stream.");
                        break;
                    }
                    writeStream.write(3);
                    writeStream.flush();
                }
                while (errorStream.available() > 0 && (i = errorStream.read(bytesBuffer, 0, bytesBuffer.length)) >= 0) {
                    errorBuffer.append(new String(bytesBuffer, 0, i));
                    if (errorBuffer.length() > 0) {
                        for (String lines : errorBuffer.toString().split("[\\r\\n]+")) {
                            records.addErrors(lines);
                            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, lines);
                        }
                        errorBuffer.setLength(0);
                    }
                    if (!Thread.currentThread().isInterrupted()) continue;
                    channel.disconnect();
                    this.closeSession(session, commandName, commandID);
                    this.writeLogs(GbtLogLevel.WARN, commandName, commandID, "[" + session.getHost() + "] Interrupted SSH connection while reading error response.");
                    if (i < 0) {
                        if (writeStream != null) {
                            writeStream.close();
                            this.writeLogs(GbtLogLevel.WARN, commandName, commandID, "[" + session.getHost() + "] Interrupted SSH request write stream.");
                        }
                        if (errorStream == null) continue block3;
                        errorStream.close();
                        this.writeLogs(GbtLogLevel.WARN, commandName, commandID, "[" + session.getHost() + "] Interrupted SSH error response read stream.");
                        continue block3;
                    }
                    writeStream.write(3);
                    writeStream.flush();
                }
            }
            if (Thread.currentThread().isInterrupted()) {
                if (writeStream != null) {
                    writeStream.close();
                    this.writeLogs(GbtLogLevel.WARN, commandName, commandID, "[" + session.getHost() + "] Interrupted SSH request write stream.");
                }
                if (readStream != null) {
                    readStream.close();
                    this.writeLogs(GbtLogLevel.WARN, commandName, commandID, "[" + session.getHost() + "] Interrupted SSH normal response read stream.");
                }
                if (errorStream != null) {
                    errorStream.close();
                    this.writeLogs(GbtLogLevel.WARN, commandName, commandID, "[" + session.getHost() + "] Interrupted SSH error response read stream.");
                }
                channel.disconnect();
                this.writeLogs(GbtLogLevel.WARN, commandName, commandID, "[" + session.getHost() + "] SSH channel interrupted.");
                this.closeSession(session, commandName, commandID);
                return records.setStates(EngineRecordStates.Fail);
            }
            if (writeStream != null) {
                writeStream.close();
                this.writeLogs(GbtLogLevel.TRACE, commandName, commandID, "[" + session.getHost() + "] Close SSH request write stream.");
            }
            if (readStream != null) {
                readStream.close();
                this.writeLogs(GbtLogLevel.TRACE, commandName, commandID, "[" + session.getHost() + "] Close SSH normal response read stream.");
            }
            if (errorStream != null) {
                errorStream.close();
                this.writeLogs(GbtLogLevel.TRACE, commandName, commandID, "[" + session.getHost() + "] Close SSH error response read stream.");
            }
            channel.disconnect();
            this.writeLogs(GbtLogLevel.TRACE, commandName, commandID, "[" + session.getHost() + "] SSH channel disconnected.");
            return records.setStates(records.containsError() ? EngineRecordStates.Fail : EngineRecordStates.Pass);
        }
        catch (JSchException je) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "[" + session.getHost() + "] SSH channel open fail.", je);
            this.closeSession(session, commandName, commandID);
            return records.setStates(EngineRecordStates.Fail).addErrors("[" + session.getHost() + "] SSH channel open fail : " + je.getMessage());
        }
        catch (IOException ioe) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "[" + session.getHost() + "] SSH channel I/O exceptions.", ioe);
            this.closeSession(session, commandName, commandID);
            return records.setStates(EngineRecordStates.Fail).addErrors("[" + session.getHost() + "] SSH channel I/O exceptions : " + ioe.getMessage());
        }
    }

    public SSHCmdRecords executeCMD(Session session, String command, boolean redirection, String commandName, String commandID) {
        return this.executeCMD(session, command, 5000, redirection, commandName, commandID);
    }

    public SSHCmdRecords executeCMD(Session session, String command, int timeout, boolean redirection) {
        return this.executeCMD(session, command, timeout, redirection, this.getReceiverName(), session.getHost() + "_" + this.getReceiverName());
    }

    public SSHCmdRecords executeCMD(Session session, String command, boolean redirection) {
        return this.executeCMD(session, command, 5000, redirection, this.getReceiverName(), session.getHost() + "_" + this.getReceiverName());
    }

    public Future<EngineRecords> asynExecuteCMD(Session session, String command, int timeout, boolean redirection, String commandName, String commandID) {
        return this.taskPool.submit(((AsyncSshExecuteCmdTask.Builder)new AsyncSshExecuteCmdTask.Builder().setSession(session).setReqCmd(command).setTimeout(timeout).setRedirection(redirection).setLogFolderName(commandName).setTaskName(commandID)).build());
    }

    public Future<EngineRecords> asynExecuteCMD(Session session, String command, int timeout, boolean redirection) {
        return this.taskPool.submit(((AsyncSshExecuteCmdTask.Builder)new AsyncSshExecuteCmdTask.Builder().setSession(session).setReqCmd(command).setTimeout(timeout).setRedirection(redirection).setLogFolderName(this.getReceiverName()).setTaskName(session.getHost() + "_" + this.getReceiverName())).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSHCmdRecords executeShell(Session session, String shell, String commandName, String commandID) {
        SSHCmdRecords records = new SSHCmdRecords(commandID);
        if (session == null) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "The given session instance is null.");
            return records.setStates(EngineRecordStates.Fail).addErrors("The given session instance is null.");
        }
        if (!session.isConnected()) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "[" + session.getHost() + "] SSH session is not connected.");
            return records.setStates(EngineRecordStates.Fail).addErrors("[" + session.getHost() + "] SSH session is not connected.");
        }
        Channel channel = null;
        OutputStream writeStream = null;
        InputStream readStream = null;
        try {
            channel = session.openChannel("shell");
            writeStream = channel.getOutputStream();
            readStream = channel.getInputStream();
            channel.connect();
        }
        catch (JSchException je) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "SSH channel open fail.", je);
            this.closeSession(session, commandName, commandID);
            return records.setStates(EngineRecordStates.Fail).addErrors("SSH channel open fail.");
        }
        catch (IOException ioe) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "SSH I/O channel exceptions.", ioe);
            this.closeSession(session, commandName, commandID);
            return records.setStates(EngineRecordStates.Fail).addErrors("SSH I/O channel exceptions.");
        }
        PrintStream commander = new PrintStream(writeStream, true);
        commander.println(shell);
        commander.println("exit");
        commander.close();
        byte[] bytesBuffer = new byte[512];
        StringBuilder resultBuffer = new StringBuilder();
        try {
            while (true) {
                int i;
                if (readStream.available() > 0 && (i = readStream.read(bytesBuffer, 0, bytesBuffer.length)) >= 0) {
                    resultBuffer.append(new String(bytesBuffer, 0, i));
                    if (!Thread.currentThread().isInterrupted()) continue;
                    if (channel.isConnected()) {
                        channel.disconnect();
                        this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "[" + session.getHost() + "] Interrupted SSH connection.");
                    }
                    if (writeStream != null) {
                        writeStream.close();
                        this.writeLogs(GbtLogLevel.DEBUG, commandName, commandID, "[" + session.getHost() + "] Interrupted SSH request write stream.");
                    }
                    if (readStream != null) {
                        readStream.close();
                        this.writeLogs(GbtLogLevel.DEBUG, commandName, commandID, "[" + session.getHost() + "] Interrupted SSH normal response read stream.");
                    }
                }
                if (channel.isClosed()) break;
            }
            if (resultBuffer.length() > 0) {
                for (String lines : resultBuffer.toString().split("[\\r\\n]+")) {
                    records.addMessages(lines);
                    this.writeLogs(GbtLogLevel.TRACE, commandName, commandID, lines);
                }
                resultBuffer.setLength(0);
            }
            if (records.containsError() || Thread.interrupted()) {
                SSHCmdRecords i = records.setStates(EngineRecordStates.Fail);
                return i;
            }
            SSHCmdRecords i = records.setStates(EngineRecordStates.Pass);
            return i;
        }
        catch (IOException ioe) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "[" + session.getHost() + "] I/O error exception : ", ioe);
            SSHCmdRecords sSHCmdRecords = records.setStates(EngineRecordStates.Fail).addErrors("[" + session.getHost() + "] I/O error exception : " + ioe.getMessage());
            return sSHCmdRecords;
        }
        finally {
            try {
                if (channel.isConnected()) {
                    channel.disconnect();
                    this.writeLogs(GbtLogLevel.DEBUG, commandName, commandID, "[" + session.getHost() + "] SSH channel disconnected.");
                }
                if (writeStream != null) {
                    writeStream.close();
                    this.writeLogs(GbtLogLevel.DEBUG, commandName, commandID, "[" + session.getHost() + "] SSH write stream closed.");
                }
                if (readStream != null) {
                    readStream.close();
                    this.writeLogs(GbtLogLevel.DEBUG, commandName, commandID, "[" + session.getHost() + "] SSH read stream closed.");
                }
            }
            catch (IOException ioe) {
                this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "[" + session.getHost() + "] I/O stream close error exception : ", ioe);
                records.setStates(EngineRecordStates.Fail).addErrors("[" + session.getHost() + "] I/O stream close error exception : ");
            }
        }
    }

    public SSHCmdRecords executeShell(Session session, String shell) {
        return this.executeShell(session, shell, this.getReceiverName(), session.getHost() + "_" + this.getReceiverName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSHCmdRecords scp(Session session, File srcFile, String dstPath, String commandName, String commandID) {
        SSHCmdRecords records = new SSHCmdRecords(commandID);
        if (session == null) {
            this.writeLogs(GbtLogLevel.DEBUG, commandName, commandID, "The given session is null.");
            return records.setStates(EngineRecordStates.Fail).addErrors("The given session is null.");
        }
        this.writeLogs(GbtLogLevel.DEBUG, commandName, commandID, "Start copy " + srcFile.getName() + " to " + session.getUserName() + "@" + session.getHost() + ":" + dstPath);
        if (!session.isConnected()) {
            return records.setStates(EngineRecordStates.Fail).addErrors("SSH session is not connected.");
        }
        Channel channel = null;
        OutputStream writeStream = null;
        InputStream readStream = null;
        FileInputStream fis = null;
        StringBuilder commandBuilder = new StringBuilder("scp -p -t " + dstPath);
        try {
            channel = session.openChannel("exec");
            ((ChannelExec)channel).setCommand(commandBuilder.toString());
            writeStream = channel.getOutputStream();
            readStream = channel.getInputStream();
            channel.connect();
            if (this.checkAck(readStream, commandName, commandID) != 0) {
                this.closeSession(session, commandName, commandID);
                SSHCmdRecords sSHCmdRecords = records.setStates(EngineRecordStates.Fail).addErrors("SCP response errors.");
                return sSHCmdRecords;
            }
            commandBuilder.setLength(0);
            commandBuilder.append("T ").append(srcFile.lastModified() / 1000L).append(" 0").append(" ").append(srcFile.lastModified() / 1000L).append(" 0\n");
            writeStream.write(commandBuilder.toString().getBytes());
            writeStream.flush();
            if (this.checkAck(readStream, commandName, commandID) != 0) {
                commandBuilder.setLength(0);
                this.closeSession(session, commandName, commandID);
                SSHCmdRecords sSHCmdRecords = records.setStates(EngineRecordStates.Fail).addErrors("SCP response errors.");
                return sSHCmdRecords;
            }
            commandBuilder.setLength(0);
            long filesize = srcFile.length();
            commandBuilder.append("C0644 ").append(filesize).append(" ");
            if (srcFile.getAbsolutePath().lastIndexOf(File.separator) > 0) {
                commandBuilder.append(srcFile.getAbsolutePath().substring(srcFile.getAbsolutePath().lastIndexOf(File.separator) + 1)).append("\n");
            } else {
                commandBuilder.append(srcFile.getAbsolutePath()).append("\n");
            }
            writeStream.write(commandBuilder.toString().getBytes());
            writeStream.flush();
            if (this.checkAck(readStream, commandName, commandID) != 0) {
                commandBuilder.setLength(0);
                this.closeSession(session, commandName, commandID);
                SSHCmdRecords sSHCmdRecords = records.setStates(EngineRecordStates.Fail).addErrors("SCP response errors.");
                return sSHCmdRecords;
            }
            commandBuilder.setLength(0);
            fis = new FileInputStream(srcFile);
            byte[] buffer = new byte[1024];
            while (true) {
                if (Thread.currentThread().isInterrupted()) {
                    readStream.close();
                    writeStream.close();
                    this.closeSession(session, commandName, commandID);
                    SSHCmdRecords ioe = records.setStates(EngineRecordStates.Fail).addErrors("SCP command interrupt.");
                    return ioe;
                }
                int len = fis.read(buffer, 0, buffer.length);
                if (len <= 0) break;
                writeStream.write(buffer, 0, len);
            }
            buffer[0] = 0;
            writeStream.write(buffer, 0, 1);
            writeStream.flush();
            if (this.checkAck(readStream, commandName, commandID) != 0) {
                this.closeSession(session, commandName, commandID);
                SSHCmdRecords sSHCmdRecords = records.setStates(EngineRecordStates.Fail).addErrors("SCP response errors.");
                return sSHCmdRecords;
            }
            SSHCmdRecords sSHCmdRecords = records.addMessages("SCP complete and success.").setStates(EngineRecordStates.Pass);
            return sSHCmdRecords;
        }
        catch (JSchException je) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "SSH channel open fail.", je);
            this.closeSession(session, commandName, commandID);
            SSHCmdRecords sSHCmdRecords = records.setStates(EngineRecordStates.Fail).addErrors("SSH channel open fail.");
            return sSHCmdRecords;
        }
        catch (IOException ioe) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "SSH I/O channel exceptions.", ioe);
            this.closeSession(session, commandName, commandID);
            SSHCmdRecords sSHCmdRecords = records.setStates(EngineRecordStates.Fail).addErrors("SSH I/O channel exceptions.");
            return sSHCmdRecords;
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
            try {
                writeStream.close();
                readStream.close();
                fis.close();
            }
            catch (IOException ioe) {
                this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "I/O stream close error exception : ", ioe);
                records.setStates(EngineRecordStates.Fail);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSHCmdRecords scpDownload(Session session, String srcPath, String dstPath, String dstName, String commandName, String commandID) {
        SSHCmdRecords records = new SSHCmdRecords(commandID);
        if (session == null) {
            this.writeLogs(GbtLogLevel.DEBUG, commandName, commandID, "The given session is null.");
            return records.setStates(EngineRecordStates.Fail).addErrors("The given session is null.");
        }
        this.writeLogs(GbtLogLevel.DEBUG, commandName, commandID, "Start download " + session.getUserName() + "@" + session.getHost() + ":" + srcPath + " to " + dstPath);
        if (!session.isConnected()) {
            return records.setStates(EngineRecordStates.Fail).addErrors("SSH session is not connected.");
        }
        Channel channel = null;
        OutputStream outputStream = null;
        InputStream inputStream = null;
        StringBuilder commandBuilder = new StringBuilder("scp -r -d -f " + srcPath);
        try {
            int c;
            channel = session.openChannel("exec");
            ((ChannelExec)channel).setCommand(commandBuilder.toString());
            outputStream = channel.getOutputStream();
            inputStream = channel.getInputStream();
            channel.connect();
            byte[] buffer = new byte[1024];
            buffer[0] = 0;
            boolean outputStreamOffset = false;
            boolean outputStreamLength = true;
            outputStream.write(buffer, 0, 1);
            outputStream.flush();
            while ((c = this.checkAck(inputStream, commandName, commandID)) == 67) {
                int foo;
                inputStream.read(buffer, 0, 5);
                long filesize = 0L;
                while (inputStream.read(buffer, 0, 1) >= 0 && buffer[0] != 32) {
                    filesize = filesize * 10L + (long)(buffer[0] - 48);
                }
                String file = null;
                int i = 0;
                while (true) {
                    inputStream.read(buffer, i, 1);
                    if (buffer[i] == 10) break;
                    ++i;
                }
                file = new String(buffer, 0, i);
                buffer[0] = 0;
                outputStream.write(buffer, 0, 1);
                outputStream.flush();
                if (dstName != null && !dstName.equals("")) {
                    file = dstName;
                }
                FileOutputStream fos = new FileOutputStream(dstPath + File.separator + file);
                do {
                    foo = (long)buffer.length < filesize ? buffer.length : (int)filesize;
                    if ((foo = inputStream.read(buffer, 0, foo)) < 0) break;
                    fos.write(buffer, 0, foo);
                } while ((filesize -= (long)foo) != 0L);
                fos.close();
                fos = null;
                if (this.checkAck(inputStream, commandName, commandID) != 0) break;
                buffer[0] = 0;
                outputStream.write(buffer, 0, 1);
                outputStream.flush();
            }
            SSHCmdRecords sSHCmdRecords = records.addMessages("SCP download complete and success.").setStates(EngineRecordStates.Pass);
            return sSHCmdRecords;
        }
        catch (JSchException je) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "SSH channel open fail.", je);
            this.closeSession(session, commandName, commandID);
            SSHCmdRecords sSHCmdRecords = records.setStates(EngineRecordStates.Fail).addErrors("SSH channel open fail.");
            return sSHCmdRecords;
        }
        catch (IOException ioe) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "SSH I/O channel exceptions.", ioe);
            this.closeSession(session, commandName, commandID);
            SSHCmdRecords sSHCmdRecords = records.setStates(EngineRecordStates.Fail).addErrors("SSH I/O channel exceptions.");
            return sSHCmdRecords;
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
            try {
                outputStream.close();
                inputStream.close();
            }
            catch (IOException ioe) {
                this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "I/O stream close error exception : ", ioe);
                records.setStates(EngineRecordStates.Fail);
            }
        }
    }

    public SSHCmdRecords scp(Session session, File srcFile, String dstPath) {
        return this.scp(session, srcFile, dstPath, this.getReceiverName(), session.getHost() + "_" + this.getReceiverName());
    }

    public SSHCmdRecords scpDownload(Session session, String srcPath, String dstPath) {
        return this.scpDownload(session, srcPath, dstPath, null, this.getReceiverName(), session.getHost() + "_" + this.getReceiverName());
    }

    public SSHCmdRecords scpDownload(Session session, String srcPath, String dstPath, String dstName) {
        return this.scpDownload(session, srcPath, dstPath, dstName, this.getReceiverName(), session.getHost() + "_" + this.getReceiverName());
    }

    public boolean pingLAN(String ipAddress, String commandName, String commandID) {
        try {
            InetAddress address = InetAddress.getByName(ipAddress);
            Thread.sleep(1050L);
            if (address.isReachable(5250)) {
                this.writeLogs(GbtLogLevel.INFO, commandName, commandID, ipAddress + " is alive.");
                return true;
            }
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, ipAddress + " is unreachable.");
            return false;
        }
        catch (UnknownHostException ue) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "Unknown host : " + ipAddress, ue);
            return false;
        }
        catch (IOException ioe) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "Network connection fail.", ioe);
            return false;
        }
        catch (InterruptedException ie) {
            this.writeLogs(GbtLogLevel.WARN, commandName, commandID, "Interrupt the check IP alive process.", ie);
            return false;
        }
    }

    public boolean pingLAN(String ipAddress) {
        return this.pingLAN(ipAddress, this.getReceiverName(), ipAddress + "_" + this.getReceiverName());
    }

    public Session waitBootComplete(String ipAddress, String username, String password, int maxRetry, String commandName, String commandID) {
        int count = 0;
        Session session = null;
        do {
            ++count;
            if (Thread.currentThread().isInterrupted()) {
                this.writeLogs(GbtLogLevel.WARN, commandName, commandID, "Interrupt the process of try open SSH session.");
                break;
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ie) {
                this.writeLogs(GbtLogLevel.WARN, commandName, commandID, "Interrupt the process of try open SSH session.");
                break;
            }
            if (!this.pingLAN(ipAddress, commandName, commandID)) {
                if (count > maxRetry) {
                    this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "[" + ipAddress + "] Target boot timeout ... (" + count + ")");
                    break;
                }
                this.writeLogs(GbtLogLevel.INFO, commandName, commandID, "[" + ipAddress + "] Wait for target boot complete ... (" + count + ")");
                continue;
            }
            session = this.openSession(ipAddress, username, password, commandName, commandID);
            if (!session.isConnected()) {
                if (count > maxRetry) {
                    this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "[" + ipAddress + "] Target boot timeout ... (" + count + ")");
                    break;
                }
                this.writeLogs(GbtLogLevel.INFO, commandName, commandID, "[" + ipAddress + "] Wait for target boot complete ... (" + count + ")");
                continue;
            }
            this.writeLogs(GbtLogLevel.INFO, commandName, commandID, "[" + ipAddress + "] Target boot complete ... (" + count + ")");
            break;
        } while (count <= maxRetry);
        return session;
    }

    public Session waitBootComplete(String ipAddress, String username, String password, int maxRetry) {
        return this.waitBootComplete(ipAddress, username, password, maxRetry, this.getReceiverName(), ipAddress + "_" + this.getReceiverName());
    }

    public Session waitBootCompleteByMac(String mac, String username, String password, int maxRetry, String commandName, String commandID) {
        int count = 0;
        String ipAddress = "0.0.0.0";
        if (!mac.contains(":")) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < mac.length(); i += 2) {
                if (i == mac.length() - 2) {
                    builder.append(mac.substring(i));
                    continue;
                }
                builder.append(mac, i, i + 2).append(":");
            }
            mac = builder.toString();
        }
        Session session = null;
        do {
            ++count;
            if (Thread.currentThread().isInterrupted()) {
                this.writeLogs(GbtLogLevel.WARN, commandName, commandID, "Interrupt the process of try open SSH session.");
                break;
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ie) {
                this.writeLogs(GbtLogLevel.WARN, commandName, commandID, "Interrupt the process of try open SSH session.");
                break;
            }
            ipAddress = GbtLocalCommandReceiver.getInstance().findDHCPIPbyMAC(mac, commandName, commandID);
            if (ipAddress.equals("0.0.0.0")) {
                if (count > maxRetry) {
                    this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "[" + ipAddress + "] Target boot timeout ... (" + count + ")");
                    break;
                }
                this.writeLogs(GbtLogLevel.INFO, commandName, commandID, "[" + ipAddress + "] Wait for target boot complete ... (" + count + ")");
                continue;
            }
            if (!this.pingLAN(ipAddress, commandName, commandID)) {
                if (count > maxRetry) {
                    this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "[" + ipAddress + "] Target boot timeout ... (" + count + ")");
                    break;
                }
                this.writeLogs(GbtLogLevel.INFO, commandName, commandID, "[" + ipAddress + "] Wait for target boot complete ... (" + count + ")");
                continue;
            }
            session = this.openSession(ipAddress, username, password, commandName, commandID);
            if (!session.isConnected()) {
                if (count > maxRetry) {
                    this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "[" + ipAddress + "] Target boot timeout ... (" + count + ")");
                    break;
                }
                this.writeLogs(GbtLogLevel.INFO, commandName, commandID, "[" + ipAddress + "] Wait for target boot complete ... (" + count + ")");
                continue;
            }
            this.writeLogs(GbtLogLevel.INFO, commandName, commandID, "[" + ipAddress + "] Target boot complete ... (" + count + ")");
            break;
        } while (count <= maxRetry);
        return session;
    }

    public Session waitBootCompleteByMac(String mac, String username, String password, int maxRetry) {
        return this.waitBootCompleteByMac(mac, username, password, maxRetry, this.getReceiverName(), mac.replace(":", "") + "_" + this.getReceiverName());
    }

    private int checkAck(InputStream in, String commandName, String commandID) throws IOException {
        int b = in.read();
        if (b == 0) {
            return b;
        }
        if (b == -1) {
            return b;
        }
        if (b == 1 || b == 2) {
            int c;
            StringBuilder sb = new StringBuilder();
            do {
                c = in.read();
                sb.append((char)c);
            } while (!Thread.currentThread().isInterrupted() && c != 10);
            if (b == 1) {
                this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "SCP error.");
                this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, sb.toString());
                sb.setLength(0);
            }
            if (b == 2) {
                this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, "SCP response inputstream error.");
                this.writeLogs(GbtLogLevel.ERROR, commandName, commandID, sb.toString());
                sb.setLength(0);
            }
        }
        return b;
    }
}

