/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.receivers;

import Gbt.core.engines.records.EngineRecordStates;
import Gbt.core.engines.records.SolMessageRecords;
import Gbt.core.ipmi.GbtIPMIConnector;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.AbstractCommandReceiver;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.core.receivers.async.SolMessageListener;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import com.veraxsystems.vxipmi.api.sol.SOLException;
import com.veraxsystems.vxipmi.api.sol.SerialOverLan;
import com.veraxsystems.vxipmi.api.sync.IpmiConnector;
import com.veraxsystems.vxipmi.coding.commands.PrivilegeLevel;
import com.veraxsystems.vxipmi.coding.commands.payload.DeactivatePayload;
import com.veraxsystems.vxipmi.coding.commands.payload.DeactivatePayloadResponseData;
import com.veraxsystems.vxipmi.coding.protocol.PayloadType;
import com.veraxsystems.vxipmi.coding.security.CipherSuite;
import com.veraxsystems.vxipmi.connection.Session;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class SolCommandReceiver
extends AbstractCommandReceiver {
    private static final String RECEIVER_NAME = "Gbt Sol Receiver";
    private static volatile SolCommandReceiver solReceiver;
    private IpmiConnector ipmiConnector;
    private volatile Map<String, SolMessageListener> messageListeners = new ConcurrentHashMap<String, SolMessageListener>();
    private volatile Map<String, Future<SolMessageRecords>> futures = new ConcurrentHashMap<String, Future<SolMessageRecords>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final SolCommandReceiver getInstance() {
        if (solReceiver != null) return solReceiver;
        Class<SolCommandReceiver> clazz = SolCommandReceiver.class;
        synchronized (SolCommandReceiver.class) {
            if (solReceiver != null) return solReceiver;
            solReceiver = new SolCommandReceiver();
            // ** MonitorExit[var0] (shouldn't be in output)
            return solReceiver;
        }
    }

    private SolCommandReceiver() {
        try {
            this.ipmiConnector = GbtIPMIConnector.getConnector();
        }
        catch (IOException ioe) {
            this.writeLogs(GbtLogLevel.ERROR, this.getReceiverName(), this.getReceiverName(), "Cannot get IPMI connector.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean closeReceivers() {
        if (solReceiver != null) {
            SolCommandReceiver solCommandReceiver = this;
            synchronized (solCommandReceiver) {
                if (solReceiver != null) {
                    try {
                        if (!this.futures.isEmpty()) {
                            for (String ipAddress : this.futures.keySet()) {
                                Future<SolMessageRecords> taskFuture = this.futures.get(ipAddress);
                                if (taskFuture.isDone()) continue;
                                taskFuture.cancel(true);
                                do {
                                    Thread.sleep(1L);
                                } while (!taskFuture.isDone());
                            }
                            this.futures.clear();
                            this.messageListeners.clear();
                        }
                        solReceiver.close();
                        solReceiver = null;
                        return true;
                    }
                    catch (Exception e) {
                        this.taskPool.shutdownNow();
                        this.taskPool = null;
                        this.writeLogs(GbtLogLevel.ERROR, this.getReceiverName(), this.getReceiverName(), "Close " + this.getReceiverName() + " fail.", e);
                        return false;
                    }
                }
                return true;
            }
        }
        return true;
    }

    @Override
    public String getReceiverName() {
        return RECEIVER_NAME;
    }

    public SerialOverLan activateSol(String IP, String username, String password, String commandName) throws SOLException {
        ConnectionHandle handle = null;
        try {
            handle = this.ipmiConnector.createConnection(InetAddress.getByName(IP));
            this.writeLogs(GbtLogLevel.TRACE, commandName, IP + "_" + commandName, "[" + IP + "] Connection created.");
            List<CipherSuite> css = this.ipmiConnector.getAvailableCipherSuites(handle);
            this.writeLogs(GbtLogLevel.TRACE, commandName, IP + "_" + commandName, "[" + IP + "] Get available cipher suites.");
            this.ipmiConnector.getChannelAuthenticationCapabilities(handle, css, PrivilegeLevel.Administrator);
            this.writeLogs(GbtLogLevel.TRACE, commandName, IP + "_" + commandName, "[" + IP + "] Channel authentication capabilities receivied.");
            Session session = this.ipmiConnector.openSession(handle, username, password, null);
            this.writeLogs(GbtLogLevel.TRACE, commandName, IP + "_" + commandName, "[" + IP + "] IPMI session open success.");
            SerialOverLan serialOverLan = new SerialOverLan(this.ipmiConnector, session);
            this.writeLogs(GbtLogLevel.TRACE, commandName, IP + "_" + commandName, "[" + IP + "] Sol activate success.");
            return serialOverLan;
        }
        catch (FileNotFoundException fe) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, IP + "_" + commandName, "[" + IP + "] The vxipmi properties not found.");
            this.writeLogs(GbtLogLevel.ERROR, commandName, IP + "_" + commandName, "[" + IP + "] " + fe.getMessage());
            GbtIPMICommandReceiver.getInstance().closeIPMIConnection(handle, commandName, IP + "_" + commandName);
            throw new SOLException("[" + IP + "] The vxipmi properties not found.", fe);
        }
        catch (UnknownHostException ue) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, IP + "_" + commandName, "[" + IP + "] Unknown host : " + IP);
            GbtIPMICommandReceiver.getInstance().closeIPMIConnection(handle, commandName, IP + "_" + commandName);
            throw new SOLException("[" + IP + "] Unknown host : " + IP, ue);
        }
        catch (IOException ioe) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, IP + "_" + commandName, "[" + IP + "] The vxipmi properties parameters read error.");
            this.writeLogs(GbtLogLevel.ERROR, commandName, IP + "_" + commandName, "[" + IP + "] " + ioe.getMessage());
            GbtIPMICommandReceiver.getInstance().closeIPMIConnection(handle, commandName, IP + "_" + commandName);
            throw new SOLException("[" + IP + "] The vxipmi properties parameters read error.", ioe);
        }
        catch (Exception e) {
            this.writeLogs(GbtLogLevel.ERROR, commandName, IP + "_" + commandName, "[" + IP + "] " + e.getMessage());
            GbtIPMICommandReceiver.getInstance().closeIPMIConnection(handle, commandName, IP + "_" + commandName);
            throw new SOLException("[" + IP + "] " + e.getMessage(), e);
        }
    }

    public SolMessageRecords sendCommand(SerialOverLan serialOverLan, String requestMessages, String commandName, int timeout) {
        serialOverLan.writeBytes(this.rebuildRequestByte(requestMessages));
        String ip = serialOverLan.getSession().getConnectionHandle().getRemoteAddress().getHostAddress();
        SolMessageRecords solRecords = new SolMessageRecords(ip + "_" + commandName);
        int count = 0;
        while (!Thread.currentThread().isInterrupted() && count < timeout) {
            String text = serialOverLan.readString();
            if (!text.isEmpty()) {
                solRecords.appendMessages(text);
                count = 0;
                continue;
            }
            try {
                Thread.sleep(1L);
                ++count;
            }
            catch (InterruptedException ie) {
                break;
            }
        }
        if (solRecords.getFullMessages().length() > 0) {
            for (String lineMessage : solRecords.getFullMessages().split("\\r?\\n")) {
                if (lineMessage.equals(requestMessages)) continue;
                solRecords.addLineMessages(lineMessage);
                this.writeLogs(GbtLogLevel.INFO, commandName, solRecords.getRecordsID(), lineMessage);
            }
        }
        return solRecords.setStates(EngineRecordStates.Pass);
    }

    public boolean asyncSendCommand(SerialOverLan serialOverLan, String requestMessages, String commandName) {
        String ip = serialOverLan.getSession().getConnectionHandle().getRemoteAddress().getHostAddress();
        if (!this.futures.containsKey(ip)) {
            this.messageListeners.put(ip, new SolMessageListener(serialOverLan, commandName));
            this.futures.put(ip, this.taskPool.submit(this.messageListeners.get(ip)));
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return serialOverLan.writeBytes(this.rebuildRequestByte(requestMessages));
    }

    public SolMessageRecords getAsyncCommandRecords(SerialOverLan serialOverLan) {
        String ip = serialOverLan.getSession().getConnectionHandle().getRemoteAddress().getHostAddress();
        if (this.messageListeners.containsKey(ip)) {
            return this.messageListeners.get(ip).getSolRecords();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolMessageRecords deactivateSol(SerialOverLan sol, String commandName) throws IOException {
        String targetIP = sol.getSession().getConnectionHandle().getRemoteAddress().getHostAddress();
        if (!this.futures.containsKey(targetIP)) {
            sol.close();
            this.writeLogs(GbtLogLevel.INFO, commandName, targetIP + "_" + commandName, "[" + targetIP + "] SOL deactivate success.");
            return null;
        }
        block7: for (String string : this.futures.keySet()) {
            if (!string.equals(targetIP)) continue;
            Future<SolMessageRecords> taskFuture = this.futures.get(string);
            if (taskFuture.isDone()) break;
            taskFuture.cancel(true);
            do {
                this.writeLogs(GbtLogLevel.INFO, commandName, string + "_" + commandName, "[" + string + "] Waiting for SOL message listener terminate.");
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ie) {
                    break block7;
                }
            } while (!taskFuture.isDone());
            break;
        }
        sol.close();
        this.writeLogs(GbtLogLevel.INFO, commandName, targetIP + "_" + commandName, "[" + targetIP + "] SOL deactivate success.");
        try {
            SolMessageRecords records = this.futures.get(targetIP).get();
            this.writeLogs(records.getStates().isPass() ? GbtLogLevel.INFO : GbtLogLevel.ERROR, commandName, targetIP + "_" + commandName, "[" + targetIP + "] SOL record status : " + (Object)((Object)records.getStates()));
            SolMessageRecords solMessageRecords = records;
            return solMessageRecords;
        }
        catch (InterruptedException | CancellationException | ExecutionException fe) {
            SolMessageRecords solMessageRecords = this.messageListeners.get(targetIP).getSolRecords();
            this.writeLogs(GbtLogLevel.DEBUG, commandName, targetIP + "_" + commandName, "[" + targetIP + "] Sol Message listener has interrupted.");
            this.writeLogs(solMessageRecords.getStates().isPass() ? GbtLogLevel.INFO : GbtLogLevel.ERROR, commandName, targetIP + "_" + commandName, "[" + targetIP + "] SOL record status : " + (Object)((Object)solMessageRecords.getStates()));
            SolMessageRecords solMessageRecords2 = solMessageRecords;
            return solMessageRecords2;
        }
        finally {
            this.futures.remove(targetIP);
            this.messageListeners.remove(targetIP);
        }
    }

    public DeactivatePayloadResponseData deactivateSol(ConnectionHandle connectionHandle, String commandName) throws IOException {
        try {
            DeactivatePayload deactivatePayload = new DeactivatePayload(connectionHandle.getCipherSuite(), PayloadType.Sol, 1);
            DeactivatePayloadResponseData responseData = (DeactivatePayloadResponseData)this.ipmiConnector.sendMessage(connectionHandle, deactivatePayload);
            return responseData;
        }
        catch (Exception e) {
            throw new IOException("Error while closing Serial over LAN instance", e);
        }
    }

    private byte[] rebuildRequestByte(String requestMessages) {
        if (requestMessages == null) {
            return new byte[]{13, 10};
        }
        if (requestMessages.equals("")) {
            return new byte[]{13, 10};
        }
        byte[] orgBytes = requestMessages.getBytes();
        byte[] buffer = new byte[orgBytes.length + 1];
        System.arraycopy(orgBytes, 0, buffer, 0, orgBytes.length);
        buffer[orgBytes.length] = 13;
        return buffer;
    }
}

