/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.redfish;

import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.redfish.RedfishApiOptions;
import Gbt.core.redfish.RedfishApiService;
import Gbt.core.rest.RESTProtocolHeaders;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public abstract class RedfishApiPayload<T extends RedfishApiPayload<T, P>, P extends RedfishApiOptions> {
    protected String ipAddress;
    protected String username;
    protected String password;
    protected int port;
    protected AbstractLoggerWriter loggerWriter;
    protected P serviceOption;
    protected String[] restRawArgs;
    protected File uploadJsonFile;
    protected boolean debug = false;
    protected RESTProtocolHeaders protocolHeader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RedfishApiPayload(String ipAddress, AbstractLoggerWriter loggerWriter) {
        this.ipAddress = ipAddress;
        this.loggerWriter = loggerWriter;
        this.protocolHeader = RESTProtocolHeaders.HTTPS;
        Properties props = new Properties();
        try {
            props.load(this.getClass().getResourceAsStream("/properties/gbtutil.properties"));
            this.username = props.getProperty("gbtutil.redfish.username");
            this.password = props.getProperty("gbtutil.redfish.password");
        }
        catch (IOException ioe) {
            this.username = "admin";
            this.password = "password";
        }
        finally {
            props.clear();
        }
    }

    public RedfishApiPayload(String ipAddress, String username, String password, AbstractLoggerWriter loggerWriter) {
        this.ipAddress = ipAddress;
        this.username = username;
        this.password = password;
        this.loggerWriter = loggerWriter;
        this.protocolHeader = RESTProtocolHeaders.HTTPS;
    }

    protected abstract T getThis();

    public abstract RedfishApiService<T> build();

    public final T setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this.getThis();
    }

    public final T setUsername(String username) {
        this.username = username;
        return this.getThis();
    }

    public final T setPassword(String password) {
        this.password = password;
        return this.getThis();
    }

    public final T setPort(int port) {
        this.port = port;
        return this.getThis();
    }

    public final T setServiceOption(P serviceOption) {
        this.serviceOption = serviceOption;
        return this.getThis();
    }

    public final T setServiceApiOption(RedfishApiOptions serviceOption) {
        if (this.serviceOption.getClass().isInstance(serviceOption)) {
            this.serviceOption = serviceOption;
        }
        return this.getThis();
    }

    public final T setRestRawArgs(String[] restRawArgs) {
        this.restRawArgs = restRawArgs;
        return this.getThis();
    }

    public final T setUploadJsonFile(File uploadJsonFile) {
        this.uploadJsonFile = uploadJsonFile;
        return this.getThis();
    }

    public final T setDebug(boolean debug) {
        this.debug = debug;
        return this.getThis();
    }

    public final T setProtocolHeader(RESTProtocolHeaders protocolHeader) {
        this.protocolHeader = protocolHeader;
        return this.getThis();
    }

    public final T setLoggerWriter(AbstractLoggerWriter loggerWriter) {
        this.loggerWriter = loggerWriter;
        return this.getThis();
    }

    public final String getIpAddress() {
        return this.ipAddress;
    }

    public final String getUsername() {
        return this.username;
    }

    public final String getPassword() {
        return this.password;
    }

    public final int getPort() {
        return this.port;
    }

    public final P getServiceOption() {
        return this.serviceOption;
    }

    public final String[] getRestRawArgs() {
        return this.restRawArgs;
    }

    public final File getUploadJsonFile() {
        return this.uploadJsonFile;
    }

    public final boolean isDebug() {
        return this.debug;
    }

    public final RESTProtocolHeaders getProtocolHeader() {
        return this.protocolHeader;
    }
}

