/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.rest;

import Gbt.core.rest.RESTRequest;

public class RESTRequestImpl
extends RESTRequest {
    private final String serviceURI;
    private final String serviceId;

    protected RESTRequestImpl(Builder builder) {
        super(builder);
        this.serviceURI = builder.serviceURI;
        this.serviceId = builder.serviceId;
    }

    @Override
    public String getRestURI() {
        return this.protocolHeader.toString() + this.hostname + (this.port == 0 ? "" : ":" + this.port) + this.serviceURI + (this.serviceId == null ? "" : "/" + this.serviceId);
    }

    public static class Builder
    extends RESTRequest.Builder<Builder> {
        private String serviceURI;
        private String serviceId;

        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        public RESTRequestImpl build() {
            return new RESTRequestImpl(this);
        }

        public Builder setServiceURI(String serviceURI) {
            this.serviceURI = serviceURI;
            return this.getThis();
        }

        public Builder setServiceId(int serviceId) {
            this.serviceId = Integer.toString(serviceId, 10);
            return this.getThis();
        }

        public Builder setServiceId(String serviceId) {
            this.serviceId = serviceId;
            return this.getThis();
        }
    }
}

