/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.rest;

import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.JacksonCommonUtil;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.RESTClientReceiver;
import Gbt.core.rest.RESTException;
import Gbt.core.rest.RESTHttpMethods;
import Gbt.core.rest.RESTServicesOptions;
import Gbt.utility.rest.models.AMIRestSessionData;
import Gbt.utility.rest.requests.SessionRequest;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public abstract class RESTServices {
    protected int bmcPort;
    protected volatile AbstractLoggerWriter loggerWriter;
    protected volatile RESTClientReceiver clientReceiver = RESTClientReceiver.getInstance();
    protected Client client;
    protected String username;
    protected String password;
    protected AMIRestSessionData sessionData;
    protected int urlID;
    protected String logDirPath;
    protected List<AbstractJSONPOJO> jsonResults;
    protected List<JsonNode> jsonNodeList;
    private final DateTime startTime;

    public RESTServices(AbstractLoggerWriter loggerWriter) {
        this.loggerWriter = loggerWriter;
        this.logDirPath = "rest";
        this.jsonNodeList = new ArrayList<JsonNode>();
        this.jsonResults = new ArrayList<AbstractJSONPOJO>();
        this.startTime = new DateTime();
    }

    public RESTServices setBmcPort(int bmcPort) {
        this.bmcPort = bmcPort;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean openSession(String ipAddress, String username, String password, boolean debug) {
        String logName = ipAddress + "_" + this.logDirPath + "_" + this.getServiceName();
        this.username = username;
        this.password = password;
        this.client = this.clientReceiver.createHttpsClient(username, password, this.logDirPath, logName, debug);
        if (this.client == null) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "SSL context initialize fail.");
            return false;
        }
        SessionRequest request = ((SessionRequest.Builder)((SessionRequest.Builder)((SessionRequest.Builder)((SessionRequest.Builder)((SessionRequest.Builder)((SessionRequest.Builder)new SessionRequest.Builder().setHttpMethods(RESTHttpMethods.POST)).setHostname(ipAddress)).setPort(this.bmcPort)).setContentType("application/x-www-form-urlencoded")).setFormData("username", username)).setFormData("password", password)).build();
        try (Response response = null;){
            response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
            this.sessionData = this.clientReceiver.deserialize(response, new GenericType<AMIRestSessionData>(){});
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Open session success.");
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.TRACE, logName, this.sessionData.toString());
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeSession(String ipAddress) {
        if (this.getServiceName().equals("loaddefault")) {
            this.client.close();
            return true;
        }
        String logName = ipAddress + "_" + this.logDirPath + "_" + this.getServiceName();
        SessionRequest request = ((SessionRequest.Builder)((SessionRequest.Builder)((SessionRequest.Builder)((SessionRequest.Builder)((SessionRequest.Builder)new SessionRequest.Builder().setHttpMethods(RESTHttpMethods.DELETE)).setHostname(ipAddress)).setPort(this.bmcPort)).setContentType("application/x-www-form-urlencoded")).setCookies(this.sessionData)).build();
        Response response = null;
        try {
            response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
            this.sessionData = this.clientReceiver.deserialize(response, new GenericType<AMIRestSessionData>(){});
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Close session success.");
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.TRACE, logName, this.sessionData.toString());
            boolean bl = true;
            return bl;
        }
        catch (RESTException re) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Close session fail.");
            if (response != null) {
                this.restExceptionMessages(re, ipAddress, logName);
            }
            this.jsonResults.add(new NullJSONData().setError(true).setMessages("Close session fail."));
            boolean bl = false;
            return bl;
        }
        finally {
            if (response != null) {
                response.close();
            }
            if (this.client != null) {
                this.sessionData = null;
                this.client.close();
            }
        }
    }

    public final boolean isOverTime(int timeout) {
        DateTime now = new DateTime();
        DateTime timeLimit = this.startTime.plusMinutes(timeout);
        return now.compareTo((ReadableInstant)timeLimit) > 0;
    }

    public void setUrlID(int urlID) {
        this.urlID = urlID;
    }

    public void setLogDirPath(String logDirPath) {
        this.logDirPath = logDirPath;
    }

    public AbstractLoggerWriter getLoggerWriter() {
        return this.loggerWriter;
    }

    public abstract String getServiceName();

    public abstract boolean readJsonData(AbstractJSONPOJO var1, RESTServicesOptions var2);

    public abstract boolean readJsonFiles(List<File> var1, RESTServicesOptions var2);

    public abstract boolean uploadFiles(List<File> var1, RESTServicesOptions var2);

    public abstract boolean execute(String var1, RESTServicesOptions var2);

    public final List<AbstractJSONPOJO> getJsonResults() {
        return this.jsonResults;
    }

    public final List<JsonNode> getJsonNodeList() {
        return this.jsonNodeList;
    }

    protected String getJsonResultsPrettyPrintString() {
        return JacksonCommonUtil.getUtil().getPrettyPrintString(this.jsonNodeList);
    }

    protected String getJsonListsPrettyPrintString() {
        return JacksonCommonUtil.getUtil().getPrettyPrintString(this.jsonResults);
    }

    protected void restExceptionMessages(Exception excp, String ipAddress, String logName) {
        this.getRootCauseException(excp, ipAddress, logName);
        if (excp instanceof RESTException) {
            RESTException re = (RESTException)excp;
            if (re.getUnexpectedBody() != null) {
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] (" + re.getStatusCode() + ") Error Response Body : " + re.getUnexpectedBody());
            } else {
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Errot Message : " + re.getMessage());
            }
        }
    }

    protected <T extends AbstractJSONPOJO> void acceptJsonResults(JsonNode resultNode, Class<T> clazz, String ipAddress, String logName) {
        if (resultNode.isArray()) {
            Iterator it = resultNode.elements();
            while (it.hasNext()) {
                JsonNode nowNode = (JsonNode)it.next();
                this.jsonNodeList.add(nowNode);
                try {
                    this.jsonResults.add((AbstractJSONPOJO)JacksonCommonUtil.getUtil().jsonNodeToPojo(nowNode, clazz));
                }
                catch (JsonProcessingException e) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Errot Message : " + e.getMessage());
                }
            }
        } else {
            this.jsonNodeList.add(resultNode);
            try {
                this.jsonResults.add((AbstractJSONPOJO)JacksonCommonUtil.getUtil().jsonNodeToPojo(resultNode, clazz));
            }
            catch (JsonProcessingException e) {
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Errot Message : " + e.getMessage());
            }
        }
    }

    protected void acceptJsonResults(AbstractJSONPOJO jsonpojo) {
        this.jsonNodeList.add(jsonpojo.parseJsonNode());
        this.jsonResults.add(jsonpojo);
    }

    private void getRootCauseException(Throwable exp, String ipAddress, String logName) {
        if (exp.getCause() != null) {
            Throwable nextExp = ExceptionUtils.getCause((Throwable)exp);
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] " + nextExp.getMessage());
            this.getRootCauseException(nextExp, ipAddress, logName);
        }
    }
}

