/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.tftp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.SocketTimeoutException;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.net.io.FromNetASCIIOutputStream;
import org.apache.commons.net.io.ToNetASCIIInputStream;
import org.apache.commons.net.tftp.TFTP;
import org.apache.commons.net.tftp.TFTPAckPacket;
import org.apache.commons.net.tftp.TFTPDataPacket;
import org.apache.commons.net.tftp.TFTPErrorPacket;
import org.apache.commons.net.tftp.TFTPPacket;
import org.apache.commons.net.tftp.TFTPPacketException;
import org.apache.commons.net.tftp.TFTPReadRequestPacket;
import org.apache.commons.net.tftp.TFTPWriteRequestPacket;

public final class TFTPServer
implements Runnable {
    public static final int DEFAULT_TFTP_PORT = 69;
    private HashSet<TFTPTransfer> transfers_ = new HashSet();
    private volatile boolean shutdownServer = false;
    private TFTP serverTftp_;
    private File serverReadDirectory_;
    private File serverWriteDirectory_;
    private int port_;
    private Exception serverException = null;
    private ServerMode mode_;
    private static final PrintStream nullStream = new PrintStream(new OutputStream(){

        @Override
        public void write(int b) {
        }

        @Override
        public void write(byte[] b) {
        }
    });
    private PrintStream log_;
    private PrintStream logError_;
    private int maxTimeoutRetries_ = 3;
    private int socketTimeout_;
    private Thread serverThread;

    public TFTPServer(File serverReadDirectory, File serverWriteDirectory, ServerMode mode) throws IOException {
        this(serverReadDirectory, serverWriteDirectory, 69, mode, null, null);
    }

    public TFTPServer(File serverReadDirectory, File serverWriteDirectory, int port, ServerMode mode, PrintStream log, PrintStream errorLog) throws IOException {
        this.port_ = port;
        this.mode_ = mode;
        this.log_ = log == null ? nullStream : log;
        this.logError_ = errorLog == null ? nullStream : errorLog;
        this.launch(serverReadDirectory, serverWriteDirectory);
    }

    public void setMaxTimeoutRetries(int retries) {
        if (retries < 0) {
            throw new RuntimeException("Invalid Value");
        }
        this.maxTimeoutRetries_ = retries;
    }

    public int getMaxTimeoutRetries() {
        return this.maxTimeoutRetries_;
    }

    public void setSocketTimeout(int timeout) {
        if (timeout < 10) {
            throw new RuntimeException("Invalid Value");
        }
        this.socketTimeout_ = timeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout_;
    }

    private void launch(File serverReadDirectory, File serverWriteDirectory) throws IOException {
        this.log_.println("Starting TFTP Server on port " + this.port_ + ".\nRead directory     : " + serverReadDirectory.getAbsolutePath() + "\nWrite directory    : " + serverWriteDirectory.getAbsolutePath() + "\nServer Mode set as : " + (Object)((Object)this.mode_));
        this.serverReadDirectory_ = serverReadDirectory.getCanonicalFile();
        if (!this.serverReadDirectory_.exists() || !serverReadDirectory.isDirectory()) {
            throw new IOException("The server read directory " + this.serverReadDirectory_ + " does not exist");
        }
        this.serverWriteDirectory_ = serverWriteDirectory.getCanonicalFile();
        if (!this.serverWriteDirectory_.exists() || !serverWriteDirectory.isDirectory()) {
            throw new IOException("The server write directory " + this.serverWriteDirectory_ + " does not exist");
        }
        this.serverTftp_ = new TFTP();
        this.socketTimeout_ = this.serverTftp_.getDefaultTimeout();
        this.serverTftp_.setDefaultTimeout(0);
        this.serverTftp_.open(this.port_);
        this.serverThread = new Thread((Runnable)this, "Apache TFTP server");
        this.serverThread.setDaemon(true);
        this.serverThread.start();
    }

    protected void finalize() throws Throwable {
        this.shutdown();
        if (this.serverException != null) {
            throw this.serverException;
        }
    }

    public boolean isRunning() {
        if (this.shutdownServer && this.serverException != null) {
            return this.shutdownServer;
        }
        return !this.shutdownServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (!this.shutdownServer) {
                TFTPPacket tftpPacket = this.serverTftp_.receive();
                TFTPTransfer tt = new TFTPTransfer(tftpPacket);
                HashSet<TFTPTransfer> hashSet = this.transfers_;
                synchronized (hashSet) {
                    this.transfers_.add(tt);
                }
                Thread thread = new Thread(tt);
                thread.setDaemon(true);
                thread.start();
            }
        }
        catch (Exception e) {
            if (!this.shutdownServer) {
                this.serverException = e;
                this.logError_.println("Unexpected Error in TFTP Server - Server shut down! + " + e);
            }
        }
        finally {
            this.shutdownServer = true;
            if (this.serverTftp_ != null && this.serverTftp_.isOpen()) {
                this.serverTftp_.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.shutdownServer = true;
        HashSet<TFTPTransfer> hashSet = this.transfers_;
        synchronized (hashSet) {
            Iterator<TFTPTransfer> it = this.transfers_.iterator();
            while (it.hasNext()) {
                it.next().shutdown();
            }
        }
        try {
            this.serverTftp_.close();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            this.serverThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void setLog(PrintStream log) {
        this.log_ = log;
    }

    public void setLogError(PrintStream logError) {
        this.logError_ = logError;
    }

    private class TFTPTransfer
    implements Runnable {
        private TFTPPacket tftpPacket_;
        private boolean shutdownTransfer = false;
        TFTP transferTftp_ = null;

        public TFTPTransfer(TFTPPacket tftpPacket) {
            this.tftpPacket_ = tftpPacket;
        }

        public void shutdown() {
            this.shutdownTransfer = true;
            try {
                this.transferTftp_.close();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.transferTftp_ = new TFTP();
                this.transferTftp_.beginBufferedOps();
                this.transferTftp_.setDefaultTimeout(TFTPServer.this.socketTimeout_);
                this.transferTftp_.open();
                if (this.tftpPacket_ instanceof TFTPReadRequestPacket) {
                    this.handleRead((TFTPReadRequestPacket)this.tftpPacket_);
                } else if (this.tftpPacket_ instanceof TFTPWriteRequestPacket) {
                    this.handleWrite((TFTPWriteRequestPacket)this.tftpPacket_);
                } else {
                    TFTPServer.this.log_.println("Unsupported TFTP request (" + this.tftpPacket_ + ") - ignored.");
                }
            }
            catch (Exception e) {
                if (!this.shutdownTransfer) {
                    TFTPServer.this.logError_.println("Unexpected Error in during TFTP file transfer.  Transfer aborted. " + e);
                }
            }
            finally {
                try {
                    if (this.transferTftp_ != null && this.transferTftp_.isOpen()) {
                        this.transferTftp_.endBufferedOps();
                        this.transferTftp_.close();
                    }
                }
                catch (Exception exception) {}
                HashSet hashSet = TFTPServer.this.transfers_;
                synchronized (hashSet) {
                    TFTPServer.this.transfers_.remove(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private void handleRead(TFTPReadRequestPacket trrp) throws IOException, TFTPPacketException {
            block36: {
                InputStream is = null;
                try {
                    if (TFTPServer.this.mode_ == ServerMode.PUT_ONLY) {
                        this.transferTftp_.bufferedSend((TFTPPacket)new TFTPErrorPacket(trrp.getAddress(), trrp.getPort(), 4, "Read not allowed by server."));
                        return;
                    }
                    try {
                        is = new BufferedInputStream(new FileInputStream(this.buildSafeFile(TFTPServer.this.serverReadDirectory_, trrp.getFilename(), false)));
                    }
                    catch (FileNotFoundException e) {
                        this.transferTftp_.bufferedSend((TFTPPacket)new TFTPErrorPacket(trrp.getAddress(), trrp.getPort(), 1, e.getMessage()));
                        try {
                            if (is != null) {
                                is.close();
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        return;
                    }
                    catch (Exception e) {
                        this.transferTftp_.bufferedSend((TFTPPacket)new TFTPErrorPacket(trrp.getAddress(), trrp.getPort(), 0, e.getMessage()));
                        try {
                            if (is != null) {
                                is.close();
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        return;
                    }
                    if (trrp.getMode() == 0) {
                        is = new ToNetASCIIInputStream(is);
                    }
                    byte[] temp = new byte[512];
                    int block = 1;
                    boolean sendNext = true;
                    int readLength = 512;
                    TFTPDataPacket lastSentData = null;
                    while (readLength == 512 && !this.shutdownTransfer) {
                        if (sendNext) {
                            readLength = is.read(temp);
                            if (readLength == -1) {
                                readLength = 0;
                            }
                            lastSentData = new TFTPDataPacket(trrp.getAddress(), trrp.getPort(), block, temp, 0, readLength);
                            this.transferTftp_.bufferedSend((TFTPPacket)lastSentData);
                        }
                        TFTPPacket answer = null;
                        int timeoutCount = 0;
                        while (!(this.shutdownTransfer || answer != null && answer.getAddress().equals(trrp.getAddress()) && answer.getPort() == trrp.getPort())) {
                            if (answer != null) {
                                TFTPServer.this.log_.println("TFTP Server ignoring message from unexpected source.");
                                this.transferTftp_.bufferedSend((TFTPPacket)new TFTPErrorPacket(answer.getAddress(), answer.getPort(), 5, "Unexpected Host or Port"));
                            }
                            try {
                                answer = this.transferTftp_.bufferedReceive();
                            }
                            catch (SocketTimeoutException e) {
                                if (timeoutCount >= TFTPServer.this.maxTimeoutRetries_) {
                                    throw e;
                                }
                                ++timeoutCount;
                                this.transferTftp_.bufferedSend((TFTPPacket)lastSentData);
                            }
                        }
                        if (!(answer instanceof TFTPAckPacket)) {
                            if (!this.shutdownTransfer) {
                                TFTPServer.this.logError_.println("Unexpected response from tftp client during transfer (" + answer + ").  Transfer aborted.");
                            }
                            break block36;
                        }
                        TFTPAckPacket ack = (TFTPAckPacket)answer;
                        if (ack.getBlockNumber() != block) {
                            sendNext = false;
                            continue;
                        }
                        if (++block > 65535) {
                            block = 0;
                        }
                        sendNext = true;
                    }
                    {
                        break block36;
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleWrite(TFTPWriteRequestPacket twrp) throws IOException, TFTPPacketException {
            block28: {
                try (OutputStream bos = null;){
                    TFTPPacket dataPacket;
                    File temp;
                    int lastBlock;
                    block27: {
                        if (TFTPServer.this.mode_ == ServerMode.GET_ONLY) {
                            this.transferTftp_.bufferedSend((TFTPPacket)new TFTPErrorPacket(twrp.getAddress(), twrp.getPort(), 4, "Write not allowed by server."));
                            return;
                        }
                        lastBlock = 0;
                        String fileName = twrp.getFilename();
                        try {
                            temp = this.buildSafeFile(TFTPServer.this.serverWriteDirectory_, fileName, true);
                            if (!temp.exists()) break block27;
                            this.transferTftp_.bufferedSend((TFTPPacket)new TFTPErrorPacket(twrp.getAddress(), twrp.getPort(), 6, "File already exists"));
                            return;
                        }
                        catch (Exception e) {
                            this.transferTftp_.bufferedSend((TFTPPacket)new TFTPErrorPacket(twrp.getAddress(), twrp.getPort(), 0, e.getMessage()));
                            if (bos != null) {
                                bos.close();
                            }
                            return;
                        }
                    }
                    bos = new BufferedOutputStream(new FileOutputStream(temp));
                    if (twrp.getMode() == 0) {
                        bos = new FromNetASCIIOutputStream(bos);
                    }
                    TFTPAckPacket lastSentAck = new TFTPAckPacket(twrp.getAddress(), twrp.getPort(), 0);
                    this.transferTftp_.bufferedSend((TFTPPacket)lastSentAck);
                    while (true) {
                        dataPacket = null;
                        int timeoutCount = 0;
                        while (!(this.shutdownTransfer || dataPacket != null && dataPacket.getAddress().equals(twrp.getAddress()) && dataPacket.getPort() == twrp.getPort())) {
                            if (dataPacket != null) {
                                TFTPServer.this.log_.println("TFTP Server ignoring message from unexpected source.");
                                this.transferTftp_.bufferedSend((TFTPPacket)new TFTPErrorPacket(dataPacket.getAddress(), dataPacket.getPort(), 5, "Unexpected Host or Port"));
                            }
                            try {
                                dataPacket = this.transferTftp_.bufferedReceive();
                            }
                            catch (SocketTimeoutException e) {
                                if (timeoutCount >= TFTPServer.this.maxTimeoutRetries_) {
                                    throw e;
                                }
                                this.transferTftp_.bufferedSend((TFTPPacket)lastSentAck);
                                ++timeoutCount;
                            }
                        }
                        if (dataPacket instanceof TFTPWriteRequestPacket) {
                            lastSentAck = new TFTPAckPacket(twrp.getAddress(), twrp.getPort(), 0);
                            this.transferTftp_.bufferedSend((TFTPPacket)lastSentAck);
                            continue;
                        }
                        if (!(dataPacket instanceof TFTPDataPacket)) {
                            if (!this.shutdownTransfer) {
                                TFTPServer.this.logError_.println("Unexpected response from tftp client during transfer (" + dataPacket + ").  Transfer aborted.");
                            }
                            break block28;
                        }
                        int block = ((TFTPDataPacket)dataPacket).getBlockNumber();
                        byte[] data = ((TFTPDataPacket)dataPacket).getData();
                        int dataLength = ((TFTPDataPacket)dataPacket).getDataLength();
                        int dataOffset = ((TFTPDataPacket)dataPacket).getDataOffset();
                        if (block > lastBlock || lastBlock == 65535 && block == 0) {
                            bos.write(data, dataOffset, dataLength);
                            lastBlock = block;
                        }
                        lastSentAck = new TFTPAckPacket(twrp.getAddress(), twrp.getPort(), block);
                        this.transferTftp_.bufferedSend((TFTPPacket)lastSentAck);
                        if (dataLength < 512) break;
                    }
                    bos.close();
                    for (int i = 0; i < TFTPServer.this.maxTimeoutRetries_; ++i) {
                        try {
                            dataPacket = this.transferTftp_.bufferedReceive();
                        }
                        catch (SocketTimeoutException e) {
                            break;
                        }
                        if (!(dataPacket == null || dataPacket.getAddress().equals(twrp.getAddress()) && dataPacket.getPort() == twrp.getPort())) {
                            this.transferTftp_.bufferedSend((TFTPPacket)new TFTPErrorPacket(dataPacket.getAddress(), dataPacket.getPort(), 5, "Unexpected Host or Port"));
                            continue;
                        }
                        this.transferTftp_.bufferedSend((TFTPPacket)lastSentAck);
                    }
                }
            }
        }

        private File buildSafeFile(File serverDirectory, String fileName, boolean createSubDirs) throws IOException {
            File temp = new File(serverDirectory, fileName);
            if (!this.isSubdirectoryOf(serverDirectory, temp = temp.getCanonicalFile())) {
                throw new IOException("Cannot access files outside of tftp server root.");
            }
            if (createSubDirs) {
                this.createDirectory(temp.getParentFile());
            }
            return temp;
        }

        private void createDirectory(File file) throws IOException {
            File parent = file.getParentFile();
            if (parent == null) {
                throw new IOException("Unexpected error creating requested directory");
            }
            if (!parent.exists()) {
                this.createDirectory(parent);
            }
            if (parent.isDirectory()) {
                if (file.isDirectory()) {
                    return;
                }
                boolean result = file.mkdir();
                if (!result) {
                    throw new IOException("Couldn't create requested directory");
                }
            } else {
                throw new IOException("Invalid directory path - file in the way of requested folder");
            }
        }

        private boolean isSubdirectoryOf(File parent, File child) {
            File childsParent = child.getParentFile();
            if (childsParent == null) {
                return false;
            }
            if (childsParent.equals(parent)) {
                return true;
            }
            return this.isSubdirectoryOf(parent, childsParent);
        }
    }

    public static enum ServerMode {
        GET_ONLY,
        PUT_ONLY,
        GET_AND_PUT;

    }
}

