/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.vmedia.protocol;

import Gbt.core.vmedia.protocol.IUSBHeader;
import Gbt.core.vmedia.protocol.PacketMaster;
import Gbt.core.vmedia.protocol.RedirectionPacket;
import Gbt.core.vmedia.protocol.VmRedirectionException;
import Gbt.core.vmedia.protocol.VmRedirectionProtocolException;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class IUSBSCSI
extends RedirectionPacket {
    public byte Lba;
    public int instanceNum;
    public int connectionStatus = -1;
    public int dataLen;
    public int opcode;
    public ByteBuffer data;
    public String m_otherIP;
    private boolean preBuffered;
    public static final int IUSB_SCSI_PKT_SIZE = 62;
    public static final int IUSB_SCSI_PKT_SIZE_WITHOUT_HEADER = 30;
    public static final int IUSB_SCSI_OPCODE_INDEX = 41;
    public static final int OPCODE_EJECT = 27;
    public static final int OPCODE_KILL_REDIR = 246;
    public static final int MEDIA_SESSION_DISCONNECT = 247;
    public static final int IUSB_SCSI_OPCODE_KEEP_ALIVE = 243;
    public static final int DEVICE_INFO = 248;
    public static final int IUSB_SCSI_OPCODE_GET_NOTIF_STAT = 74;
    public static final int IUSB_SCSI_OPCODE_GET_NOTIF_STAT_PKT_SIZE = 37;

    public IUSBSCSI(IUSBHeader header) {
        this.header = header;
        this.instanceNum = header.getInstance();
        this.dataLen = (int)header.getDataPktLen();
    }

    public IUSBSCSI(ByteBuffer packetBuffer, boolean preBuffered) throws VmRedirectionProtocolException {
        this.preBuffered = preBuffered;
        this.header = new IUSBHeader();
        this.header.read(packetBuffer);
        ((IUSBHeader)this.header).setDataPktLen(packetBuffer.limit() - this.header.headerLen);
        this.dataLen = (int)((IUSBHeader)this.header).getDataPktLen();
        this.data = packetBuffer.slice();
    }

    @Override
    public void writePacket(ByteBuffer buffer) {
        ((IUSBHeader)this.header).setDirection(128);
        this.header.write(buffer);
        if (this.preBuffered) {
            buffer.limit(this.dataLen + 32);
            buffer.position(buffer.limit());
        } else {
            buffer.put(this.data);
        }
    }

    @Override
    public void readData(ByteBuffer buffer) throws BufferUnderflowException {
        byte[] otherIP = new byte[39];
        this.data = ByteBuffer.allocate(this.dataLen);
        if (buffer.remaining() < this.dataLen) {
            throw new BufferUnderflowException();
        }
        this.data.put(buffer);
        this.Lba = this.data.get(13);
        this.opcode = this.data.get(9) & 0xFF;
        if (this.opcode == 241 && this.dataLen > 30) {
            this.connectionStatus = this.data.get(30);
            try {
                this.data.position(31);
                this.data.get(otherIP);
                this.m_otherIP = new String(otherIP).trim();
            }
            catch (BufferUnderflowException e) {
                System.err.println(e.getMessage());
                this.m_otherIP = "";
                throw new BufferUnderflowException();
            }
        } else {
            this.connectionStatus = -1;
        }
    }

    public static void sendCommandToMediaServer(PacketMaster packetMaster, ByteBuffer packetWriteBuffer, byte[] buffer, int opcode) throws VmRedirectionException, IOException {
        int totalLength = 30;
        packetWriteBuffer.clear();
        if (buffer != null && buffer.length >= 0) {
            if (buffer.length > packetWriteBuffer.capacity() - 32) {
                System.out.println("Passed buffer length is greater than allocated bytebuffer capacity");
                return;
            }
            totalLength += buffer.length;
            packetWriteBuffer.limit(62 + buffer.length);
        } else {
            packetWriteBuffer.limit(62);
        }
        if (packetMaster == null || packetWriteBuffer == null) {
            System.out.println("Error sending packet. PacketMaster/packetWriteBuffer is null!!!");
            return;
        }
        IUSBHeader iusbHeader = new IUSBHeader(totalLength);
        iusbHeader.write(packetWriteBuffer);
        packetWriteBuffer.position(41);
        packetWriteBuffer.put((byte)(opcode & 0xFF));
        if (buffer != null) {
            packetWriteBuffer.position(62);
            packetWriteBuffer.put(buffer);
        }
        packetWriteBuffer.position(0);
        IUSBSCSI response = new IUSBSCSI(packetWriteBuffer, true);
        packetMaster.sendPacket(response);
    }

    public static void SendMediaInfo(PacketMaster packetMaster, ByteBuffer packetWriteBuffer, String filepath) throws VmRedirectionException, IOException {
        if (filepath == null) {
            throw new VmRedirectionException("File path is null.");
        }
        if (filepath.length() == 0 || filepath.length() > 256) {
            throw new VmRedirectionException("File path is too long.");
        }
        if (System.getProperty("os.name").startsWith("Windows")) {
            if (filepath.lastIndexOf(92) != -1) {
                filepath = filepath.substring(filepath.lastIndexOf(92) + 1);
            }
        } else if (System.getProperty("os.name").startsWith("Linux") && filepath.lastIndexOf(47) != -1) {
            filepath = filepath.substring(filepath.lastIndexOf(47) + 1);
        }
        filepath = filepath.concat("\u0000");
        ByteBuffer buffer = ByteBuffer.allocateDirect(260);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(4);
        buffer.put(filepath.getBytes());
        buffer.position(0);
        byte[] arr = new byte[buffer.remaining()];
        buffer.get(arr);
        IUSBSCSI.sendCommandToMediaServer(packetMaster, packetWriteBuffer, arr, 248);
    }
}

