/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.vmedia.protocol;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;

public class Image {
    public static final byte SUCCESS = 0;
    public static final byte SECTOR_RANGE_ERROR = -1;
    public static final byte WRONG_MEDIA = -2;
    public static final byte MEDIUM_CHANGE = -3;
    public static final byte MEDIA_ERROR = -4;
    public static final byte NO_MEDIA = -5;
    public static final byte INVALID_PARAMS = -6;
    public static final byte UNREADABLE_MEDIA = -7;
    public static final byte REMOVAL_PREVENTED = -8;
    public static final byte UNSUPPORTED_COMMAND = -9;
    public static final byte DEVICE_PATH_TOO_LONG = -10;
    public static final byte DEVICE_ERROR = -11;
    public static final byte DEVICE_ALREADY_OPEN = -12;
    public static final byte MEDIUM_GETTING_READY = -14;
    public static final byte MEDIA_IN_USE = -15;
    public static final int MAX_DEVICE_PATH_SIZE = 256;
    protected String imageFilePath;
    protected RandomAccessFile imageFile;
    protected long totalSectors;
    protected long blockSize;
    protected ByteOrder byteOrder;
    protected boolean opened = false;
    protected boolean mediaChange = false;
    FileReader fileReader;

    public boolean openImage(File file, String mode) {
        boolean ret = true;
        try {
            this.imageFile = new RandomAccessFile(file, mode);
            this.imageFilePath = file.getPath();
        }
        catch (FileNotFoundException e) {
            ret = false;
        }
        return ret;
    }

    public void closeImage() {
        try {
            this.imageFile.close();
            this.imageFile = null;
        }
        catch (IOException e) {
            this.imageFile = null;
        }
    }

    public String getImageFilePath() {
        return this.imageFilePath;
    }

    public boolean setImageFilePath(String imageFilePath) {
        boolean ret;
        if (imageFilePath.length() < 256) {
            this.imageFilePath = imageFilePath;
            ret = true;
        } else {
            ret = false;
        }
        return ret;
    }

    public RandomAccessFile getImageFile() {
        return this.imageFile;
    }

    public void setImageFile(RandomAccessFile imageFile) {
        this.imageFile = imageFile;
    }

    public long getTotalSectors() {
        return this.totalSectors;
    }

    public void setTotalSectors(long totalSectors) {
        this.totalSectors = totalSectors;
    }

    public long getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(long blockSize) {
        this.blockSize = blockSize;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public boolean isOpened() {
        return this.opened;
    }

    public void setOpened(boolean opened) {
        this.opened = opened;
    }

    public boolean isMediaChange() {
        return this.mediaChange;
    }

    public void setMediaChange(boolean mediaChange) {
        this.mediaChange = mediaChange;
    }
}

