/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.vmedia.protocol;

import Gbt.core.vmedia.data.KvmSessionToken;
import Gbt.core.vmedia.protocol.RedirectionPacket;
import Gbt.core.vmedia.protocol.RedirectionProtocol;
import Gbt.core.vmedia.protocol.VmRedirectionException;
import Gbt.utility.Common.SocketUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.ws.rs.client.Client;

public final class PacketMaster {
    private static final int IUSB_HDR_SIZE = 32;
    private static final int TIMEOUT_VALUE = 180000;
    private Socket packetSock;
    private RedirectionProtocol protocol;
    private ByteBuffer netIn;
    private ByteBuffer netOut;
    private ByteBuffer appIn;
    private ByteBuffer appOut;
    private String host;
    private int port;

    public PacketMaster(String host, int port, RedirectionProtocol protocol) {
        this.host = host;
        this.port = port;
        this.protocol = protocol;
    }

    public void setupBuffers(int inBufferSize, int outBufferSize) {
        this.netIn = ByteBuffer.allocateDirect(inBufferSize);
        this.netOut = ByteBuffer.allocateDirect(outBufferSize);
        this.appIn = this.netIn;
        this.appOut = this.netOut;
        System.out.println("No SSL, allocating only netIn and netOut...");
        System.out.println("Allocated netOut buffer of " + this.netOut.capacity() + " bytes");
        System.out.println("Allocated netIn buffer of " + this.netIn.capacity() + " bytes");
    }

    public void setupBuffers(ByteBuffer inBuffer, ByteBuffer outBuffer) {
        this.netIn = inBuffer;
        this.netOut = outBuffer;
        this.appIn = this.netIn;
        this.appOut = this.netOut;
        this.netIn.clear();
        this.netOut.clear();
    }

    public void setBufferEndianness(ByteOrder inByteOrder, ByteOrder outByteOrder) {
        this.appIn.order(inByteOrder);
        this.appOut.order(outByteOrder);
    }

    public int connectVmedia(Client client, KvmSessionToken kvmSessionToken) {
        try {
            this.packetSock = SocketUtil.createHttpSocket(client, this.host, this.port);
            return this.doTunnelHandshake(this.host, this.port, kvmSessionToken);
        }
        catch (IOException e) {
            return -1;
        }
    }

    public Socket getSock() {
        return this.packetSock;
    }

    public void vmediaSockclose() throws IOException {
        if (this.packetSock != null) {
            this.packetSock.close();
        }
    }

    public void sendPacket(RedirectionPacket packet) throws IOException {
        this.appOut.clear();
        this.netOut.clear();
        packet.writePacket(this.appOut);
        this.appOut.flip();
        byte[] write_buf = new byte[this.netOut.remaining()];
        this.netOut.get(write_buf);
        this.getSock().getOutputStream().write(write_buf);
    }

    public RedirectionPacket receivePacket(boolean clearBuffer) throws IOException, VmRedirectionException {
        int rc = 0;
        RedirectionPacket packet = null;
        if (this.appIn.position() != 0) {
            this.appIn.flip();
            packet = this.protocol.getPacket(this.appIn);
            if (packet == null) {
                this.appIn.position(this.appIn.limit());
                this.appIn.limit(this.appIn.capacity());
            }
        }
        while (packet == null) {
            byte[] readheader_buf = new byte[32];
            rc = this.read_data(readheader_buf);
            if (rc < 0) {
                throw new IOException("8_2_PACKETMAST");
            }
            this.netIn.put(readheader_buf);
            this.netIn.position(12);
            long dataPacketLen = (long)this.netIn.getInt() & 0xFFFFFFFFFFFFFFFFL;
            byte[] readdata_buf = new byte[(int)dataPacketLen];
            rc = 0;
            rc = this.read_data(readdata_buf);
            if (rc < 0) {
                throw new IOException("8_2_PACKETMAST");
            }
            this.netIn.position(32);
            this.netIn.put(readdata_buf, 0, readdata_buf.length);
            this.netIn.position(0);
            this.netIn.limit(readheader_buf.length + readdata_buf.length);
            packet = this.protocol.getPacket(this.netIn);
            if (packet != null) continue;
            System.out.println("Can't build a packet from input data");
            this.appIn.position(this.appIn.limit());
            this.appIn.limit(this.appIn.capacity());
        }
        if (clearBuffer) {
            this.appIn.compact();
        }
        return packet;
    }

    public RedirectionPacket receivePacket() throws IOException, VmRedirectionException {
        return this.receivePacket(true);
    }

    public void clearBuffer() {
        this.appIn.compact();
    }

    public void setSocketTimeout() {
        try {
            this.getSock().setSoTimeout(180000);
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
    }

    private int read_data(byte[] read_buf) {
        int dwIndex = 0;
        int bytes_to_read = read_buf.length;
        int m_readIx = 0;
        while (bytes_to_read != 0) {
            try {
                m_readIx = this.getSock().getInputStream().read(read_buf, dwIndex, bytes_to_read);
            }
            catch (IOException ioe) {
                System.out.println("SOCKET FAILURE " + ioe.getCause().getMessage());
                return m_readIx;
            }
            if (m_readIx <= 0) {
                System.out.println("SOCKET FAILURE");
                return m_readIx;
            }
            bytes_to_read -= m_readIx;
            dwIndex += m_readIx;
        }
        m_readIx = read_buf.length;
        return m_readIx;
    }

    private int doTunnelHandshake(String host, int port, KvmSessionToken kvmSessionToken) throws IOException {
        String HttpReq = this.formHttpRequest(host, port, kvmSessionToken);
        if (this.writeToConnectedSock(HttpReq) != 0) {
            return -1;
        }
        HttpReq = null;
        HttpReq = this.formJviewerRequest(kvmSessionToken);
        if (this.writeToConnectedSock(HttpReq) != 0) {
            return -1;
        }
        HttpReq = null;
        int data = this.readFromConnectedSock();
        if (data < 0) {
            System.out.println("Tunneling Handshake was fail!");
            return -1;
        }
        System.out.println("Tunneling Handshake was successful!");
        return 0;
    }

    private String formHttpRequest(String host, int port, KvmSessionToken kvmSessionToken) {
        return "CONNECT " + host + ":" + port + " HTTPS/1.1\r\n cookie QSESSIONID=" + kvmSessionToken.getKvmSessionCookie() + "\r\n\r\n";
    }

    private String formJviewerRequest(KvmSessionToken kvmSessionToken) {
        return "JVIEWER CDMEDIA cookie QSESSIONID=" + kvmSessionToken.getKvmSessionCookie() + "\r\n\r\n";
    }

    private String getErrorCode(String ErrMsg) {
        String Err = null;
        int loc = -1;
        if (null == ErrMsg) {
            return Err;
        }
        StringBuilder ErrStr = new StringBuilder(ErrMsg);
        for (loc = 0; loc < ErrStr.length() && ErrStr.charAt(loc) != '\\'; ++loc) {
        }
        if (loc > 0) {
            Err = "AE_" + ErrMsg.substring(ErrMsg.indexOf(":") + 1, loc) + "_SPKVM";
        }
        return Err;
    }

    private int readFromConnectedSock() throws IOException {
        int replyLen = 0;
        int newlinesSeen = 0;
        boolean headerDone = false;
        String ErrMsg = null;
        byte[] reply = new byte[200];
        while (newlinesSeen < 1) {
            int i = this.getSock().getInputStream().read();
            if (i < 0) {
                return i;
            }
            if (0 == this.getSock().getInputStream().available()) {
                headerDone = true;
                ++newlinesSeen;
                continue;
            }
            if (i == 13) continue;
            newlinesSeen = 0;
            if (headerDone || replyLen >= reply.length) continue;
            reply[replyLen++] = (byte)i;
        }
        String replyStr = null;
        try {
            replyStr = new String(reply, 0, replyLen, "ASCII7");
        }
        catch (UnsupportedEncodingException uee) {
            System.out.println(uee.getMessage());
            replyStr = new String(reply, 0, replyLen);
        }
        if (replyStr.contains("ERROR")) {
            ErrMsg = this.getErrorCode(replyStr.trim());
            System.out.println(ErrMsg);
            return -1;
        }
        return replyLen;
    }

    private int writeToConnectedSock(String writedata) {
        byte[] b = null;
        try {
            b = writedata.getBytes("ASCII7");
        }
        catch (UnsupportedEncodingException ignored) {
            b = writedata.getBytes();
        }
        try {
            this.getSock().getOutputStream().write(b);
            this.getSock().getOutputStream().flush();
        }
        catch (IOException e) {
            return -1;
        }
        return 0;
    }
}

