/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.ConfigSave;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.core.receivers.GbtLocalCommandReceiver;
import Gbt.core.receivers.GbtSSHCommandReceiver;
import Gbt.utility.Configdeploy.ConfigItems;
import Gbt.utility.Configdeploy.ConfigRow;
import Gbt.utility.Configdeploy.ConfigTable;
import java.io.File;
import java.util.ArrayList;

public class ConfigSaveCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "configsave";
    private GbtIPMICommandReceiver ipmiReceiver;
    private GbtLocalCommandReceiver localReceiver;
    private GbtSSHCommandReceiver sshReceiver;

    protected ConfigSaveCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = ((Builder)this.commandArgs).bmcIP + "_" + COMMAND_NAME;
        this.ipmiReceiver = GbtIPMICommandReceiver.getInstance();
        this.localReceiver = GbtLocalCommandReceiver.getInstance();
        this.sshReceiver = GbtSSHCommandReceiver.getInstance();
    }

    @Override
    public void close() throws Exception {
        ((Builder)this.commandArgs).close();
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        if (this.ipmiReceiver == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI command receiver is null.");
            return false;
        }
        if (this.localReceiver == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Local command receiver is null.");
            return false;
        }
        if (this.sshReceiver == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] SSH command receiver is null.");
            return false;
        }
        if (!((Builder)this.commandArgs).checkArgs()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Command arguments check fail.");
            return false;
        }
        if (this.commandArgs == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Remote BMC IP is null.");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        boolean result = true;
        String absConfigPkgPath = new File("./" + ((Builder)this.commandArgs).configPkgName).getAbsolutePath();
        ((Builder)this.commandArgs).configTable = new ConfigTable();
        this.modifyConfigTable(((Builder)this.commandArgs).configTable);
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.TRACE, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Table:\n" + ((Builder)this.commandArgs).configTable.print());
        ConfigItems configItems = new ConfigItems(this.getStartTime(), this.loggerWriter, ((Builder)this.commandArgs).debugFile, COMMAND_NAME, this.commandID);
        for (ConfigRow row : ((Builder)this.commandArgs).configTable.getConfigTable()) {
            ConfigRow.ConfigItemName name = row.getItemName();
            if (!row.getAction().equals((Object)ConfigRow.Action.DO)) continue;
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start item:[" + (Object)((Object)name) + "]");
            if (name.equals((Object)ConfigRow.ConfigItemName.CHECKBMCPLATFORM)) {
                result = configItems.checkIsAMI(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword);
            } else if (name.equals((Object)ConfigRow.ConfigItemName.BOOTINTOMINIOS) || name.equals((Object)ConfigRow.ConfigItemName.REBOOTINTOMINIOS)) {
                result = configItems.bootIntoMiniOS(((Builder)this.commandArgs).isUEFI, ((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, absConfigPkgPath, ((Builder)this.commandArgs).miniOSISOName, ((Builder)this.commandArgs).serverIP);
            } else if (name.equals((Object)ConfigRow.ConfigItemName.SAVEBIOS)) {
                result = configItems.configSave("BIOS", "01-biosCfgCap.bac", ((Builder)this.commandArgs).timeout);
            } else if (name.equals((Object)ConfigRow.ConfigItemName.SAVEPARTITION)) {
                result = configItems.configSave("partition", "02-partitionTable.bac", ((Builder)this.commandArgs).timeout);
            } else if (name.equals((Object)ConfigRow.ConfigItemName.SAVERAID)) {
                result = configItems.configSave("RAID", "99-raidCfgCap.bac", ((Builder)this.commandArgs).timeout);
            } else if (name.equals((Object)ConfigRow.ConfigItemName.DOWNLOADCONFIGPKG)) {
                result = configItems.configPkgDownload();
            }
            if (result) continue;
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Fail item:" + (Object)((Object)name));
            this.commandResults.add(new NullJSONData().setError(true).setMessages("Fail item:" + (Object)((Object)name)));
            break;
        }
        configItems.close();
        if (result) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Config save success.");
            this.commandResults.add(new NullJSONData().setError(false).setMessages("Config save success."));
        }
        return result;
    }

    private void modifyConfigTable(ConfigTable table) {
        this.modifyConfigTableByInitial(table);
    }

    private void modifyConfigTableByInitial(ConfigTable table) {
        for (ConfigRow.ConfigItemName config : ConfigRow.ConfigItemName.values()) {
            table.addConfigTow(new ConfigRow().setItemName(config).setAction(ConfigRow.Action.SKIP));
        }
        table.getConfigRow(ConfigRow.ConfigItemName.CHECKBMCPLATFORM).setAction(ConfigRow.Action.DO);
        table.getConfigRow(ConfigRow.ConfigItemName.BOOTINTOMINIOS).setAction(ConfigRow.Action.DO);
        table.getConfigRow(ConfigRow.ConfigItemName.DOWNLOADCONFIGPKG).setAction(ConfigRow.Action.DO);
        if (((Builder)this.commandArgs).saveType.size() == 0 || ((Builder)this.commandArgs).saveType.contains((Object)Builder.SAVETYPE.BIOS)) {
            table.getConfigRow(ConfigRow.ConfigItemName.SAVEBIOS).setAction(ConfigRow.Action.DO);
        }
        if (((Builder)this.commandArgs).saveType.size() == 0 || ((Builder)this.commandArgs).saveType.contains((Object)Builder.SAVETYPE.PARTITION)) {
            table.getConfigRow(ConfigRow.ConfigItemName.SAVEPARTITION).setAction(ConfigRow.Action.DO);
        }
        if (((Builder)this.commandArgs).saveType.size() == 0 || ((Builder)this.commandArgs).saveType.contains((Object)Builder.SAVETYPE.RAID)) {
            table.getConfigRow(ConfigRow.ConfigItemName.SAVERAID).setAction(ConfigRow.Action.DO);
        }
    }

    @Override
    public void cancelHook(Object obj) {
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private String bmcIP;
        private String bmcUsername = "admin";
        private String bmcPassword = "password";
        private String serverIP;
        private String miniOSISOName;
        private int timeout = 60;
        private String configPkgName;
        private ArrayList<SAVETYPE> saveType = new ArrayList();
        private boolean isUEFI;
        private File debugFile = null;
        private ConfigTable configTable;

        @Override
        public boolean checkArgs() {
            if (this.args != null) {
                for (int i = 0; i < this.args.length; ++i) {
                    if (this.args[i].contains("uefi=")) {
                        this.isUEFI = Boolean.valueOf(this.args[i].substring(this.args[i].lastIndexOf("uefi=") + 5));
                        continue;
                    }
                    if (this.args[i].contains("timeout=")) {
                        this.timeout = Integer.parseInt(this.args[i].substring(this.args[i].lastIndexOf("timeout=") + 8));
                        continue;
                    }
                    if (this.args[i].contains("debug=")) {
                        this.debugFile = new File(this.args[i].substring(this.args[i].lastIndexOf("debug=") + 6));
                        if (this.debugFile.exists()) continue;
                        System.out.println("Debug file is not exist!");
                        return false;
                    }
                    if (this.args[i].contains("type=")) {
                        try {
                            String types = this.args[i].substring(this.args[i].lastIndexOf("type=") + 5);
                            String[] stringArray = types.split(",");
                            int n = stringArray.length;
                            block13: for (int j = 0; j < n; ++j) {
                                String type;
                                switch (type = stringArray[j]) {
                                    case "bios": {
                                        this.saveType.add(SAVETYPE.BIOS);
                                        continue block13;
                                    }
                                    case "partition": {
                                        this.saveType.add(SAVETYPE.PARTITION);
                                        continue block13;
                                    }
                                    case "raid": {
                                        this.saveType.add(SAVETYPE.RAID);
                                        continue block13;
                                    }
                                    default: {
                                        return false;
                                    }
                                }
                            }
                            continue;
                        }
                        catch (Exception e) {
                            System.out.println("type parameter format is not correct!");
                            return false;
                        }
                    }
                    if (i == 0) {
                        this.miniOSISOName = this.args[i];
                        continue;
                    }
                    if (i == 1) {
                        this.serverIP = this.args[i];
                        continue;
                    }
                    if (i != 2) continue;
                    this.configPkgName = this.args[2];
                }
                return this.miniOSISOName != null && this.serverIP != null && this.configPkgName != null;
            }
            return true;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public ConfigSaveCommand build() {
            return new ConfigSaveCommand(this);
        }

        public Builder setBMCIP(String bmcIP) {
            this.bmcIP = bmcIP;
            return this.getThis();
        }

        public Builder setBMCUsername(String username) {
            this.bmcUsername = username;
            return this.getThis();
        }

        public Builder setBMCPassword(String password) {
            this.bmcPassword = password;
            return this.getThis();
        }

        public Builder setMiniOSImage(String osISOName) {
            this.miniOSISOName = osISOName;
            return this.getThis();
        }

        public Builder setConfigPkg(String configPkgName) {
            this.configPkgName = configPkgName;
            return this.getThis();
        }

        public Builder setServerIP(String serverIP) {
            this.serverIP = serverIP;
            return this.getThis();
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.bmcIP = null;
            this.bmcUsername = null;
            this.bmcPassword = null;
            this.configPkgName = null;
            this.miniOSISOName = null;
            this.debugFile = null;
            this.configPkgName = null;
            this.configTable = null;
            this.loggerWriter.close();
        }

        public static enum SAVETYPE {
            BIOS,
            RAID,
            PARTITION;

        }
    }
}

