/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.SDR;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.utility.SDR.record.FullSensorRecord;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import com.veraxsystems.vxipmi.coding.commands.sdr.SetSensorThresholdResponseData;
import com.veraxsystems.vxipmi.coding.payload.CompletionCode;

public class SetSensorThresholdsCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "setSensorThreshold";
    private final GbtIPMICommandReceiver ipmiReceiver;

    protected SetSensorThresholdsCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = ((Builder)this.commandArgs).bmcIP + "_" + COMMAND_NAME;
        this.ipmiReceiver = GbtIPMICommandReceiver.getInstance();
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        if (!((Builder)this.commandArgs).checkArgs()) {
            return false;
        }
        return this.ipmiReceiver != null;
    }

    @Override
    public boolean execute() {
        ConnectionHandle handle = this.ipmiReceiver.createIPMIConnection(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, COMMAND_NAME, this.commandID);
        if (handle == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI connection fail.");
            return false;
        }
        this.processReqData(((Builder)this.commandArgs).sensorRecord);
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Starting to set sensor threshold.");
        SetSensorThresholdResponseData respData = this.ipmiReceiver.setSensorThreshold(handle, ((Builder)this.commandArgs).sensorRecord, COMMAND_NAME, this.commandID);
        if (respData == null || respData.getCompletionCode() != CompletionCode.Ok) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Set sensor threshold fail.");
            this.commandResults.add(new NullJSONData().setError(true).setMessages("Set sensor threshold fail."));
            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            return false;
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Set sensor threshold success.");
        this.commandResults.add(new NullJSONData().setError(false).setMessages("Set sensor threshold success."));
        this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
        return true;
    }

    private void processReqData(FullSensorRecord userInstance) {
        byte mask = 0;
        if (userInstance.getLowerNonCriticalThreshold() != 0.0) {
            mask = (byte)(mask + 1);
        } else {
            userInstance.setLowerCriticalThreshold(0.0);
        }
        if (userInstance.getLowerCriticalThreshold() != 0.0) {
            mask = (byte)(mask + 2);
        } else {
            userInstance.setLowerCriticalThreshold(0.0);
        }
        if (userInstance.getLowerNonRecoverableThreshold() != 0.0) {
            mask = (byte)(mask + 4);
        } else {
            userInstance.setLowerCriticalThreshold(0.0);
        }
        if (userInstance.getUpperNonCriticalThreshold() != 0.0) {
            mask = (byte)(mask + 8);
        } else {
            userInstance.setLowerCriticalThreshold(0.0);
        }
        if (userInstance.getUpperCriticalThreshold() != 0.0) {
            mask = (byte)(mask + 16);
        } else {
            userInstance.setLowerCriticalThreshold(0.0);
        }
        if (userInstance.getUpperNonRecoverableThreshold() != 0.0) {
            mask = (byte)(mask + 32);
        } else {
            userInstance.setLowerCriticalThreshold(0.0);
        }
        mask = (byte)(mask & userInstance.getSettableThresholdMask()[0]);
        userInstance.setSettableThresholdMask(new byte[]{mask});
    }

    @Override
    public void cancelHook(Object obj) {
    }

    @Override
    public void close() throws Exception {
        ((Builder)this.commandArgs).close();
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private String bmcIP;
        private String bmcUsername = "admin";
        private String bmcPassword = "password";
        private FullSensorRecord sensorRecord = null;

        @Override
        public boolean checkArgs() {
            if (this.bmcIP == null) {
                return false;
            }
            if (this.sensorRecord == null) {
                return false;
            }
            if (this.sensorRecord.getSensorNumber() == 0) {
                return false;
            }
            return this.sensorRecord.getSettableThresholdMask() != null;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public SetSensorThresholdsCommand build() {
            return new SetSensorThresholdsCommand(this);
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.bmcIP = null;
            this.bmcUsername = null;
            this.bmcPassword = null;
            this.sensorRecord = null;
            this.loggerWriter.close();
        }

        public Builder setBMCIP(String bmcIP) {
            this.bmcIP = bmcIP;
            return this.getThis();
        }

        public Builder setBMCUsername(String username) {
            this.bmcUsername = username;
            return this.getThis();
        }

        public Builder setBMCPassword(String password) {
            this.bmcPassword = password;
            return this.getThis();
        }

        public Builder setSensorRecord(FullSensorRecord sensorRecord) {
            this.sensorRecord = sensorRecord;
            return this.getThis();
        }
    }
}

