/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.SDR.record;

import Gbt.utility.SDR.record.AddressType;
import Gbt.utility.SDR.record.EntityId;
import Gbt.utility.SDR.record.InstanceModifierType;
import Gbt.utility.SDR.record.ModifierUnitUsage;
import Gbt.utility.SDR.record.RateUnit;
import Gbt.utility.SDR.record.SensorDirection;
import Gbt.utility.SDR.record.SensorRecord;
import Gbt.utility.SDR.record.SensorType;
import Gbt.utility.SDR.record.SensorUnit;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.veraxsystems.vxipmi.common.TypeConverter;

public final class CompactSensorRecord
extends SensorRecord {
    private byte sensorOwnerId;
    private AddressType addressType;
    private byte channelNumber;
    private byte sensorOwnerLun;
    private byte sensorNumber;
    private EntityId entityId;
    private boolean entityPhysical;
    private byte entityInstanceNumber;
    private boolean hysteresisReadable;
    private boolean thresholdsReadable;
    private SensorType sensorType;
    private int eventReadingType;
    private RateUnit rateUnit;
    private ModifierUnitUsage modifierUnitUsage;
    private SensorUnit sensorBaseUnit;
    private SensorUnit sensorModifierUnit;
    private SensorDirection sensorDirection;
    private String name;
    private InstanceModifierType idInstanceModifierType;
    private int shareCount;
    private boolean entityInstanceIncrements;
    private int idInstanceModifierOffset;

    @Override
    protected void populateTypeSpecficValues(byte[] recordData, SensorRecord record) {
        this.setSensorOwnerId(TypeConverter.intToByte((TypeConverter.byteToInt(recordData[5]) & 0xFE) >> 1));
        this.setAddressType(AddressType.parseInt(TypeConverter.byteToInt(recordData[5]) & 1));
        this.setChannelNumber(TypeConverter.intToByte((TypeConverter.byteToInt(recordData[6]) & 0xF0) >> 4));
        this.setSensorOwnerLun(TypeConverter.intToByte(TypeConverter.byteToInt(recordData[6]) & 3));
        this.setSensorNumber(recordData[7]);
        this.setEntityId(EntityId.parseInt(TypeConverter.byteToInt(recordData[8])));
        this.setEntityPhysical((TypeConverter.byteToInt(recordData[9]) & 0x80) == 0);
        this.setEntityInstanceNumber(TypeConverter.intToByte(TypeConverter.byteToInt(recordData[9]) & 0x7F));
        int hysteresis = (TypeConverter.byteToInt(recordData[11]) & 0x30) >> 4;
        if (hysteresis == 1 || hysteresis == 2) {
            this.setHysteresisReadable(true);
        } else {
            this.setHysteresisReadable(false);
        }
        int thresholds = (TypeConverter.byteToInt(recordData[11]) & 0xC) >> 2;
        if (thresholds == 1 || thresholds == 2) {
            this.setThresholdsReadable(true);
        } else {
            this.setThresholdsReadable(false);
        }
        this.setSensorType(SensorType.parseInt(TypeConverter.byteToInt(recordData[12])));
        this.setEventReadingType(TypeConverter.byteToInt(recordData[13]));
        this.setRateUnit(RateUnit.parseInt((TypeConverter.byteToInt(recordData[20]) & 0x38) >> 3));
        this.setModifierUnitUsage(ModifierUnitUsage.parseInt((TypeConverter.byteToInt(recordData[20]) & 6) >> 1));
        this.setSensorBaseUnit(SensorUnit.parseInt(TypeConverter.byteToInt(recordData[21])));
        this.setSensorModifierUnit(SensorUnit.parseInt(TypeConverter.byteToInt(recordData[22])));
        this.setSensorDirection(SensorDirection.parseInt((TypeConverter.byteToInt(recordData[23]) & 0xC0) >> 6));
        this.setIdInstanceModifierType(InstanceModifierType.parseInt((TypeConverter.byteToInt(recordData[23]) & 0x30) >> 4));
        this.setShareCount(TypeConverter.byteToInt(recordData[23]) & 0xF);
        this.setEntityInstanceIncrements((TypeConverter.byteToInt(recordData[24]) & 0x80) != 0);
        this.setIdInstanceModifierOffset(TypeConverter.byteToInt(recordData[24]) & 0x7F);
        if (recordData.length >= 32) {
            byte[] name = new byte[recordData.length - 32];
            System.arraycopy(recordData, 32, name, 0, name.length);
            this.setName(this.decodeName(recordData[31], name));
        }
    }

    @JsonProperty(value="SensorOwnerId")
    public byte getSensorOwnerId() {
        return this.sensorOwnerId;
    }

    public void setSensorOwnerId(byte sensorOwnerId) {
        this.sensorOwnerId = sensorOwnerId;
    }

    @JsonProperty(value="AddressType")
    public AddressType getAddressType() {
        return this.addressType;
    }

    public void setAddressType(AddressType addressType) {
        this.addressType = addressType;
    }

    @JsonProperty(value="ChannelNumber")
    public byte getChannelNumber() {
        return this.channelNumber;
    }

    public void setChannelNumber(byte channelNumber) {
        this.channelNumber = channelNumber;
    }

    @JsonProperty(value="SensorOwnerLun")
    public byte getSensorOwnerLun() {
        return this.sensorOwnerLun;
    }

    public void setSensorOwnerLun(byte sensorOwnerLun) {
        this.sensorOwnerLun = sensorOwnerLun;
    }

    @JsonProperty(value="SensorNumber")
    public byte getSensorNumber() {
        return this.sensorNumber;
    }

    public void setSensorNumber(byte sensorNumber) {
        this.sensorNumber = sensorNumber;
    }

    @JsonProperty(value="EntityId")
    public EntityId getEntityId() {
        return this.entityId;
    }

    public void setEntityId(EntityId entityId) {
        this.entityId = entityId;
    }

    @JsonProperty(value="EntityPhysical")
    public boolean isEntityPhysical() {
        return this.entityPhysical;
    }

    public void setEntityPhysical(boolean entityPhysical) {
        this.entityPhysical = entityPhysical;
    }

    @JsonProperty(value="EntityInstanceNumber")
    public byte getEntityInstanceNumber() {
        return this.entityInstanceNumber;
    }

    public void setEntityInstanceNumber(byte entityInstanceNumber) {
        this.entityInstanceNumber = entityInstanceNumber;
    }

    @JsonProperty(value="HysteresisReadable")
    public boolean isHysteresisReadable() {
        return this.hysteresisReadable;
    }

    public void setHysteresisReadable(boolean hysteresisReadable) {
        this.hysteresisReadable = hysteresisReadable;
    }

    @JsonProperty(value="ThresholdsReadable")
    public boolean isThresholdsReadable() {
        return this.thresholdsReadable;
    }

    public void setThresholdsReadable(boolean thresholdsReadable) {
        this.thresholdsReadable = thresholdsReadable;
    }

    @JsonProperty(value="SensorType")
    public SensorType getSensorType() {
        return this.sensorType;
    }

    public void setSensorType(SensorType sensorType) {
        this.sensorType = sensorType;
    }

    @JsonProperty(value="EventReadingType")
    public int getEventReadingType() {
        return this.eventReadingType;
    }

    public void setEventReadingType(int eventReadingType) {
        this.eventReadingType = eventReadingType;
    }

    @JsonProperty(value="RateUnit")
    public RateUnit getRateUnit() {
        return this.rateUnit;
    }

    public void setRateUnit(RateUnit rateUnit) {
        this.rateUnit = rateUnit;
    }

    @JsonProperty(value="ModifierUnitUsage")
    public ModifierUnitUsage getModifierUnitUsage() {
        return this.modifierUnitUsage;
    }

    public void setModifierUnitUsage(ModifierUnitUsage modifierUnitUsage) {
        this.modifierUnitUsage = modifierUnitUsage;
    }

    @JsonProperty(value="SensorBaseUnit")
    public SensorUnit getSensorBaseUnit() {
        return this.sensorBaseUnit;
    }

    public void setSensorBaseUnit(SensorUnit sensorBaseUnit) {
        this.sensorBaseUnit = sensorBaseUnit;
    }

    @JsonProperty(value="SensorModifierUnit")
    public SensorUnit getSensorModifierUnit() {
        return this.sensorModifierUnit;
    }

    public void setSensorModifierUnit(SensorUnit sensorModifierUnit) {
        this.sensorModifierUnit = sensorModifierUnit;
    }

    @JsonProperty(value="SensorDirection")
    public SensorDirection getSensorDirection() {
        return this.sensorDirection;
    }

    public void setSensorDirection(SensorDirection sensorDirection) {
        this.sensorDirection = sensorDirection;
    }

    @JsonProperty(value="Name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="IdInstanceModifierType")
    public InstanceModifierType getIdInstanceModifierType() {
        return this.idInstanceModifierType;
    }

    public void setIdInstanceModifierType(InstanceModifierType idInstanceModifierType) {
        this.idInstanceModifierType = idInstanceModifierType;
    }

    @JsonProperty(value="ShareCount")
    public int getShareCount() {
        return this.shareCount;
    }

    public void setShareCount(int shareCount) {
        this.shareCount = shareCount;
    }

    @JsonProperty(value="EntityInstanceIncrements")
    public boolean isEntityInstanceIncrements() {
        return this.entityInstanceIncrements;
    }

    public void setEntityInstanceIncrements(boolean entityInstanceIncrements) {
        this.entityInstanceIncrements = entityInstanceIncrements;
    }

    @JsonProperty(value="IdInstanceModifierOffset")
    public int getIdInstanceModifierOffset() {
        return this.idInstanceModifierOffset;
    }

    public void setIdInstanceModifierOffset(int idInstanceModifierOffset) {
        this.idInstanceModifierOffset = idInstanceModifierOffset;
    }
}

