/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.SMB;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.jsonapi.JacksonCommonUtil;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.utility.SMB.SMBFileInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileInputStream;
import jcifs.smb.SmbFileOutputStream;

public class SMBCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "smb";

    protected SMBCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = ((Builder)this.commandArgs).taskID + "_" + COMMAND_NAME;
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        return ((Builder)this.commandArgs).checkArgs();
    }

    @Override
    public boolean execute() {
        boolean result = true;
        NtlmPasswordAuthentication auth = new NtlmPasswordAuthentication("", ((Builder)this.commandArgs).smbUser, ((Builder)this.commandArgs).smbPassword);
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "SMB " + (Object)((Object)((Builder)this.commandArgs).action) + " action.");
        switch (((Builder)this.commandArgs).action) {
            case INFO: {
                try {
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, ((Builder)this.commandArgs).remoteUrl);
                    SMBFileInfo info = new SMBFileInfo();
                    SmbFile remoteFile = new SmbFile(((Builder)this.commandArgs).remoteUrl, auth);
                    if (remoteFile.exists()) {
                        if (remoteFile.isDirectory()) {
                            ArrayList<String> fileNames = new ArrayList<String>();
                            SmbFile[] files = remoteFile.listFiles();
                            this.sortFilesByLastModified(files);
                            for (SmbFile f : files) {
                                fileNames.add(f.getName());
                            }
                            info.setContentFiles(fileNames.toArray(new String[0]));
                        }
                        info.setExist(true);
                        info.setDirectory(remoteFile.isDirectory());
                        info.setDate(remoteFile.getDate());
                        info.setLastModified(remoteFile.getLastModified());
                        info.setName(remoteFile.getName());
                        info.setPath(remoteFile.getPath());
                        info.setReadable(remoteFile.canRead());
                        info.setWritable(remoteFile.canWrite());
                        info.setType(remoteFile.getType());
                        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, JacksonCommonUtil.getUtil().getPrettyPrintString(info));
                        this.commandResults.add(info);
                        break;
                    }
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "File path is not exist!");
                    info.setExist(false);
                    this.commandResults.add(info);
                    result = false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result = false;
                }
                break;
            }
            case DOWNLOAD: {
                try {
                    if (this.downloadFile(auth, ((Builder)this.commandArgs).remoteUrl, ((Builder)this.commandArgs).localPath)) {
                        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "SMB download complete.");
                        this.commandResults.add(new NullJSONData().setError(false).setMessages("SMB download complete:" + ((Builder)this.commandArgs).remoteUrl));
                        break;
                    }
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "Download action fail!");
                    this.commandResults.add(new NullJSONData().setError(true).setMessages("Download " + ((Builder)this.commandArgs).remoteUrl + " fail!"));
                    result = false;
                }
                catch (MalformedURLException e) {
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "SMB exception:" + ((Builder)this.commandArgs).remoteUrl);
                    e.printStackTrace();
                    this.commandResults.add(new NullJSONData().setError(true).setMessages("SMB download fail:" + ((Builder)this.commandArgs).remoteUrl));
                    result = false;
                }
                catch (SmbException e) {
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "SMB exception:" + ((Builder)this.commandArgs).remoteUrl);
                    e.printStackTrace();
                    this.commandResults.add(new NullJSONData().setError(true).setMessages("SMB download fail:" + ((Builder)this.commandArgs).remoteUrl));
                    result = false;
                }
                break;
            }
            case UPLOAD: {
                if (this.uploadFile(auth, ((Builder)this.commandArgs).remoteUrl, ((Builder)this.commandArgs).localPath)) {
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "Upload action success.");
                    this.commandResults.add(new NullJSONData().setError(false).setMessages("Upload to" + ((Builder)this.commandArgs).remoteUrl + " complete."));
                    break;
                }
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "Upload action fail!");
                this.commandResults.add(new NullJSONData().setError(true).setMessages("Upload to" + ((Builder)this.commandArgs).remoteUrl + " fail!"));
                result = false;
                break;
            }
            case DELETE: {
                if (this.deleteFile(auth, ((Builder)this.commandArgs).remoteUrl)) {
                    this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "Delete action success.");
                    this.commandResults.add(new NullJSONData().setError(false).setMessages("Delete " + ((Builder)this.commandArgs).remoteUrl + " complete."));
                    break;
                }
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "Delete action fail.");
                this.commandResults.add(new NullJSONData().setError(true).setMessages("Delete " + ((Builder)this.commandArgs).remoteUrl + " fail!"));
                break;
            }
            case LIST: {
                break;
            }
            default: {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "Unknown action.");
                result = false;
            }
        }
        return result;
    }

    @Override
    public void cancelHook(Object obj) {
    }

    @Override
    public void close() throws Exception {
        ((Builder)this.commandArgs).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean downloadFile(NtlmPasswordAuthentication auth, String remotePath, String localPath) throws MalformedURLException, SmbException {
        SmbFile remoteFile = new SmbFile(remotePath, auth);
        boolean result = true;
        if (remoteFile.isDirectory()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "Download " + remotePath + " (dir) to " + localPath + " (dir)");
            try {
                SmbFile[] subFiles;
                File localFileTarget = new File(localPath);
                localFileTarget.mkdir();
                for (SmbFile subFile : subFiles = remoteFile.listFiles()) {
                    if (subFile.getName().equalsIgnoreCase("Thumbs.db")) continue;
                    String savePath = localPath + File.separator + subFile.getName();
                    savePath = savePath.replaceAll("/\\\\", "/");
                    if (this.downloadFile(auth, subFile.getPath(), savePath)) continue;
                    result = false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                result = false;
            }
            return result;
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "Download " + remotePath + " (file) to " + localPath + " (file)");
        FileOutputStream fos = null;
        SmbFileInputStream sfis = null;
        try {
            int len;
            SmbFile smbFileTarget = new SmbFile(remotePath, auth);
            sfis = new SmbFileInputStream(smbFileTarget);
            fos = new FileOutputStream(new File(localPath));
            byte[] buf = new byte[1024];
            while ((len = sfis.read(buf)) > 0) {
                fos.write(buf, 0, len);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = false;
        }
        finally {
            if (sfis != null) {
                try {
                    sfis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean uploadFile(NtlmPasswordAuthentication auth, String remotePath, String localPath) {
        File localFile = new File(localPath);
        if (localFile.isDirectory()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "Upload " + localPath + " (dir) to " + remotePath + " (dir)");
            try {
                File[] subFiles;
                SmbFile smbFileTarget = new SmbFile(remotePath, auth);
                smbFileTarget.mkdirs();
                for (File subFile : subFiles = localFile.listFiles()) {
                    this.uploadFile(auth, remotePath + "/" + subFile.getName(), subFile.getAbsolutePath());
                }
            }
            catch (Exception e) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "Upload directory fail!", e);
                return false;
            }
            return true;
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "Upload " + localPath + " (file) to " + remotePath + " (file)");
        FileInputStream fis = null;
        SmbFileOutputStream smbfos = null;
        try {
            SmbFile smbFileTarget = new SmbFile(remotePath, auth);
            fis = new FileInputStream(localPath);
            smbfos = new SmbFileOutputStream(smbFileTarget);
            byte[] b = new byte[16384];
            int read = 0;
            while ((read = fis.read(b, 0, b.length)) > 0) {
                smbfos.write(b, 0, read);
            }
            fis.close();
            smbfos.close();
        }
        catch (Exception e) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "Upload file fail!", e);
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (smbfos != null) {
                try {
                    smbfos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    private boolean deleteFile(NtlmPasswordAuthentication auth, String remotePath) {
        SmbFile smbFileTarget = null;
        try {
            smbFileTarget = new SmbFile(remotePath, auth);
            if (smbFileTarget.exists()) {
                smbFileTarget.delete();
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "Delete " + remotePath + " success.");
            } else {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, remotePath + " is not exist.");
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "Delete file fail!", e);
            return false;
        }
        catch (SmbException e) {
            e.printStackTrace();
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "Delete file fail!", e);
            return false;
        }
        return true;
    }

    private void sortFilesByLastModified(SmbFile[] files) {
        Arrays.sort(files, new Comparator<SmbFile>(){

            @Override
            public int compare(SmbFile f1, SmbFile f2) {
                long f1Long = 0L;
                long f2Long = 0L;
                try {
                    f1Long = f1.lastModified();
                    f2Long = f2.lastModified();
                }
                catch (SmbException e) {
                    e.printStackTrace();
                }
                return Long.valueOf(f2Long).compareTo(f1Long);
            }
        });
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private String taskID;
        private String remoteUrl;
        private String localPath;
        private String smbUser;
        private String smbPassword;
        private smbAction action;

        public Builder setTaskID(String taskID) {
            this.taskID = taskID;
            return this;
        }

        public Builder setRemoteUrl(String remoteUrl) {
            this.remoteUrl = remoteUrl;
            return this;
        }

        public String getRemoteUrl() {
            return this.remoteUrl;
        }

        public Builder setLocalPath(String localPath) {
            this.localPath = localPath;
            return this;
        }

        public Builder setSmbUser(String smbUser) {
            this.smbUser = smbUser;
            return this;
        }

        public Builder setSmbPassword(String smbPassword) {
            this.smbPassword = smbPassword;
            return this;
        }

        public Builder setAction(smbAction action) {
            this.action = action;
            return this;
        }

        @Override
        public boolean checkArgs() {
            if (this.args != null) {
                if (this.args.length < 1) {
                    return false;
                }
                switch (this.args[0]) {
                    case "info": {
                        if (this.args.length < 2) {
                            return false;
                        }
                        this.action = smbAction.INFO;
                        this.remoteUrl = this.args[1];
                        break;
                    }
                    case "list": {
                        if (this.args.length < 2) {
                            return false;
                        }
                        this.action = smbAction.LIST;
                        this.remoteUrl = this.args[1];
                        break;
                    }
                    case "download": {
                        if (this.args.length < 3) {
                            return false;
                        }
                        this.action = smbAction.DOWNLOAD;
                        this.remoteUrl = this.args[1];
                        this.localPath = this.args[2];
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            }
            if (this.remoteUrl == null || this.smbUser == null || this.smbPassword == null || this.action == null) {
                return false;
            }
            if (this.remoteUrl.equals("") || this.smbUser.equals("") || this.smbPassword.equals("")) {
                return false;
            }
            if ((this.action.equals((Object)smbAction.DOWNLOAD) || this.action.equals((Object)smbAction.UPLOAD)) && (this.localPath == null || this.localPath.equals(""))) {
                return false;
            }
            if (!this.remoteUrl.endsWith("/")) {
                this.remoteUrl = this.remoteUrl + "/";
            }
            return true;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public SMBCommand build() {
            return new SMBCommand(this);
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.localPath = null;
            this.action = null;
            this.smbUser = null;
            this.smbPassword = null;
            this.loggerWriter.close();
        }
    }

    public static enum smbAction {
        INFO,
        DOWNLOAD,
        UPLOAD,
        DELETE,
        LIST;

    }
}

