/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.SMBIOS;

import com.fasterxml.jackson.annotation.JsonValue;

public enum PhysicalMemoryArrayUses {
    Other(1, "Other"),
    Unknown(2, "Unknown"),
    SystemMemory(3, "System memory"),
    VideoMemory(4, "Video memory"),
    FlashMemory(5, "Flash memory"),
    NonVolatileRAMMemory(6, "Non-volatile RAM"),
    CacheMemory(7, "Cache memory");

    private static final byte CODE_1 = 1;
    private static final byte CODE_2 = 2;
    private static final byte CODE_3 = 3;
    private static final byte CODE_4 = 4;
    private static final byte CODE_5 = 5;
    private static final byte CODE_6 = 6;
    private static final byte CODE_7 = 7;
    private static final String ITEM_1 = "Other";
    private static final String ITEM_2 = "Unknown";
    private static final String ITEM_3 = "System memory";
    private static final String ITEM_4 = "Video memory";
    private static final String ITEM_5 = "Flash memory";
    private static final String ITEM_6 = "Non-volatile RAM";
    private static final String ITEM_7 = "Cache memory";
    private final byte code;
    private final String item;

    private PhysicalMemoryArrayUses(byte code, String item) {
        this.code = code;
        this.item = item;
    }

    public byte getCode() {
        return this.code;
    }

    @JsonValue
    public String toString() {
        return this.item;
    }

    public static final PhysicalMemoryArrayUses parseUse(byte raw) {
        switch (raw) {
            case 1: {
                return Other;
            }
            case 2: {
                return Unknown;
            }
            case 3: {
                return SystemMemory;
            }
            case 4: {
                return VideoMemory;
            }
            case 5: {
                return FlashMemory;
            }
            case 6: {
                return NonVolatileRAMMemory;
            }
            case 7: {
                return CacheMemory;
            }
        }
        return null;
    }
}

