/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.SMBIOS;

import Gbt.utility.Common.GbtCommonConverters;
import Gbt.utility.SMBIOS.SmbiosTypeBase;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class SmbiosType19
extends SmbiosTypeBase {
    private String startingAddress;
    private String endingAddress;
    private String rangeSize;
    private String memoryArrayHandle;
    private String partitionWidth;
    private String extendedStartingAddress;
    private String extendedEndingAddress;

    public SmbiosType19(byte[] rawData) {
        super(rawData);
    }

    @Override
    public void parser() {
        byte[] startingAddressRaw = this.nextBYTES(4);
        byte[] endingAddressRaw = this.nextBYTES(4);
        byte[] memoryArrayHandleRaw = this.nextBYTES(2);
        byte partitionWidthRaw = this.nextBYTE();
        byte[] extendedStartingAddressRaw = this.nextBYTES(8);
        byte[] extendedEndingAddressRaw = this.nextBYTES(8);
        this.startingAddress = this.getByteString(startingAddressRaw);
        this.endingAddress = this.getByteString(endingAddressRaw);
        this.rangeSize = this.parseRangeSize(startingAddressRaw, endingAddressRaw, extendedStartingAddressRaw, extendedEndingAddressRaw);
        this.memoryArrayHandle = this.getByteString(memoryArrayHandleRaw);
        this.partitionWidth = this.getByteString(new byte[]{partitionWidthRaw});
        this.extendedStartingAddress = this.getByteString(extendedStartingAddressRaw);
        this.extendedEndingAddress = this.getByteString(extendedEndingAddressRaw);
    }

    @JsonProperty(value="StartingAddress")
    public String getStartingAddress() {
        return this.startingAddress;
    }

    @JsonProperty(value="EndingAddress")
    public String getEndingAddress() {
        return this.endingAddress;
    }

    @JsonProperty(value="RangeSize")
    public String getRangeSize() {
        return this.rangeSize;
    }

    @JsonProperty(value="MemoryArrayHandle")
    public String getMemoryArrayHandle() {
        return this.memoryArrayHandle;
    }

    @JsonProperty(value="PartitionWidth")
    public String getPartitionWidth() {
        return this.partitionWidth;
    }

    @JsonProperty(value="ExtendedStartingAddress")
    public String getExtendedStartingAddress() {
        return this.extendedStartingAddress;
    }

    @JsonProperty(value="ExtendedEndingAddress")
    public String getExtendedEndingAddress() {
        return this.extendedEndingAddress;
    }

    private String parseRangeSize(byte[] startingAddressRaw, byte[] endingAddressRaw, byte[] extendedStartingAddressRaw, byte[] extendedEndingAddressRaw) {
        long start = GbtCommonConverters.ByteArraytoLong(startingAddressRaw);
        long end = GbtCommonConverters.ByteArraytoLong(endingAddressRaw);
        long result = (end - start + 1L) / 1024L / 1024L;
        if (start == 0xFFFFFFFFL && end == 0xFFFFFFFFL) {
            start = GbtCommonConverters.ByteArraytoLong(extendedStartingAddressRaw);
            end = GbtCommonConverters.ByteArraytoLong(extendedEndingAddressRaw);
            result = (end - start + 1L) / 1024L / 1024L / 1024L;
        }
        return Long.toString(result);
    }
}

