/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.Update.parsers;

import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.utility.Common.CommonFunction;
import Gbt.utility.Common.GIGABYTEChecksum;
import Gbt.utility.FRU.record.BoardInfo;
import Gbt.utility.FRU.record.ProductInfo;
import Gbt.utility.Update.UpdateType;
import Gbt.utility.Update.fwInfo.CPLDUpdateFWInfo;
import Gbt.utility.Update.parsers.SuitableFwParser;
import Gbt.utility.bmcinfo.BMCInfoJSONData;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.ArrayUtils;

public final class CpldSuitableFwParser
extends SuitableFwParser {
    private final UpdateType updateType;

    public CpldSuitableFwParser(AbstractLoggerWriter loggerWriter, String commandName, String commandId, String bmcIpAddress, UpdateType updateType) {
        super(loggerWriter, commandName, commandId, bmcIpAddress);
        this.updateType = updateType;
    }

    @Override
    public CPLDUpdateFWInfo parseSuitableFw(List<File> fwPackages, BoardInfo boardInfo, ProductInfo productInfo, BMCInfoJSONData mcinfo) {
        String boardProduct = boardInfo.getBoardProductName();
        String productName = productInfo.getProductName();
        ArrayList<CPLDUpdateFWInfo> chosenPkgs = new ArrayList<CPLDUpdateFWInfo>();
        for (File fwPkg : fwPackages) {
            String dirPath = FilenameUtils.removeExtension((String)fwPkg.getAbsolutePath());
            List<File> relNotePathList = CommonFunction.searchFilesInDirector(dirPath, ".doc", true);
            if (relNotePathList.isEmpty() && (relNotePathList = CommonFunction.searchFilesInDirector(dirPath, ".docx", true)).isEmpty() && (relNotePathList = CommonFunction.searchFilesInDirector(dirPath, ".pdf", true)).isEmpty()) {
                this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandId, "[" + this.bmcIpAddress + "] Cannot find any CPLD release notes.");
                return null;
            }
            for (File relNotePath : relNotePathList) {
                try {
                    int lineLocation;
                    CPLDUpdateFWInfo updateFWInfo = new CPLDUpdateFWInfo();
                    updateFWInfo.setBmcVendor(mcinfo.getBmcVendor());
                    updateFWInfo.setTargetBmcIp(this.bmcIpAddress);
                    updateFWInfo.setBmcProductID(mcinfo.getProductID());
                    updateFWInfo.setUpdateType(this.updateType);
                    updateFWInfo.setFWFolderPath(dirPath);
                    List<String> lines = CommonFunction.readDocumentsAsLineList(relNotePath.getAbsolutePath());
                    int i = lineLocation = 2;
                    while (!lines.get(i).contains("Subject")) {
                        updateFWInfo.setSupportedProductName(lines.get(i).trim().split("\t"));
                        ++i;
                    }
                    lineLocation = lines.indexOf("Device Information") + 4;
                    String[] checkStringArr = lines.get(lineLocation).trim().split("\t")[1].trim().split("/");
                    int[] checkIntArr = new int[checkStringArr.length];
                    for (int i2 = 0; i2 < checkStringArr.length; ++i2) {
                        checkIntArr[i2] = Integer.parseInt(checkStringArr[i2].trim().replace("0x", ""), 16);
                    }
                    updateFWInfo.setChecksum(checkIntArr);
                    lineLocation = lines.indexOf("Revision History") + 2;
                    updateFWInfo.setNewVersion(lines.get(lineLocation).trim().split("\t")[0]);
                    updateFWInfo.setReleaseDate(lines.get(lineLocation).trim().split("\t")[1].trim().replace(".", "/"));
                    File cpldFW = this.findCPLDImg(dirPath, ".rcu");
                    if (cpldFW != null) {
                        if (!this.parserCPLDFW(cpldFW)) {
                            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.DEBUG, this.commandId, "[" + this.bmcIpAddress + "] CPLD fw header is not current!! ");
                            return null;
                        }
                    } else {
                        this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.DEBUG, this.commandId, "[" + this.bmcIpAddress + "] Cannot find any rcu file in zip file");
                        return null;
                    }
                    updateFWInfo.setImagePath(cpldFW.getAbsolutePath());
                    updateFWInfo.setCpldFwName(cpldFW.getName());
                    if (this.compareCPLDFWProductName(boardProduct, productName, updateFWInfo, mcinfo)) {
                        chosenPkgs.add(updateFWInfo);
                        continue;
                    }
                    this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.DEBUG, this.commandId, "[" + this.bmcIpAddress + "] Cannot find any matched product name or board product in release notes : \"" + relNotePath.getName() + "\"");
                }
                catch (Exception e) {
                    this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandId, "[" + this.bmcIpAddress + "] " + e.getMessage());
                    return null;
                }
            }
        }
        if (chosenPkgs.isEmpty()) {
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandId, "[" + this.bmcIpAddress + "] Cannot find any suitable CPLD FW.");
            return null;
        }
        long[] longDates = new long[chosenPkgs.size()];
        for (int i = 0; i < chosenPkgs.size(); ++i) {
            longDates[i] = ((CPLDUpdateFWInfo)chosenPkgs.get(i)).getReleaseDate().getTime();
        }
        List<Long> b = Arrays.asList(ArrayUtils.toObject((long[])longDates));
        return (CPLDUpdateFWInfo)chosenPkgs.get(b.indexOf(Collections.max(b)));
    }

    private File findCPLDImg(String searchRootPath, String firmwareExtName) {
        List<File> imgPath = CommonFunction.searchFilesInDirector(searchRootPath, firmwareExtName, true);
        if (imgPath.isEmpty()) {
            return null;
        }
        if (imgPath.size() == 1) {
            return imgPath.get(0);
        }
        this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandId, "[" + this.bmcIpAddress + "] There are more then one CPLD FW in package !");
        return null;
    }

    private boolean parserCPLDFW(File cpldFile) {
        String fileName = cpldFile.getName();
        String filePath = cpldFile.getAbsolutePath();
        boolean checkHeaderStatus = GIGABYTEChecksum.cpldCheckHeader(filePath);
        if (fileName.endsWith(".vme")) {
            if (!checkHeaderStatus) {
                this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandId, "[" + this.bmcIpAddress + "] The CPLD FW has no header (.vme) !");
            }
        } else if (fileName.endsWith(".rcu") && !checkHeaderStatus) {
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandId, "[" + this.bmcIpAddress + "] The CPLD FW has no header (.rcu) !");
            return false;
        }
        return true;
    }

    private boolean compareCPLDFWProductName(String boardProduct, String productName, CPLDUpdateFWInfo cpldFWinfo, BMCInfoJSONData bmcInfoJSONData) {
        String _boardProduct;
        if (boardProduct == null && productName == null) {
            return false;
        }
        if (cpldFWinfo.getSupportedProductName() == null) {
            return false;
        }
        if (cpldFWinfo.getSupportedProductName().isEmpty()) {
            return false;
        }
        String string = bmcInfoJSONData.isAST2400() ? (boardProduct.split("-").length == 3 ? boardProduct : boardProduct + "-XX") : (_boardProduct = boardProduct.split("-").length == 3 ? boardProduct : boardProduct + "-00");
        String _productName = bmcInfoJSONData.isAST2400() ? (productName.split("-").length == 3 ? productName : productName + "-XX") : (productName.split("-").length == 3 ? productName : productName + "-00");
        for (String name : cpldFWinfo.getSupportedProductName()) {
            String _name;
            String string2 = bmcInfoJSONData.isAST2400() ? (name.split("-").length == 3 ? name : name + "-XX") : (_name = name.split("-").length == 3 ? name : name + "-00");
            if (_name.equals(_productName)) {
                return true;
            }
            if (!_name.equals(_boardProduct)) continue;
            return true;
        }
        return false;
    }
}

