/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.Update.parsers;

import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.utility.Common.CommonFunction;
import Gbt.utility.FRU.record.BoardInfo;
import Gbt.utility.FRU.record.ProductInfo;
import Gbt.utility.Update.UpdateType;
import Gbt.utility.Update.fwInfo.FpgaUpdateFWInfo;
import Gbt.utility.Update.parsers.SuitableFwParser;
import Gbt.utility.bmcinfo.BMCInfoJSONData;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

public class FpgaSuitableFwParser
extends SuitableFwParser {
    public FpgaSuitableFwParser(AbstractLoggerWriter loggerWriter, String commandName, String commandId, String bmcIpAddress) {
        super(loggerWriter, commandName, commandId, bmcIpAddress);
    }

    @Override
    public FpgaUpdateFWInfo parseSuitableFw(List<File> fwPackages, BoardInfo boardInfo, ProductInfo productInfo, BMCInfoJSONData mcinfo) {
        String boardProduct = boardInfo.getBoardProductName();
        String productName = productInfo.getProductName();
        ArrayList<FpgaUpdateFWInfo> chosenPkgs = new ArrayList<FpgaUpdateFWInfo>();
        for (File fwPkg : fwPackages) {
            String dirPath = FilenameUtils.removeExtension((String)fwPkg.getAbsolutePath());
            try {
                StringBuilder builder;
                FpgaUpdateFWInfo fpgaUpdateFWInfo = new FpgaUpdateFWInfo();
                fpgaUpdateFWInfo.setBmcVendor(mcinfo.getBmcVendor());
                fpgaUpdateFWInfo.setTargetBmcIp(this.bmcIpAddress);
                fpgaUpdateFWInfo.setUpdateType(UpdateType.FPGA);
                fpgaUpdateFWInfo.setFwFolderPath(dirPath);
                fpgaUpdateFWInfo.setReleaseNote(null);
                List<File> projectTxt = CommonFunction.searchFilesInDirector(dirPath, "projects.txt", true);
                if (projectTxt.isEmpty()) {
                    this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandId, "[" + this.bmcIpAddress + "] Cannot find any projects.txt.");
                    return null;
                }
                List<String> pnames = CommonFunction.readFile(projectTxt.get(0).getAbsolutePath());
                if (!pnames.isEmpty()) {
                    builder = new StringBuilder();
                    for (String pname : pnames) {
                        builder.append(pname);
                    }
                } else {
                    this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandId, "[" + this.bmcIpAddress + "] Cannot find any support projects in projects.txt!");
                    continue;
                }
                fpgaUpdateFWInfo.setSupportedProductName(builder.toString().replace(" ", ""));
                builder.setLength(0);
                String fwExtension = ".rpd";
                List<File> hpmList = CommonFunction.searchFilesInDirector(dirPath, fwExtension, true);
                if (hpmList != null && hpmList.size() > 0) {
                    fpgaUpdateFWInfo.setImagePath(hpmList.get(0).getAbsolutePath());
                }
                if (this.compareBMCFWProductName(boardProduct, productName, fpgaUpdateFWInfo, mcinfo)) {
                    chosenPkgs.add(fpgaUpdateFWInfo);
                    continue;
                }
                this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandId, "[" + this.bmcIpAddress + "] Cannot find any matched product name or board product from : \"" + fpgaUpdateFWInfo.getFwFolderPath() + "\"");
                this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.DEBUG, this.commandId, "[" + this.bmcIpAddress + "] " + fpgaUpdateFWInfo.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandId, "[" + this.bmcIpAddress + "] Parse " + fwPkg.getAbsolutePath() + " fail.");
            }
        }
        if (chosenPkgs.isEmpty()) {
            this.loggerWriter.appendPath(this.commandName).writeLogs(GbtLogLevel.ERROR, this.commandId, "[" + this.bmcIpAddress + "] Cannot find any suitable BMC FW.");
            return null;
        }
        return (FpgaUpdateFWInfo)chosenPkgs.get(0);
    }

    private boolean compareBMCFWProductName(String boardProduct, String productName, FpgaUpdateFWInfo fpgaUpdFwInfo, BMCInfoJSONData bmcInfoJSONData) {
        String _boardProduct;
        if (boardProduct == null && productName == null) {
            return false;
        }
        if (fpgaUpdFwInfo.getSupportedProductName() == null) {
            return false;
        }
        if (fpgaUpdFwInfo.getSupportedProductName().isEmpty()) {
            return false;
        }
        boardProduct = boardProduct.replace(" ", "");
        productName = productName.replace(" ", "");
        String string = bmcInfoJSONData.isAST2400() ? (boardProduct.split("-").length == 3 ? boardProduct : boardProduct + "-XX") : (_boardProduct = boardProduct.split("-").length == 3 ? boardProduct : boardProduct + "-00");
        String _productName = bmcInfoJSONData.isAST2400() ? (productName.split("-").length == 3 ? productName : productName + "-XX") : (productName.split("-").length == 3 ? productName : productName + "-00");
        for (String name : fpgaUpdFwInfo.getSupportedProductName()) {
            String _name;
            String string2 = bmcInfoJSONData.isAST2400() ? (name.split("-").length == 3 ? name : name + "-XX") : (_name = name.split("-").length == 3 ? name : name + "-00");
            if (_name.equals(_productName)) {
                return true;
            }
            if (!_name.equals(_boardProduct)) continue;
            return true;
        }
        return false;
    }
}

