/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.diag;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.engines.records.SSHCmdRecords;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.core.receivers.GbtLocalCommandReceiver;
import Gbt.core.receivers.GbtSSHCommandReceiver;
import Gbt.utility.Chassis.PowerCommand;
import Gbt.utility.Common.CommonFunction;
import Gbt.utility.bootoptions.BootOptions;
import Gbt.utility.vmclitool.VmcliMountInfo;
import com.jcraft.jsch.Session;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import com.veraxsystems.vxipmi.coding.commands.chassis.GetChassisStatusResponseData;
import java.io.File;
import java.util.List;
import java.util.Map;

public class DiagCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "diag";
    private GbtIPMICommandReceiver ipmiReceiver;
    private GbtLocalCommandReceiver localReceiver;
    private GbtSSHCommandReceiver sshReceiver;

    private DiagCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = ((Builder)this.commandArgs).bmcIP + "_" + COMMAND_NAME;
        this.ipmiReceiver = GbtIPMICommandReceiver.getInstance();
        this.localReceiver = GbtLocalCommandReceiver.getInstance();
        this.sshReceiver = GbtSSHCommandReceiver.getInstance();
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        if (this.ipmiReceiver == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI command receiver is null.");
            return false;
        }
        if (this.localReceiver == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Local command receiver is null.");
            return false;
        }
        if (this.sshReceiver == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] SSH command receiver is null.");
            return false;
        }
        if (!((Builder)this.commandArgs).checkArgs()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Command arguments check fail.");
            return false;
        }
        if (this.commandArgs == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Remote BMC IP is null.");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        ConnectionHandle handle = this.ipmiReceiver.createIPMIConnection(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, COMMAND_NAME, this.commandID);
        if (handle == null) {
            return false;
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start to mount mini OS to " + ((Builder)this.commandArgs).bmcIP + ".");
        if (((Builder)this.commandArgs).stressItem.equals("kill")) {
            return this.sshAndkillCommand(handle);
        }
        this.forcePowerON(handle);
        if (!this.mountMiniOS()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Mount ISO file fail.");
            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            return false;
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] UEFI:" + ((Builder)this.commandArgs).isUEFI);
        this.ipmiReceiver.setBootOption(handle, BootOptions.VMCDROM, ((Builder)this.commandArgs).isUEFI, COMMAND_NAME, this.commandID);
        this.ipmiReceiver.chassisPowerCommand(handle, PowerCommand.PowerCycle, COMMAND_NAME, this.commandID);
        Map<String, String> macs = this.ipmiReceiver.get3LANMACs(handle, COMMAND_NAME, this.commandID);
        String dataLANIP = this.waitBootComplete(macs, "root", "111111", handle, 10000, false);
        this.unmountMiniOS();
        Session session = this.sshReceiver.openSession(dataLANIP, "root", "111111", COMMAND_NAME, this.commandID);
        if (((Builder)this.commandArgs).stressItem.equals("update")) {
            return this.sshAndWaitUpdateComplete(session, handle);
        }
        String parameter = ((Builder)this.commandArgs).stressItem + " " + ((Builder)this.commandArgs).stressMin;
        SSHCmdRecords sshRecords = this.sshReceiver.executeCMD(session, "cd /root/linux_pkg/scripts ; ./single_stress.sh " + parameter + " > foo.out 2> foo.err < /dev/null &", false, COMMAND_NAME, this.commandID);
        if (sshRecords.getStates().isFail()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execute script fail.");
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, sshRecords.getResults());
            sshRecords.clearMesg();
            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            this.sshReceiver.closeSession(session, COMMAND_NAME, this.commandID);
            return false;
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start stress " + ((Builder)this.commandArgs).stressItem + "...");
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.TRACE, this.commandID, sshRecords.getResults());
        sshRecords.clearMesg();
        int totalCount = ((Builder)this.commandArgs).stressMin * 60 / 10 + 2;
        int nowCount = 0;
        boolean result = false;
        while (nowCount <= totalCount) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Waitting for stress complete...[" + this.getElapsedTimes() + "] (" + nowCount + ")");
            sshRecords = this.sshReceiver.executeCMD(session, "cat /root/linux_pkg/scripts/*_localtest.log", false, COMMAND_NAME, this.commandID);
            if (sshRecords.getResults().contains("is fail")) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "===========[" + ((Builder)this.commandArgs).bmcIP + "]===========");
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, sshRecords.getResults());
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "======================================");
                result = false;
                break;
            }
            if (sshRecords.getResults().contains("is pass")) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "===========[" + ((Builder)this.commandArgs).bmcIP + "]===========");
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, sshRecords.getResults());
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "======================================");
                result = true;
                break;
            }
            try {
                ++nowCount;
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (nowCount > totalCount) {
            sshRecords = this.sshReceiver.executeCMD(session, "cat /root/linux_pkg/scripts/*_localtest.log", false, COMMAND_NAME, this.commandID);
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "(over waiitng time)[" + ((Builder)this.commandArgs).bmcIP + "]===========");
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, sshRecords.getResults());
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "======================================");
        }
        if (sshRecords.getResults().contains("is fail")) {
            result = false;
        } else if (sshRecords.getResults().contains("is pass")) {
            result = true;
        }
        sshRecords.clearMesg();
        this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
        this.sshReceiver.closeSession(session, COMMAND_NAME, this.commandID);
        return result;
    }

    @Override
    public void close() throws Exception {
        ((Builder)this.commandArgs).close();
    }

    @Override
    public void cancelHook(Object obj) {
    }

    private boolean sshAndkillCommand(ConnectionHandle handle) {
        String dataLANIP = "0.0.0.0";
        Map<String, String> macs = this.ipmiReceiver.get3LANMACs(handle, COMMAND_NAME, this.commandID);
        dataLANIP = ((Builder)this.commandArgs).debugFile != null ? this.findIPByDebugFile() : this.localReceiver.getActivateDHCPIP(macs, COMMAND_NAME, this.commandID);
        for (int i = 0; i < 3; ++i) {
            if (dataLANIP.equals("0.0.0.0")) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Wait for target node IP ... (" + i + ")");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Find data LAN IP:" + dataLANIP);
        }
        if (dataLANIP.equals("0.0.0.0")) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Can't find target node IP.");
            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            return false;
        }
        Session session = this.sshReceiver.openSession(dataLANIP, "root", "111111", COMMAND_NAME, this.commandID);
        SSHCmdRecords sshRecords = this.sshReceiver.executeCMD(session, "ps -afjl | grep \"timeout -k\" | sed '2,$d' | awk '{print $4,$6,$13,$17}' | sed 's/ /,/g'", false, COMMAND_NAME, this.commandID);
        String pid = "";
        if (sshRecords.getStates().isFail()) {
            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            this.sshReceiver.closeSession(session, COMMAND_NAME, this.commandID);
        } else {
            try {
                pid = sshRecords.getResults().split(",")[0];
            }
            catch (Exception e) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Parse PID fail:\n" + sshRecords.getResults());
                this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
                this.sshReceiver.closeSession(session, COMMAND_NAME, this.commandID);
                return false;
            }
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Get PID:" + pid);
        sshRecords = this.sshReceiver.executeCMD(session, "kill " + pid, false, COMMAND_NAME, this.commandID);
        if (sshRecords.getStates().isFail()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Kill command fail.");
            this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
            this.sshReceiver.closeSession(session, COMMAND_NAME, this.commandID);
        } else {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Kill command success.");
        }
        this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
        this.sshReceiver.closeSession(session, COMMAND_NAME, this.commandID);
        return true;
    }

    private boolean sshAndWaitUpdateComplete(Session session, ConnectionHandle handle) {
        SSHCmdRecords sshRecords;
        int totalCount = ((Builder)this.commandArgs).stressMin * 60 / 10 + 2;
        int nowCount = 0;
        boolean result = false;
        while (nowCount <= totalCount) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Waitting for update complete...[" + this.getElapsedTimes() + "] (" + nowCount + ")");
            sshRecords = this.sshReceiver.executeCMD(session, "cat /tmp/updateLog", false, COMMAND_NAME, this.commandID);
            if (sshRecords.getResults().toLowerCase().contains("fail") || sshRecords.getResults().toLowerCase().contains("error")) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "===========[" + ((Builder)this.commandArgs).bmcIP + "]===========");
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, sshRecords.getResults());
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "======================================");
                sshRecords.clearMesg();
                result = false;
                break;
            }
            if (sshRecords.getResults().toLowerCase().contains("diag complete")) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "===========[" + ((Builder)this.commandArgs).bmcIP + "]===========");
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, sshRecords.getResults());
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "======================================");
                sshRecords.clearMesg();
                result = true;
                break;
            }
            try {
                ++nowCount;
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (nowCount > totalCount) {
            sshRecords = this.sshReceiver.executeCMD(session, "cat /tmp/updateLog", false, COMMAND_NAME, this.commandID);
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "(over waiitng time)[" + ((Builder)this.commandArgs).bmcIP + "]===========");
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, sshRecords.getResults());
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "======================================");
            sshRecords.clearMesg();
        }
        this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
        this.sshReceiver.closeSession(session, COMMAND_NAME, this.commandID);
        return result;
    }

    private void forcePowerON(ConnectionHandle handle) {
        GetChassisStatusResponseData powerStates = this.ipmiReceiver.getChassisPowerStates(handle, COMMAND_NAME, this.commandID);
        if (!powerStates.isPowerOn()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Target node power off and start to turn on.");
            this.ipmiReceiver.chassisPowerCommand(handle, PowerCommand.PowerUp, COMMAND_NAME, this.commandID);
            do {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Wait for target node power on.");
                powerStates = this.ipmiReceiver.getChassisPowerStates(handle, COMMAND_NAME, this.commandID);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (!powerStates.isPowerOn());
        } else {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Target node is power on.");
        }
    }

    private String waitBootComplete(Map<String, String> macs, String username, String password, ConnectionHandle handle, int pingInterval, boolean longWaitReboot) {
        int count = 0;
        String dataLANIP = "0.0.0.0";
        Session session = null;
        do {
            ++count;
            if (Thread.currentThread().isInterrupted()) break;
            if (count % 50 == 0 && longWaitReboot) {
                this.ipmiReceiver.chassisPowerCommand(handle, PowerCommand.PowerCycle, COMMAND_NAME, this.commandID);
            }
            try {
                Thread.sleep(pingInterval);
            }
            catch (InterruptedException ie) {
                break;
            }
            if (((Builder)this.commandArgs).debugFile != null) {
                dataLANIP = this.findIPByDebugFile();
            } else {
                System.out.println("Debug file is null");
                dataLANIP = this.localReceiver.getActivateDHCPIP(macs, COMMAND_NAME, this.commandID);
            }
            if (dataLANIP.equals("0.0.0.0")) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Wait for target node boot complete ...[" + this.getElapsedTimes() + "] (" + count + ")");
                continue;
            }
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Find data LAN IP:" + dataLANIP);
            if (!this.localReceiver.pingDataLAN(dataLANIP, COMMAND_NAME, this.commandID)) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Ping is not respose ...[" + this.getElapsedTimes() + "] (" + count + ")");
                continue;
            }
            session = this.sshReceiver.openSession(dataLANIP, username, password, COMMAND_NAME, this.commandID);
            if (!session.isConnected()) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] SSH is not connected yet.[" + this.getElapsedTimes() + "] (" + count + ")");
                if (count <= 100) continue;
                dataLANIP = "0.0.0.0";
                break;
            }
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] SSH success, boot complete.[" + this.getElapsedTimes() + "] (" + count + ")");
            this.sshReceiver.closeSession(session, COMMAND_NAME, this.commandID);
            break;
        } while (count <= 100);
        return dataLANIP;
    }

    private String findIPByDebugFile() {
        String dataLANIP = "0.0.0.0";
        List<String> srcList = CommonFunction.readFile(((Builder)this.commandArgs).debugFile.getAbsolutePath());
        if (srcList.isEmpty()) {
            System.out.println("Debug file is empty, please check file content!\n");
            return "0.0.0.0";
        }
        for (String line : srcList) {
            String[] para = line.split(",");
            if (!para[0].equals(((Builder)this.commandArgs).bmcIP)) continue;
            dataLANIP = para[1];
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Get data lan IP from debug:" + dataLANIP);
            break;
        }
        return dataLANIP;
    }

    private boolean mountMiniOS() {
        return this.mountMiniOSVertive();
    }

    private boolean unmountMiniOS() {
        return this.unmountMiniOSVertive();
    }

    private boolean mountMiniOSVertive() {
        boolean result = false;
        this.localReceiver.changeFilePermission("tools/vmcliUtility/*", COMMAND_NAME, this.commandID);
        VmcliMountInfo vmcliMountInfo = new VmcliMountInfo();
        vmcliMountInfo.setBmcIP(((Builder)this.commandArgs).bmcIP);
        vmcliMountInfo.setBmcUsername(((Builder)this.commandArgs).bmcUsername);
        vmcliMountInfo.setBmcPassword(((Builder)this.commandArgs).bmcPassword);
        vmcliMountInfo.setCdROM(((Builder)this.commandArgs).miniOSISOName);
        result = this.localReceiver.vmcliMount(vmcliMountInfo, COMMAND_NAME, this.commandID);
        return result;
    }

    private boolean unmountMiniOSVertive() {
        boolean unmount = false;
        int counter = 0;
        while (!(unmount = this.localReceiver.vmcliUnmount(((Builder)this.commandArgs).bmcIP, COMMAND_NAME, this.commandID))) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                break;
            }
            if (!unmount && ++counter < 10) continue;
        }
        return unmount;
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private String bmcIP;
        private String bmcUsername = "admin";
        private String bmcPassword = "password";
        private String miniOSISOName;
        private String stressItem;
        private File debugFile = null;
        private int stressMin;
        private boolean isAMI = false;
        private boolean isUEFI = false;

        @Override
        public boolean checkArgs() {
            if (this.args != null) {
                for (int i = 0; i < this.args.length; ++i) {
                    if (i == 0) {
                        switch (this.stressItem = this.args[i]) {
                            case "ptu": {
                                this.stressItem = "PTU";
                                break;
                            }
                            case "linpack": {
                                this.stressItem = "Linpack";
                                break;
                            }
                            case "kill": {
                                this.stressItem = "kill";
                                break;
                            }
                            case "update": {
                                this.stressItem = "update";
                                break;
                            }
                            default: {
                                return false;
                            }
                        }
                    } else if (i == 1) {
                        this.miniOSISOName = this.args[1];
                    } else if (i == 2) {
                        try {
                            this.stressMin = Integer.parseInt(this.args[2]);
                        }
                        catch (Exception e) {
                            return false;
                        }
                    }
                    if (this.args[i].contains("debug=")) {
                        this.debugFile = new File(this.args[i].substring(this.args[i].lastIndexOf("debug=") + 6));
                        if (this.debugFile.exists()) continue;
                        System.out.println("Debug file is not exist!");
                        return false;
                    }
                    if (!this.args[i].contains("uefi=")) continue;
                    String uefi = this.args[i].substring(this.args[i].lastIndexOf("uefi=") + 5);
                    this.isUEFI = uefi.equalsIgnoreCase("true");
                }
                return true;
            }
            return false;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public DiagCommand build() {
            return new DiagCommand(this);
        }

        public Builder setBMCIP(String bmcIP) {
            this.bmcIP = bmcIP;
            return this.getThis();
        }

        public Builder setBMCUsername(String username) {
            this.bmcUsername = username;
            return this.getThis();
        }

        public Builder setBMCPassword(String password) {
            this.bmcPassword = password;
            return this.getThis();
        }

        public Builder setOSImage(String osISOName) {
            this.miniOSISOName = osISOName;
            return this.getThis();
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.bmcIP = null;
            this.bmcUsername = null;
            this.bmcPassword = null;
            this.miniOSISOName = null;
            this.stressItem = null;
            this.loggerWriter.close();
        }
    }
}

