/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.fwlist;

import Gbt.core.commands.AbstractCommand;
import Gbt.core.commands.AbstractCommandBuilder;
import Gbt.core.commands.GbtCommandBuilders;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.receivers.GbtIPMICommandReceiver;
import Gbt.core.receivers.RESTClientReceiver;
import Gbt.core.rest.RESTException;
import Gbt.core.rest.RESTHttpMethods;
import Gbt.core.rest.RESTRequest;
import Gbt.utility.CPLD.CPLDJsonData;
import Gbt.utility.CPLD.CPLDListJsonData;
import Gbt.utility.CPLD.CpldIpmiOptions;
import Gbt.utility.CPLD.GetCPLDCommand;
import Gbt.utility.SMBIOS.SmbiosType0;
import Gbt.utility.SMBIOS.SmbiosTypeBase;
import Gbt.utility.bmcinfo.BMCInfoJSONData;
import Gbt.utility.bmcinfo.BmcDeviceIpmiOptions;
import Gbt.utility.bmcinfo.GetBMCInfoCommand;
import Gbt.utility.menu.GbtUtility;
import Gbt.utility.rest.models.AMIRestSessionData;
import Gbt.utility.rest.requests.SMBIOSRequest;
import Gbt.utility.rest.requests.SessionRequest;
import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import java.io.File;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;

public class FwListCommand
extends AbstractCommand<Builder> {
    public static final String COMMAND_NAME = "fwlist";
    private GbtIPMICommandReceiver ipmiReceiver;
    private RESTClientReceiver restReceiver;

    protected FwListCommand(Builder commandArgs) {
        super(commandArgs);
        this.commandID = ((Builder)this.commandArgs).bmcIP + "_" + COMMAND_NAME;
        this.ipmiReceiver = GbtIPMICommandReceiver.getInstance();
        this.restReceiver = RESTClientReceiver.getInstance();
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String getDocumentsName() {
        return COMMAND_NAME;
    }

    @Override
    public boolean checkAll() {
        if (!((Builder)this.commandArgs).checkArgs()) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Command arguments check fail.");
            return false;
        }
        if (this.ipmiReceiver == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI receiver is null.");
            return false;
        }
        return true;
    }

    @Override
    public boolean execute() {
        ConnectionHandle handle = this.ipmiReceiver.createIPMIConnection(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, COMMAND_NAME, this.commandID);
        if (handle == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] IPMI connection fail.");
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Execution elapsed time : " + this.getElapsedTimes());
            return false;
        }
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Start to get FW info.");
        BMCInfoJSONData bmcInfo = this.getBMCVersion(handle);
        SmbiosType0 type0 = this.getSMBIOS();
        CPLDListJsonData cpldInfo = this.getCPLDVersion(handle);
        this.ipmiReceiver.closeIPMIConnection(handle, COMMAND_NAME, this.commandID);
        if (bmcInfo == null && type0 == null && cpldInfo == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Get FW command fail.");
            return false;
        }
        this.commandResults.add(bmcInfo);
        this.commandResults.add(type0);
        this.commandResults.add(cpldInfo);
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] BMC Version    : " + (bmcInfo == null ? "NA" : bmcInfo.getFirmwareRevision()));
        this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] BIOS Version   : " + (type0 == null ? "NA" : type0.getBIOSVersion()));
        int i = 1;
        if (cpldInfo != null) {
            for (CPLDJsonData cpld : cpldInfo.getCpldVersionList()) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] CPLD " + i + " Version : " + cpld.getUserCode());
                ++i;
            }
            if (cpldInfo.getEcVersionData() != null) {
                this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] EC Version : " + cpldInfo.getEcVersionData().getEcVersion());
            }
        } else {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.INFO, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] CPLD Version   : NA");
        }
        return true;
    }

    @Override
    public void cancelHook(Object obj) {
    }

    @Override
    public void close() throws Exception {
    }

    private BMCInfoJSONData getBMCVersion(ConnectionHandle handle) {
        GetBMCInfoCommand.Builder mcBuilder = GbtCommandBuilders.mcinfo(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword);
        AbstractJSONPOJO data = this.ipmiReceiver.sendIPMIRawCommand(handle, BmcDeviceIpmiOptions.GETDEVICEID, mcBuilder, COMMAND_NAME, this.commandID);
        if (data instanceof NullJSONData) {
            NullJSONData temp = data.castConcreteJSON(NullJSONData.class);
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
            return null;
        }
        BMCInfoJSONData bmcInfo = data.castConcreteJSON(BMCInfoJSONData.class);
        return bmcInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SmbiosType0 getSMBIOS() {
        Response response;
        RESTRequest request;
        SmbiosType0 result = null;
        File dumpFile = new File(GbtUtility.getResultsRootPath() + "/" + COMMAND_NAME + "/" + ((Builder)this.commandArgs).bmcIP + "_SMBIOS.bin");
        Client client = this.restReceiver.createHttpsClient(((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword, COMMAND_NAME, this.commandID, false);
        if (client == null) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] SSL context initialize fail.");
            return null;
        }
        AMIRestSessionData sessionData = null;
        try {
            request = ((SessionRequest.Builder)((SessionRequest.Builder)((SessionRequest.Builder)((SessionRequest.Builder)((SessionRequest.Builder)new SessionRequest.Builder().setHttpMethods(RESTHttpMethods.POST)).setHostname(((Builder)this.commandArgs).bmcIP)).setContentType("application/x-www-form-urlencoded")).setFormData("username", ((Builder)this.commandArgs).bmcUsername)).setFormData("password", ((Builder)this.commandArgs).bmcPassword)).build();
            response = this.restReceiver.syncInvoke(client, request, COMMAND_NAME, this.commandID);
            sessionData = this.restReceiver.deserialize(response, new GenericType<AMIRestSessionData>(){});
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Open session success.");
        }
        catch (RESTException re) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Open session fail.", re);
            client.close();
            return null;
        }
        try {
            request = ((SMBIOSRequest.Builder)((SMBIOSRequest.Builder)((SMBIOSRequest.Builder)((SMBIOSRequest.Builder)new SMBIOSRequest.Builder().setHostname(((Builder)this.commandArgs).bmcIP)).setHttpMethods(RESTHttpMethods.GET)).setContentType("application/json")).setCookies(sessionData)).setDownloadFileNmae(dumpFile).build();
            response = this.restReceiver.syncInvoke(client, request, COMMAND_NAME, this.commandID);
            List<SmbiosTypeBase> smbiosList = this.restReceiver.downloadSmbios(response, dumpFile);
            for (SmbiosTypeBase smbiosData : smbiosList) {
                if (!(smbiosData instanceof SmbiosType0)) continue;
                result = (SmbiosType0)smbiosData;
            }
        }
        catch (RESTException re) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Get SMBIOS info fail, " + re.getMessage());
            client.close();
            return result;
        }
        try {
            request = ((SessionRequest.Builder)((SessionRequest.Builder)((SessionRequest.Builder)((SessionRequest.Builder)new SessionRequest.Builder().setHttpMethods(RESTHttpMethods.DELETE)).setHostname(((Builder)this.commandArgs).bmcIP)).setContentType("application/x-www-form-urlencoded")).setCookies(sessionData)).build();
            response = this.restReceiver.syncInvoke(client, request, COMMAND_NAME, this.commandID);
            sessionData = this.restReceiver.deserialize(response, new GenericType<AMIRestSessionData>(){});
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.DEBUG, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Close session success.");
        }
        catch (RESTException re) {
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] Close session fail.", re);
            SmbiosType0 smbiosType0 = result;
            return smbiosType0;
        }
        finally {
            if (client != null) {
                sessionData = null;
                client.close();
            }
            return result;
        }
    }

    private CPLDListJsonData getCPLDVersion(ConnectionHandle handle) {
        GetCPLDCommand.Builder cpldBuilder = GbtCommandBuilders.getCPLD(((Builder)this.commandArgs).bmcIP, ((Builder)this.commandArgs).bmcUsername, ((Builder)this.commandArgs).bmcPassword);
        AbstractJSONPOJO data = this.ipmiReceiver.sendIPMIRawCommand(handle, CpldIpmiOptions.OEM, cpldBuilder, COMMAND_NAME, this.commandID);
        if (data instanceof NullJSONData) {
            NullJSONData temp = data.castConcreteJSON(NullJSONData.class);
            this.loggerWriter.appendPath(COMMAND_NAME).writeLogs(GbtLogLevel.ERROR, this.commandID, "[" + ((Builder)this.commandArgs).bmcIP + "] " + temp.getMessages());
            return null;
        }
        CPLDListJsonData cpldInfo = data.castConcreteJSON(CPLDListJsonData.class);
        return cpldInfo;
    }

    public static final class Builder
    extends AbstractCommandBuilder<Builder> {
        private String bmcIP;
        private String bmcUsername = "admin";
        private String bmcPassword = "password";

        @Override
        public boolean checkArgs() {
            if (this.bmcIP == null) {
                return false;
            }
            return this.args.length <= 0;
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public FwListCommand build() {
            return new FwListCommand(this);
        }

        @Override
        public void close() throws Exception {
            this.args = null;
            this.bmcIP = null;
            this.bmcUsername = null;
            this.bmcPassword = null;
            this.loggerWriter.close();
        }

        public Builder setBMCIP(String bmcIP) {
            this.bmcIP = bmcIP;
            return this.getThis();
        }

        public Builder setBMCUsername(String username) {
            this.bmcUsername = username;
            return this.getThis();
        }

        public Builder setBMCPassword(String password) {
            this.bmcPassword = password;
            return this.getThis();
        }
    }
}

