/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.power;

import Gbt.core.ipmi.GbtIPMIOptions;
import Gbt.core.ipmi.GbtIpmiCommandResponseData;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.utility.Common.GbtCommonConverters;
import Gbt.utility.power.PowerLimitCommand;
import Gbt.utility.power.PowerLimitExceptionActions;
import Gbt.utility.power.PowerLimitInfo;
import Gbt.utility.power.PowerReadingInfo;
import com.veraxsystems.vxipmi.coding.payload.CompletionCode;
import java.nio.ByteBuffer;

public enum PowerIpmiOptions implements GbtIPMIOptions<PowerLimitCommand.Builder>
{
    UNKNOWN(0, "unknown", 0),
    READ(2, "read", 2),
    GET(3, "get", 3),
    SET(4, "set", 4),
    ACTIVATE(5, "activate", 5),
    DEACTIVATE(6, "deactivate", 5);

    private static final String UNKNOWN_ITEM = "unknown";
    private static final String READ_ITEM = "read";
    private static final String GET_ITEM = "get";
    private static final String SET_ITEM = "set";
    private static final String ACTIVATE_ITEM = "activate";
    private static final String DEACTIVATE_ITEM = "deactivate";
    private final int optionCode;
    private final String item;
    private static final byte NET_FN = 44;
    private final byte commandCode;

    private PowerIpmiOptions(int optionCode, String item, byte commandCode) {
        this.optionCode = optionCode;
        this.item = item;
        this.commandCode = commandCode;
    }

    @Override
    public int getOptionCode() {
        return this.optionCode;
    }

    @Override
    public String getItem() {
        return this.item;
    }

    @Override
    public byte getNetFn() {
        return 44;
    }

    @Override
    public byte getCommandCode() {
        return this.commandCode;
    }

    @Override
    public byte[] rebuildRequestData(PowerLimitCommand.Builder commandArgs) {
        switch (this) {
            case READ: {
                return new byte[]{-36, 1, 0, 0};
            }
            case GET: {
                return new byte[]{-36, 0, 0};
            }
            case SET: {
                byte action = commandArgs.powerLimitInfo.getPowerLimitExceptionActions().getCode();
                byte[] limitNum = GbtCommonConverters.encodePowerLimitRequestData(commandArgs.powerLimitInfo.getPowerLimit().intValue());
                byte[] correctTime = ByteBuffer.allocate(4).putInt(commandArgs.powerLimitInfo.getCorrectionTime().intValue()).array();
                byte[] samplingPeriod = ByteBuffer.allocate(4).putInt(commandArgs.powerLimitInfo.getSamplingPeriod().intValue()).array();
                return new byte[]{-36, 0, 0, 0, action, limitNum[0], limitNum[1], correctTime[3], correctTime[2], correctTime[1], correctTime[0], 0, 0, samplingPeriod[3], samplingPeriod[2]};
            }
            case ACTIVATE: {
                return new byte[]{-36, 1, 0, 0};
            }
            case DEACTIVATE: {
                return new byte[]{-36, 0, 0, 0};
            }
        }
        return null;
    }

    @Override
    public AbstractJSONPOJO parserResponseData(GbtIpmiCommandResponseData gbtResponseData) {
        byte[] buffer2 = new byte[2];
        byte[] buffer4 = new byte[4];
        switch (this) {
            case READ: {
                PowerReadingInfo powerReadingInfo = new PowerReadingInfo();
                System.arraycopy(gbtResponseData.getAllResponseData(), 1, buffer2, 0, buffer2.length);
                powerReadingInfo.setCurrentPower(GbtCommonConverters.ipmiBytesToBigDecimal(buffer2));
                System.arraycopy(gbtResponseData.getAllResponseData(), 3, buffer2, 0, buffer2.length);
                powerReadingInfo.setMinimumPower(GbtCommonConverters.ipmiBytesToBigDecimal(buffer2));
                System.arraycopy(gbtResponseData.getAllResponseData(), 5, buffer2, 0, buffer2.length);
                powerReadingInfo.setMaximumPower(GbtCommonConverters.ipmiBytesToBigDecimal(buffer2));
                System.arraycopy(gbtResponseData.getAllResponseData(), 7, buffer2, 0, buffer2.length);
                powerReadingInfo.setAveragePower(GbtCommonConverters.ipmiBytesToBigDecimal(buffer2));
                System.arraycopy(gbtResponseData.getAllResponseData(), 9, buffer4, 0, buffer4.length);
                powerReadingInfo.setTimestamp(GbtCommonConverters.ipmiBytesToJavaDate(buffer4));
                System.arraycopy(gbtResponseData.getAllResponseData(), 13, buffer4, 0, buffer4.length);
                powerReadingInfo.setSamplingPeriod(GbtCommonConverters.ipmiBytesToBigDecimal(buffer4));
                powerReadingInfo.setActivate((gbtResponseData.getResponseData(gbtResponseData.getAllResponseData().length - 1) & 0x40) != 0);
                return powerReadingInfo;
            }
            case GET: {
                if (gbtResponseData.getAllResponseData().length < 14) {
                    return new NullJSONData().setMessages("No valid power limit settings.").setError(false);
                }
                PowerLimitInfo powerLimitInfo = new PowerLimitInfo();
                powerLimitInfo.setActivate(gbtResponseData.getCompletionCode() == CompletionCode.Ok);
                powerLimitInfo.setPowerLimitExceptionActions(PowerLimitExceptionActions.parse(gbtResponseData.getResponseData(3)));
                byte[] powerLimit = new byte[2];
                System.arraycopy(gbtResponseData.getAllResponseData(), 4, powerLimit, 0, powerLimit.length);
                powerLimitInfo.setPowerLimit(GbtCommonConverters.ipmiBytesToBigDecimal(powerLimit));
                byte[] correctionTime = new byte[4];
                System.arraycopy(gbtResponseData.getAllResponseData(), 6, correctionTime, 0, correctionTime.length);
                powerLimitInfo.setCorrectionTime(GbtCommonConverters.ipmiBytesToBigDecimal(correctionTime));
                byte[] samplingPeriod = new byte[2];
                System.arraycopy(gbtResponseData.getAllResponseData(), 12, samplingPeriod, 0, samplingPeriod.length);
                powerLimitInfo.setSamplingPeriod(GbtCommonConverters.ipmiBytesToBigDecimal(samplingPeriod));
                return powerLimitInfo;
            }
            case SET: {
                return new NullJSONData().setMessages(this.getItem() + " power limit success.").setError(false);
            }
            case ACTIVATE: {
                return new NullJSONData().setMessages(this.getItem() + " power limit success.").setError(false);
            }
            case DEACTIVATE: {
                return new NullJSONData().setMessages(this.getItem() + " power limit success.").setError(false);
            }
        }
        return new NullJSONData().setMessages("Unknown options.").setError(true);
    }

    public static final PowerIpmiOptions parse(String item) {
        switch (item.toLowerCase()) {
            case "get": {
                return GET;
            }
            case "set": {
                return SET;
            }
            case "activate": {
                return ACTIVATE;
            }
            case "deactivate": {
                return DEACTIVATE;
            }
        }
        return UNKNOWN;
    }
}

