/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.redfish.options;

import Gbt.core.redfish.RedfishApiOptions;

public enum ManagersApiOptions implements RedfishApiOptions
{
    UNKNOWN("unknown", "/redfish/v1/Managers"),
    INFO("info", "/redfish/v1/Managers"),
    TIMESET("timeset", "/redfish/v1/Managers"),
    RESET("reset", "/redfish/v1/Managers/<id>/Actions/Manager.Reset"),
    FRESET("freset", "/redfish/v1/Managers/<id>/Actions/Manager.FactoryReset");

    private static final String MANAGERS_URI = "/redfish/v1/Managers";
    private static final String RESET_ACTION_URI = "/redfish/v1/Managers/<id>/Actions/Manager.Reset";
    private static final String FRESET_ACTION_URI = "/redfish/v1/Managers/<id>/Actions/Manager.FactoryReset";
    private static final String UNKNOWN_ITEM = "unknown";
    private static final String INFO_ITEM = "info";
    private static final String TIMESET_ITEM = "timeset";
    private static final String RESET_ITEM = "reset";
    private static final String FRESET_ITEM = "freset";
    private final String optionName;
    private final String mainUri;

    private ManagersApiOptions(String optionName, String mainUri) {
        this.optionName = optionName;
        this.mainUri = mainUri;
    }

    @Override
    public String getOptionName() {
        return this.optionName;
    }

    @Override
    public String getMainUri() {
        return this.mainUri;
    }

    public static final ManagersApiOptions parse(String rawOptionName) {
        switch (rawOptionName.toLowerCase()) {
            case "info": {
                return INFO;
            }
            case "timeset": {
                return TIMESET;
            }
            case "reset": {
                return RESET;
            }
            case "freset": {
                return FRESET;
            }
        }
        return UNKNOWN;
    }

    @Override
    public String getPayLoadErrorMessages() {
        switch (this) {
            case TIMESET: {
                return "The manager time set data is not assigned or invalid.";
            }
            case RESET: {
                return "The manager reset data is not assigned or invalid.";
            }
            case FRESET: {
                return "The manager factory reset data is not assigned or invalid.";
            }
        }
        return "Unsupport option of event service API.";
    }
}

