/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.redfish.options;

import Gbt.core.redfish.RedfishApiOptions;

public enum SecureBootApiOptions implements RedfishApiOptions
{
    UNKNOWN("/redfish/v1/Systems/<id>/SecureBoot/"),
    INFO("/redfish/v1/Systems/<id>/SecureBoot/"),
    ACTIONINFO("/redfish/v1/Systems/<id>/SecureBoot/ResetKeysActionInfo"),
    ENABLE("/redfish/v1/Systems/<id>/SecureBoot/"),
    DISABLE("/redfish/v1/Systems/<id>/SecureBoot/"),
    RESETKEY("/redfish/v1/Systems/<id>/SecureBoot/Actions/SecureBoot.ResetKeys");

    private static final String SECUREBOOT_URI = "/redfish/v1/Systems/<id>/SecureBoot/";
    private static final String SECUREBOOT_RESETKEY_URI = "/redfish/v1/Systems/<id>/SecureBoot/Actions/SecureBoot.ResetKeys";
    private static final String SECUREBOOT_ACTIONINFO_URI = "/redfish/v1/Systems/<id>/SecureBoot/ResetKeysActionInfo";
    private final String mainUri;

    private SecureBootApiOptions(String mainUri) {
        this.mainUri = mainUri;
    }

    @Override
    public String getOptionName() {
        return super.toString().toLowerCase();
    }

    @Override
    public String getMainUri() {
        return this.mainUri;
    }

    @Override
    public String getPayLoadErrorMessages() {
        switch (this) {
            default: 
        }
        return "Unsupport option of the Redfish secure boot service API.";
    }

    public String replaceSystemId(String systemID) {
        return this.getMainUri().replace("<id>", systemID);
    }

    public static final SecureBootApiOptions parse(String rawString) {
        if (rawString == null) {
            return UNKNOWN;
        }
        try {
            return SecureBootApiOptions.valueOf(rawString.toUpperCase());
        }
        catch (IllegalArgumentException iae) {
            return UNKNOWN;
        }
    }
}

