/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.redfish.services;

import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.redfish.RedfishApiPayload;
import Gbt.core.redfish.RedfishApiService;
import Gbt.core.redfish.RedfishResourceTypes;
import Gbt.core.rest.RESTException;
import Gbt.core.rest.RESTHttpMethods;
import Gbt.core.rest.RESTRequest;
import Gbt.core.rest.RESTRequestImpl;
import Gbt.utility.Common.GbtCommonConverters;
import Gbt.utility.redfish.RestFullResponseData;
import Gbt.utility.redfish.factories.RedfishApiMenu;
import Gbt.utility.redfish.models.common.bios.BiosChangePasswordAction;
import Gbt.utility.redfish.models.common.bios.BiosResetAction;
import Gbt.utility.redfish.models.common.bios.BiosResetTypes;
import Gbt.utility.redfish.options.BiosApiOptions;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Response;

public class BiosApi
extends RedfishApiService<Payload> {
    protected BiosApi(Payload servicePayload) {
        super(servicePayload);
    }

    @Override
    public String getServiceName() {
        return RedfishApiMenu.BIOS.getApiName();
    }

    @Override
    protected boolean checkRawArgs() {
        if (((Payload)this.servicePayload).getRestRawArgs().length == 0) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] The input arguments not enough.");
            return false;
        }
        ((Payload)this.servicePayload).setServiceOption(BiosApiOptions.parse(((Payload)this.servicePayload).getRestRawArgs()[0]));
        switch ((BiosApiOptions)((Payload)this.servicePayload).getServiceOption()) {
            case INFO: {
                if (((Payload)this.servicePayload).getRestRawArgs().length == 2) {
                    ((Payload)this.servicePayload).setSystemId(((Payload)this.servicePayload).getRestRawArgs()[1]);
                }
                return true;
            }
            case RESET: {
                BiosResetAction biosResetAction = new BiosResetAction();
                switch (((Payload)this.servicePayload).getRestRawArgs().length) {
                    case 2: {
                        ((Payload)this.servicePayload).setBiosResetType(BiosResetTypes.parse(((Payload)this.servicePayload).getRestRawArgs()[1]));
                        biosResetAction.setResetType(((Payload)this.servicePayload).getBiosResetType());
                        if (biosResetAction.getResetType() == BiosResetTypes.Unknown) {
                            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((BiosApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                            return false;
                        }
                        return this.uploadDataValidation(RedfishResourceTypes.Ignore, biosResetAction);
                    }
                    case 3: {
                        ((Payload)this.servicePayload).setSystemId(((Payload)this.servicePayload).getRestRawArgs()[1]);
                        ((Payload)this.servicePayload).setBiosResetType(BiosResetTypes.parse(((Payload)this.servicePayload).getRestRawArgs()[2]));
                        biosResetAction.setResetType(((Payload)this.servicePayload).getBiosResetType());
                        if (biosResetAction.getResetType() == BiosResetTypes.Unknown) {
                            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((BiosApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                            return false;
                        }
                        return this.uploadDataValidation(RedfishResourceTypes.Ignore, biosResetAction);
                    }
                }
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((BiosApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                return false;
            }
            case PASSWORD: {
                switch (((Payload)this.servicePayload).getRestRawArgs().length) {
                    case 2: {
                        ((Payload)this.servicePayload).setUploadJsonFile(GbtCommonConverters.stringToJavaIoFile(((Payload)this.servicePayload).getRestRawArgs()[1]));
                        return this.uploadFileValidation(RedfishResourceTypes.Ignore);
                    }
                    case 3: {
                        ((Payload)this.servicePayload).setSystemId(((Payload)this.servicePayload).getRestRawArgs()[1]);
                        ((Payload)this.servicePayload).setUploadJsonFile(GbtCommonConverters.stringToJavaIoFile(((Payload)this.servicePayload).getRestRawArgs()[2]));
                        return this.uploadFileValidation(RedfishResourceTypes.Ignore);
                    }
                }
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((BiosApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                return false;
            }
            case SD: {
                if (((Payload)this.servicePayload).getRestRawArgs().length < 2) {
                    return false;
                }
                switch (((Payload)this.servicePayload).getRestRawArgs()[1]) {
                    case "get": {
                        if (((Payload)this.servicePayload).getRestRawArgs().length == 3) {
                            ((Payload)this.servicePayload).setSystemId(((Payload)this.servicePayload).getRestRawArgs()[2]);
                        }
                        return true;
                    }
                    case "post": {
                        switch (((Payload)this.servicePayload).getRestRawArgs().length) {
                            case 3: {
                                ((Payload)this.servicePayload).setUploadJsonFile(GbtCommonConverters.stringToJavaIoFile(((Payload)this.servicePayload).getRestRawArgs()[2]));
                                return this.uploadFileValidation(RedfishResourceTypes.Ignore);
                            }
                            case 4: {
                                ((Payload)this.servicePayload).setSystemId(((Payload)this.servicePayload).getRestRawArgs()[2]);
                                ((Payload)this.servicePayload).setUploadJsonFile(GbtCommonConverters.stringToJavaIoFile(((Payload)this.servicePayload).getRestRawArgs()[3]));
                                return this.uploadFileValidation(RedfishResourceTypes.Ignore);
                            }
                        }
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((BiosApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                        return false;
                    }
                }
                for (String para : ((Payload)this.servicePayload).getRestRawArgs()) {
                    if (!para.equalsIgnoreCase("if-none-match")) continue;
                    ((Payload)this.servicePayload).setIfnonematch(true);
                }
                break;
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((BiosApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
        return false;
    }

    @Override
    protected boolean checkPayLoad() {
        switch ((BiosApiOptions)((Payload)this.servicePayload).getServiceOption()) {
            case INFO: {
                return true;
            }
            case RESET: {
                if (((Payload)this.servicePayload).getBiosResetType() == BiosResetTypes.Unknown) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((BiosApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                    return false;
                }
                BiosResetAction biosResetAction = new BiosResetAction();
                biosResetAction.setResetType(((Payload)this.servicePayload).getBiosResetType());
                return this.uploadDataValidation(RedfishResourceTypes.Ignore, biosResetAction);
            }
            case PASSWORD: {
                if (((Payload)this.servicePayload).getChangePassowrd() == null) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((BiosApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                    return false;
                }
                return this.uploadDataValidation(RedfishResourceTypes.ChangePassword, ((Payload)this.servicePayload).getChangePassowrd());
            }
            case SD: {
                if (((Payload)this.servicePayload).getUploadJsonFile() != null) {
                    return this.uploadFileValidation(RedfishResourceTypes.Ignore);
                }
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((BiosApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
                return false;
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((BiosApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() {
        Client client = null;
        try {
            client = this.restReceiver.createHttpsClient(((Payload)this.servicePayload).getUsername(), ((Payload)this.servicePayload).getPassword(), ((Payload)this.servicePayload).isDebug());
        }
        catch (RESTException re) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, "[" + ((Payload)this.servicePayload).getIpAddress() + "] Create HTTPS client fail.");
            return false;
        }
        if (((Payload)this.servicePayload).getSystemId() == null) {
            ((Payload)this.servicePayload).setSystemId("Self");
        }
        switch ((BiosApiOptions)((Payload)this.servicePayload).getServiceOption()) {
            case INFO: {
                try {
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.GET)).setContentType("application/json")).setServiceURI(((BiosApiOptions)((Payload)this.servicePayload).getServiceOption()).replaceSystemId(((Payload)this.servicePayload).getSystemId())).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    this.responseData.add(desResp);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(desResp.isRedfishErrorResponse() ? GbtLogLevel.ERROR : GbtLogLevel.INFO, this.serviceLogsId, desResp.toString());
                    boolean bl = !desResp.isRedfishErrorResponse();
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean response = false;
                    return response;
                }
                finally {
                    if (client != null) {
                        client.close();
                    }
                }
            }
            case RESET: {
                try {
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.POST)).setContentType("application/json")).setRawJsonData(this.requestBody)).setServiceURI(((BiosApiOptions)((Payload)this.servicePayload).getServiceOption()).replaceSystemId(((Payload)this.servicePayload).getSystemId())).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    this.responseData.add(desResp);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(desResp.isRedfishErrorResponse() ? GbtLogLevel.ERROR : GbtLogLevel.INFO, this.serviceLogsId, desResp.toString());
                    boolean bl = !desResp.isRedfishErrorResponse();
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean response = false;
                    return response;
                }
                finally {
                    if (client != null) {
                        client.close();
                    }
                }
            }
            case PASSWORD: {
                try {
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.POST)).setContentType("application/json")).setRawJsonData(this.requestBody)).setServiceURI(((BiosApiOptions)((Payload)this.servicePayload).getServiceOption()).replaceSystemId(((Payload)this.servicePayload).getSystemId())).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    this.responseData.add(desResp);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(desResp.isRedfishErrorResponse() ? GbtLogLevel.ERROR : GbtLogLevel.INFO, this.serviceLogsId, desResp.toString());
                    boolean bl = !desResp.isRedfishErrorResponse();
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean response = false;
                    return response;
                }
                finally {
                    if (client != null) {
                        client.close();
                    }
                }
            }
            case SD: {
                try {
                    if (this.requestBody == null) {
                        RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHttpMethods(RESTHttpMethods.GET)).setContentType("application/json")).setServiceURI(((BiosApiOptions)((Payload)this.servicePayload).getServiceOption()).replaceSystemId(((Payload)this.servicePayload).getSystemId())).build();
                        Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                        RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                        this.responseData.add(desResp);
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(desResp.isRedfishErrorResponse() ? GbtLogLevel.ERROR : GbtLogLevel.INFO, this.serviceLogsId, desResp.toString());
                        boolean bl = !desResp.isRedfishErrorResponse();
                        return bl;
                    }
                    if (!((Payload)this.servicePayload).getIfnonematch()) {
                        String etag = this.getETag(((Payload)this.servicePayload).getProtocolHeader(), client, ((BiosApiOptions)((Payload)this.servicePayload).getServiceOption()).replaceSystemId(((Payload)this.servicePayload).getSystemId()));
                        if (etag == null) {
                            ((BiosApiOptions)((Payload)((Payload)this.servicePayload).setServiceOption(BiosApiOptions.INFO)).getServiceOption()).replaceSystemId(((Payload)this.servicePayload).getSystemId());
                            etag = this.getETag(((Payload)this.servicePayload).getProtocolHeader(), client, ((BiosApiOptions)((Payload)this.servicePayload).getServiceOption()).replaceSystemId(((Payload)this.servicePayload).getSystemId()));
                            ((Payload)this.servicePayload).setServiceOption(BiosApiOptions.SD);
                        }
                        RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHeaders("If-Match", etag)).setHttpMethods(RESTHttpMethods.POST)).setContentType("application/json")).setRawJsonData(this.requestBody)).setServiceURI(((BiosApiOptions)((Payload)this.servicePayload).getServiceOption()).replaceSystemId(((Payload)this.servicePayload).getSystemId())).build();
                        Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                        RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                        this.responseData.add(desResp);
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(desResp.isRedfishErrorResponse() ? GbtLogLevel.ERROR : GbtLogLevel.INFO, this.serviceLogsId, desResp.toString());
                        boolean bl = !desResp.isRedfishErrorResponse();
                        return bl;
                    }
                    RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHostname(((Payload)this.servicePayload).getIpAddress())).setProtocolHeader(((Payload)this.servicePayload).getProtocolHeader())).setPort(((Payload)this.servicePayload).getPort())).setHeaders("If-None-Match", "test")).setHttpMethods(RESTHttpMethods.POST)).setContentType("application/json")).setRawJsonData(this.requestBody)).setServiceURI(((BiosApiOptions)((Payload)this.servicePayload).getServiceOption()).replaceSystemId(((Payload)this.servicePayload).getSystemId())).build();
                    Response response = this.restReceiver.syncInvoke(client, request, this.logDirPath, this.serviceLogsId);
                    RestFullResponseData desResp = this.restReceiver.deserializeAsCommonData(response);
                    this.responseData.add(desResp);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(desResp.isRedfishErrorResponse() ? GbtLogLevel.ERROR : GbtLogLevel.INFO, this.serviceLogsId, desResp.toString());
                    boolean bl = !desResp.isRedfishErrorResponse();
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getMessage());
                    if (re.getUnexpectedBody() != null) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, re.getUnexpectedBody());
                    }
                    boolean bl = false;
                    return bl;
                }
                finally {
                    if (client != null) {
                        client.close();
                    }
                }
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, this.serviceLogsId, ((BiosApiOptions)((Payload)this.servicePayload).getServiceOption()).getPayLoadErrorMessages());
        if (client != null) {
            client.close();
        }
        return false;
    }

    public static final class Payload
    extends RedfishApiPayload<Payload, BiosApiOptions> {
        private String systemId;
        private BiosResetTypes biosResetType;
        private boolean ifnonematch;
        private BiosChangePasswordAction changePassowrd;

        public Payload(String ipAddress, AbstractLoggerWriter loggerWriter) {
            super(ipAddress, loggerWriter);
            this.setServiceOption(BiosApiOptions.UNKNOWN);
            this.setBiosResetType(BiosResetTypes.Unknown);
            this.ifnonematch = true;
        }

        public Payload(String ipAddress, String username, String password, AbstractLoggerWriter loggerWriter) {
            super(ipAddress, username, password, loggerWriter);
            this.setServiceOption(BiosApiOptions.UNKNOWN);
            this.setBiosResetType(BiosResetTypes.Unknown);
            this.ifnonematch = true;
        }

        @Override
        protected Payload getThis() {
            return this;
        }

        public BiosApi build() {
            return new BiosApi(this);
        }

        public String getSystemId() {
            return this.systemId;
        }

        public Payload setSystemId(String systemId) {
            this.systemId = systemId;
            return this.getThis();
        }

        public BiosChangePasswordAction getChangePassowrd() {
            return this.changePassowrd;
        }

        public Payload setChangePassowrd(BiosChangePasswordAction changePassowrd) {
            this.changePassowrd = changePassowrd;
            return this.getThis();
        }

        public BiosResetTypes getBiosResetType() {
            return this.biosResetType;
        }

        public Payload setBiosResetType(BiosResetTypes biosResetType) {
            this.biosResetType = biosResetType;
            return this.getThis();
        }

        public boolean getIfnonematch() {
            return this.ifnonematch;
        }

        public Payload setIfnonematch(boolean ifnonematch) {
            this.ifnonematch = ifnonematch;
            return this.getThis();
        }
    }
}

