/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.rest.services;

import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.JacksonCommonUtil;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.rest.RESTException;
import Gbt.core.rest.RESTHttpMethods;
import Gbt.core.rest.RESTRequest;
import Gbt.core.rest.RESTRequestImpl;
import Gbt.core.rest.RESTServices;
import Gbt.core.rest.RESTServicesOptions;
import Gbt.utility.rest.models.ldap.AMIRestLDAPGroup;
import Gbt.utility.rest.options.LDAPGroupServiceOptions;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;

public final class LDAPGroupService
extends RESTServices {
    public static final String SERVICE_NAME = "ldapgroup";
    private static final String LDAP_GROUP_SETTINGS_URI = "/api/settings/ldap-users";
    private AMIRestLDAPGroup uploadData;

    public LDAPGroupService(AbstractLoggerWriter loggerWriter) {
        super(loggerWriter);
    }

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }

    @Override
    public boolean readJsonData(AbstractJSONPOJO jsonData, RESTServicesOptions restServicesOptions) {
        return true;
    }

    @Override
    public boolean readJsonFiles(List<File> dataFiles, RESTServicesOptions options) {
        switch (options.getOptionName()) {
            case "put": {
                try {
                    this.uploadData = (AMIRestLDAPGroup)JacksonCommonUtil.getUtil().readJSONFile(dataFiles.get(0), options.getRequestPayloadType());
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
            case "delete": {
                try {
                    this.uploadData = (AMIRestLDAPGroup)JacksonCommonUtil.getUtil().readJSONFile(dataFiles.get(0), options.getRequestPayloadType());
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean uploadFiles(List<File> uploadFiles, RESTServicesOptions restServicesOptions) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String ipAddress, RESTServicesOptions options) {
        String logName = ipAddress + "_" + this.logDirPath + "_" + this.getServiceName();
        if (!(options instanceof LDAPGroupServiceOptions)) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Unknown option of " + this.getServiceName() + " service.");
            this.jsonResults.add(new NullJSONData().setError(true).setMessages("Unknown option of " + this.getServiceName() + " service."));
            return false;
        }
        RESTRequestImpl request = null;
        Response response = null;
        switch ((LDAPGroupServiceOptions)options) {
            case GET_LDAP_GROUP: {
                request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHttpMethods(RESTHttpMethods.GET)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(LDAP_GROUP_SETTINGS_URI).setCookies(this.sessionData)).setContentType("application/json")).build();
                try {
                    response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                    this.jsonResults.addAll((Collection)this.clientReceiver.deserialize(response, new GenericType<List<AMIRestLDAPGroup>>(){}));
                    JsonNode resultNode = this.clientReceiver.deserializeAsJsonNode(response);
                    this.acceptJsonResults(resultNode, AMIRestLDAPGroup.class, ipAddress, logName);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Get LDAP group data success.");
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, this.getJsonResultsPrettyPrintString());
                    boolean bl = true;
                    return bl;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Get LDAP group data fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Get LDAP group data fail."));
                    boolean bl = false;
                    return bl;
                }
                finally {
                    response.close();
                }
            }
            case SET_LDAP_GROUP: {
                request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHttpMethods(RESTHttpMethods.PUT)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(LDAP_GROUP_SETTINGS_URI).setServiceId(this.uploadData.getId().intValue()).setCookies(this.sessionData)).setRawJsonData(this.uploadData)).setContentType("application/json")).build();
                try {
                    response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                    this.uploadData = this.clientReceiver.deserialize(response, new GenericType<AMIRestLDAPGroup>(){});
                    this.jsonResults.add(this.uploadData);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Set LDAP group data success.");
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, this.uploadData.toString());
                    boolean re = true;
                    return re;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Set LDAP group data fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Set LDAP group data fail."));
                    boolean bl = false;
                    return bl;
                }
                finally {
                    response.close();
                }
            }
            case DELETE_LDAP_GROUP: {
                request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setHttpMethods(RESTHttpMethods.DELETE)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(LDAP_GROUP_SETTINGS_URI).setServiceId(this.uploadData.getId().intValue()).setCookies(this.sessionData)).setRawJsonData(this.uploadData)).setContentType("application/json")).build();
                try {
                    response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Delete LDAP group data success.");
                    boolean re = true;
                    return re;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Delete LDAP group data fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Set LDAP group data fail."));
                    boolean bl = false;
                    return bl;
                }
                finally {
                    response.close();
                }
            }
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Unknown option of " + this.getServiceName() + " service.");
        this.jsonResults.add(new NullJSONData().setError(true).setMessages("Unknown option of " + this.getServiceName() + " service."));
        return false;
    }
}

