/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.rest.services;

import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.JacksonCommonUtil;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.rest.RESTException;
import Gbt.core.rest.RESTHttpMethods;
import Gbt.core.rest.RESTProtocolHeaders;
import Gbt.core.rest.RESTRequest;
import Gbt.core.rest.RESTRequestImpl;
import Gbt.core.rest.RESTServices;
import Gbt.core.rest.RESTServicesOptions;
import Gbt.utility.Update.fwInfo.BIOSUpdateFWInfo;
import Gbt.utility.Update.fwInfo.BMCUpdateFWInfo;
import Gbt.utility.Update.fwInfo.CommonUpdateFWInfo;
import Gbt.utility.bmcinfo.BMCVendor;
import Gbt.utility.rest.models.OpenBmcRestSessionData;
import Gbt.utility.rest.models.update.OpenBmcActivateFirmwareData;
import Gbt.utility.rest.models.update.OpenBmcUploadResult;
import Gbt.utility.rest.models.update.RestOpenBmcLoginData;
import Gbt.utility.rest.options.UpdateServiceOptions;
import Gbt.utility.rest.requests.OpenBmcLoginRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;

public class OpenBmcUpdateService
extends RESTServices {
    public static final String SERVICE_NAME = "openbmcupdate";
    private static final int MAX_RETRY_COUNT = 50;
    private static final int MAX_UPDATE_PROGRESS_TIMEOUT = 20;
    private static final String UPLOAD_FW_URI = "/upload/image";
    private static final String ACIVATE_FW_URI = "/xyz/openbmc_project/software/<code>/attr/RequestedActivation";
    private static final String ACTIVATION_STATUS_URI = "/xyz/openbmc_project/software/<code>/attr/Activation";
    private static final String REBOOT_BMC_URI = "/xyz/openbmc_project/state/bmc0/attr/RequestedBMCTransition";
    private static final String FW_INFO_URI = "/xyz/openbmc_project/software/enumerate";
    private CommonUpdateFWInfo updateFWInfo;
    private int waitActivateTimes;
    private boolean rebootBMC = false;
    private BMCVendor vendor = BMCVendor.OPENBMC;
    private static final int WAIT_BMC_ACTIVATE_TIMES = 5;
    private static final int WAIT_BIOS_ACTIVATE_TIMES = 60;
    private Client clientForLongTimeResp;
    private int connectionTimeout = -1;
    private int readTimeout = -1;
    private static final int DEFAULT_READ_TIMEOUT = 300000;
    private static final int DEFAULT_CONNECTION_TIMEOUT = 20000;

    public OpenBmcUpdateService(AbstractLoggerWriter loggerWriter) {
        super(loggerWriter);
    }

    public OpenBmcUpdateService(AbstractLoggerWriter loggerWriter, int connectionTimeout, int readTimeout) {
        super(loggerWriter);
        this.connectionTimeout = connectionTimeout;
        this.readTimeout = readTimeout;
    }

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }

    @Override
    public boolean readJsonData(AbstractJSONPOJO jsonData, RESTServicesOptions restServicesOptions) {
        if (!(restServicesOptions instanceof UpdateServiceOptions)) {
            return false;
        }
        UpdateServiceOptions options = (UpdateServiceOptions)restServicesOptions;
        switch (options) {
            case BMC: {
                if (!(jsonData instanceof BMCUpdateFWInfo)) {
                    return false;
                }
                this.updateFWInfo = jsonData.castConcreteJSON(BMCUpdateFWInfo.class);
                this.waitActivateTimes = 5;
                this.rebootBMC = true;
                return true;
            }
            case BIOS: {
                if (!(jsonData instanceof BIOSUpdateFWInfo)) {
                    return false;
                }
                this.updateFWInfo = jsonData.castConcreteJSON(BIOSUpdateFWInfo.class);
                this.waitActivateTimes = 60;
                this.rebootBMC = false;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean readJsonFiles(List<File> dataFiles, RESTServicesOptions restServicesOptions) {
        return true;
    }

    @Override
    public boolean uploadFiles(List<File> uploadFiles, RESTServicesOptions restServicesOptions) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String ipAddress, RESTServicesOptions restServicesOptions) {
        String logName = ipAddress + "_" + this.getServiceName();
        Response response = null;
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Upload file path: " + this.updateFWInfo.getImagePath());
        File uploadFile = new File(this.updateFWInfo.getImagePath());
        FileInputStream uploadFileStream = null;
        try {
            uploadFileStream = new FileInputStream(uploadFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Start upload FW image (RT=" + this.clientForLongTimeResp.getConfiguration().getProperty("jersey.config.client.readTimeout") + ", CT=" + this.clientForLongTimeResp.getConfiguration().getProperty("jersey.config.client.connectTimeout") + ").");
        RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setProtocolHeader(RESTProtocolHeaders.HTTPS)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(UPLOAD_FW_URI).setHttpMethods(RESTHttpMethods.POST)).setUploadFileName(uploadFile.getName())).setInputStream(uploadFileStream)).setCookies(this.sessionData)).setContentType("application/octet-stream")).build();
        Future<Response> responseFuture = this.clientReceiver.asyncInvoke(this.clientForLongTimeResp, request, this.logDirPath, logName);
        while (!responseFuture.isDone() && !responseFuture.isCancelled()) {
            try {
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Wait for uploading FW image......");
                Thread.sleep(4000L);
            }
            catch (InterruptedException ie) {
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.WARN, logName, "[" + ipAddress + "] Interrupt upload image firmware.");
                this.jsonResults.add(new NullJSONData().setError(true).setMessages("Interrupt upload image firmware."));
                boolean bl = false;
                return bl;
            }
            finally {
                if (response == null) continue;
                response.close();
            }
        }
        OpenBmcUploadResult uploadResult = null;
        try {
            response = responseFuture.get();
            uploadResult = this.clientReceiver.deserialize(response, OpenBmcUploadResult.class);
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] " + JacksonCommonUtil.getUtil().getPrettyPrintString(uploadResult));
            if (uploadResult.getStatus().equalsIgnoreCase("ok")) {
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Upload firmware success.");
            } else {
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Upload firmware fail.");
            }
            Thread.sleep(3000L);
        }
        catch (InterruptedException | CancellationException ie) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.WARN, logName, "[" + ipAddress + "] Upload firmware interrupted, " + ie.getMessage());
            boolean bl = false;
            return bl;
        }
        catch (ExecutionException ee) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Upload firmware fail, " + ee.getMessage());
            boolean bl = false;
            return bl;
        }
        catch (RESTException e) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Upload firmware fail, " + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        try {
            if (uploadFileStream != null) {
                ((InputStream)uploadFileStream).close();
            }
        }
        catch (Exception e) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Close file stream fail, " + e.getMessage());
            return false;
        }
        String activateUri = ACIVATE_FW_URI.replaceAll("<code>", uploadResult.getData());
        request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setProtocolHeader(RESTProtocolHeaders.HTTPS)).setHttpMethods(RESTHttpMethods.PUT)).setServiceURI(activateUri).setHostname(ipAddress)).setPort(this.bmcPort)).setCookies(this.sessionData)).setContentType("application/json")).setRawJsonData(new OpenBmcActivateFirmwareData().setData("xyz.openbmc_project.Software.Activation.RequestedActivations.Active"))).build();
        try {
            response = this.clientReceiver.syncInvoke(this.clientForLongTimeResp, request, this.logDirPath, logName);
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Send activate firmware success. (RT=" + this.clientForLongTimeResp.getConfiguration().getProperty("jersey.config.client.readTimeout") + ", CT=" + this.clientForLongTimeResp.getConfiguration().getProperty("jersey.config.client.connectTimeout") + ").");
            Thread.sleep(1000L);
        }
        catch (RESTException re) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Send activate firmware fail. ", re);
            this.restExceptionMessages(re, ipAddress, logName);
            boolean bl = false;
            return bl;
        }
        catch (InterruptedException ie) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Send activate firmware fail. ", ie);
            boolean bl = false;
            return bl;
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
        if (this.updateFWInfo.getBmcVendor().isInsyde()) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Skip getting activate status.");
            return true;
        }
        boolean updateProgress = this.waitFirmwareActivate(ipAddress, uploadResult, logName);
        if (this.rebootBMC) {
            request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setProtocolHeader(RESTProtocolHeaders.HTTPS)).setHttpMethods(RESTHttpMethods.PUT)).setServiceURI(REBOOT_BMC_URI).setHostname(ipAddress)).setPort(this.bmcPort)).setCookies(this.sessionData)).setContentType("application/json")).setRawJsonData(new OpenBmcActivateFirmwareData().setData("xyz.openbmc_project.State.BMC.Transition.Reboot"))).build();
            try {
                response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Reboot BMC command success.");
                Thread.sleep(2000L);
            }
            catch (RESTException re) {
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Reboot BMC command fail. ", re);
                this.restExceptionMessages(re, ipAddress, logName);
                boolean bl = false;
                return bl;
            }
            catch (InterruptedException ie) {
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Reboot BMC command fail. ", ie);
                boolean bl = false;
                return bl;
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
        }
        return updateProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean openSession(String ipAddress, String username, String password, boolean debug) {
        String logName = ipAddress + "_" + this.getServiceName();
        this.username = username;
        this.password = password;
        this.client = this.clientReceiver.createHttpsClient(username, password, this.logDirPath, logName, 20000, 300000, debug);
        this.clientForLongTimeResp = this.clientReceiver.createHttpsClient(username, password, this.logDirPath, logName, this.connectionTimeout > 0 ? this.connectionTimeout : 20000, this.readTimeout > 0 ? this.readTimeout : 300000, debug);
        if (this.client == null) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "SSL context initialize fail.");
            return false;
        }
        if (this.clientForLongTimeResp == null) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "SSL context initialize fail.");
            return false;
        }
        OpenBmcLoginRequest request = ((OpenBmcLoginRequest.Builder)((OpenBmcLoginRequest.Builder)((OpenBmcLoginRequest.Builder)((OpenBmcLoginRequest.Builder)((OpenBmcLoginRequest.Builder)new OpenBmcLoginRequest.Builder().setHttpMethods(RESTHttpMethods.POST)).setHostname(ipAddress)).setPort(this.bmcPort)).setContentType("application/json")).setRawJsonData(new RestOpenBmcLoginData().setData(new String[]{username, password}))).build();
        try (Response response = null;){
            response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
            this.sessionData = this.clientReceiver.deserialize(response, new GenericType<OpenBmcRestSessionData>(){});
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Login success.");
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.TRACE, logName, this.sessionData.toString());
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitFirmwareActivate(String ipAddress, OpenBmcUploadResult uploadResult, String logName) {
        String activationStatusUri = ACTIVATION_STATUS_URI.replaceAll("<code>", uploadResult.getData());
        RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setProtocolHeader(RESTProtocolHeaders.HTTPS)).setHttpMethods(RESTHttpMethods.GET)).setServiceURI(activationStatusUri).setHostname(ipAddress)).setPort(this.bmcPort)).setCookies(this.sessionData)).setContentType("application/json")).build();
        int retry = 0;
        boolean updateProgress = true;
        Response response = null;
        while (true) {
            try {
                Thread.sleep(6000L);
                response = this.clientReceiver.syncInvoke(this.clientForLongTimeResp, request, this.logDirPath, logName);
                OpenBmcUploadResult activationResult = this.clientReceiver.deserialize(response, OpenBmcUploadResult.class);
                if (activationResult.getData().toLowerCase().contains("activations.active")) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Activate firmware success.(RT=" + this.clientForLongTimeResp.getConfiguration().getProperty("jersey.config.client.readTimeout") + ", CT=" + this.clientForLongTimeResp.getConfiguration().getProperty("jersey.config.client.connectTimeout") + ").");
                    Thread.sleep(2000L);
                    break;
                }
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Activation status: " + activationResult.getData());
                if (++retry <= this.waitActivateTimes) continue;
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Wait activation status timeout!");
                updateProgress = false;
            }
            catch (RESTException re) {
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Get activation status fail, waiting for next time.", re);
                this.restExceptionMessages(re, ipAddress, logName);
                ++retry;
                continue;
            }
            catch (InterruptedException ie) {
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Get activation status fail.", ie);
                boolean bl = false;
                return bl;
            }
            finally {
                if (response == null) continue;
                response.close();
                continue;
            }
            break;
        }
        return updateProgress;
    }
}

