/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.rest.services;

import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.JacksonCommonUtil;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.core.loggers.AbstractLoggerWriter;
import Gbt.core.loggers.GbtLogLevel;
import Gbt.core.rest.RESTException;
import Gbt.core.rest.RESTHttpMethods;
import Gbt.core.rest.RESTProtocolHeaders;
import Gbt.core.rest.RESTRequest;
import Gbt.core.rest.RESTRequestImpl;
import Gbt.core.rest.RESTServices;
import Gbt.core.rest.RESTServicesOptions;
import Gbt.utility.Update.DualImageConfig;
import Gbt.utility.Update.UpdateType;
import Gbt.utility.Update.fwInfo.BIOSUpdateFWInfo;
import Gbt.utility.Update.fwInfo.BMCUpdateFWInfo;
import Gbt.utility.Update.fwInfo.CPLDUpdateFWInfo;
import Gbt.utility.Update.fwInfo.CommonUpdateFWInfo;
import Gbt.utility.Update.fwInfo.FpgaUpdateFWInfo;
import Gbt.utility.Update.fwInfo.PSUUpdateFWInfo;
import Gbt.utility.Update.fwInfo.SKUUpdateFWInfo;
import Gbt.utility.firmwareBackup.CommandSupportStatus;
import Gbt.utility.rest.models.AMIRestSessionData;
import Gbt.utility.rest.models.common.RestErrorData;
import Gbt.utility.rest.models.update.RestDualImageConfig;
import Gbt.utility.rest.models.update.RestUpdateFlashConfig;
import Gbt.utility.rest.models.update.RestUpdateProgressData;
import Gbt.utility.rest.models.update.RestUpdateVerificationResults;
import Gbt.utility.rest.options.UpdateServiceOptions;
import Gbt.utility.rest.requests.SessionRequest;
import java.io.File;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;

public final class UpdateService
extends RESTServices {
    public static final String SERVICE_NAME = "update";
    private static final int MAX_RETRY_COUNT = 50;
    private static final int MAX_UPDATE_PROGRESS_TIMEOUT = 20;
    private static final int DEFAULT_READ_TIMEOUT = 300000;
    private static final int DEFAULT_CONNECTION_TIMEOUT = 20000;
    private static final String UPDATE_FLASH_URI = "/api/maintenance/flash";
    private static final String UPLOAD_FW_URI = "/api/maintenance/firmware";
    private static final String UPLOAD_HPM_FW_URI = "/api/maintenance/hpm/bmcfw/raw";
    private static final String VERIFY_FW_URI = "/api/maintenance/firmware/verification";
    private static final String UPGRADE_FW_URI = "/api/maintenance/firmware/upgrade";
    private static final String FLASH_PROGRESS_URI = "/api/maintenance/firmware/flash-progress";
    private static final String MAINTENANCE_RESET_URI = "/api/maintenance/reset";
    private static final String DUALIMAGE_CONFIG_URI = "/api/maintenance/dualflashimageconfig";
    private static final String KEEP_ALIVE_URI = "/api/maintenance/fwupdate_keepalived";
    private static final String UPD_IMG_KEY = "fwimage";
    private static final String VERIFY_KEY = "flash_type";
    private static final String[] PROGRESS_COMPLETE_TAGS = new String[]{"100%", "Complete"};
    private CommonUpdateFWInfo updateFWInfo;
    private Client clientForLongTimeResp;
    private int connectionTimeout = -1;
    private int readTimeout = -1;

    public UpdateService(AbstractLoggerWriter loggerWriter) {
        super(loggerWriter);
    }

    public UpdateService(AbstractLoggerWriter loggerWriter, int connectionTimeout, int readTimeout) {
        super(loggerWriter);
        this.connectionTimeout = connectionTimeout;
        this.readTimeout = readTimeout;
    }

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }

    @Override
    public boolean readJsonData(AbstractJSONPOJO jsonData, RESTServicesOptions restServicesOptions) {
        if (!(restServicesOptions instanceof UpdateServiceOptions)) {
            return false;
        }
        UpdateServiceOptions options = (UpdateServiceOptions)restServicesOptions;
        switch (options) {
            case BMC: {
                if (!(jsonData instanceof BMCUpdateFWInfo)) {
                    return false;
                }
                this.updateFWInfo = jsonData.castConcreteJSON(BMCUpdateFWInfo.class);
                return true;
            }
            case BIOS: {
                if (!(jsonData instanceof BIOSUpdateFWInfo)) {
                    return false;
                }
                this.updateFWInfo = jsonData.castConcreteJSON(BIOSUpdateFWInfo.class);
                return true;
            }
            case CPLDBPB: {
                if (!(jsonData instanceof CPLDUpdateFWInfo)) {
                    return false;
                }
                this.updateFWInfo = jsonData.castConcreteJSON(CPLDUpdateFWInfo.class);
                return true;
            }
            case CPLDMB: {
                if (!(jsonData instanceof CPLDUpdateFWInfo)) {
                    return false;
                }
                this.updateFWInfo = jsonData.castConcreteJSON(CPLDUpdateFWInfo.class);
                return true;
            }
            case PSU: {
                if (!(jsonData instanceof PSUUpdateFWInfo)) {
                    return false;
                }
                this.updateFWInfo = jsonData.castConcreteJSON(PSUUpdateFWInfo.class);
                return true;
            }
            case SKU: {
                if (!(jsonData instanceof SKUUpdateFWInfo)) {
                    return false;
                }
                this.updateFWInfo = jsonData.castConcreteJSON(SKUUpdateFWInfo.class);
                return true;
            }
            case FPGA: {
                if (!(jsonData instanceof FpgaUpdateFWInfo)) {
                    return false;
                }
                this.updateFWInfo = jsonData.castConcreteJSON(FpgaUpdateFWInfo.class);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean readJsonFiles(List<File> dataFiles, RESTServicesOptions restServicesOptions) {
        return true;
    }

    @Override
    public boolean uploadFiles(List<File> uploadFiles, RESTServicesOptions restServicesOptions) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public boolean execute(String ipAddress, RESTServicesOptions restServicesOptions) {
        block72: {
            logName = ipAddress + "_" + this.getServiceName() + "_" + restServicesOptions.getOptionName();
            response = null;
            retry = 0;
            if (this.updateFWInfo.getDualImageConfig() != null && this.updateFWInfo.getDualImageConfig() != DualImageConfig.UNKNOWN) {
                while (retry < 50) {
                    if (this.setDualImageConfig(ipAddress, logName)) {
                        retry = 0;
                        break;
                    }
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, "[" + ipAddress + "] Waiting for retry setting dual image configuration...");
                    if (++retry < 50) continue;
                    return false;
                }
            }
            while (retry < 50) {
                try {
                    result = this.switchToFlashMode(ipAddress, logName);
                    if (result == 0) {
                        retry = 0;
                        break;
                    }
                    if (result == 1) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, "[" + ipAddress + "] End update process.");
                        return true;
                    }
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, "[" + ipAddress + "] Waiting for retry switch to flash mode ...");
                }
                catch (InterruptedException ie) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, "[" + ipAddress + "] " + ie.getMessage());
                    return false;
                }
                if (++retry < 50) continue;
                return false;
            }
            if (this.updateFWInfo.getBackupFlag() != null && this.updateFWInfo.getBackupFlag().intValue() == 1 && this.updateFWInfo.getUpdateType() == UpdateType.BMC) {
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Skip upload FW and verify FW when updating 2nd BMC SPI.");
            } else {
                this.keepUpdateProgressAlive(ipAddress, logName);
                uploadUri = "";
                uploadUri = this.updateFWInfo.isHpmUpdate() != null && this.updateFWInfo.isHpmUpdate() != false ? "/api/maintenance/hpm/bmcfw/raw" : "/api/maintenance/firmware";
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Start upload FW image (RT=" + this.clientForLongTimeResp.getConfiguration().getProperty("jersey.config.client.readTimeout") + ", CT=" + this.clientForLongTimeResp.getConfiguration().getProperty("jersey.config.client.connectTimeout") + ").");
                request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setProtocolHeader(RESTProtocolHeaders.HTTPS)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(uploadUri).setHttpMethods(RESTHttpMethods.POST)).setFormData("fwimage", new File(this.updateFWInfo.getImagePath()))).setCookies(this.sessionData)).setContentType("multipart/form-data")).build();
                responseFuture = this.clientReceiver.asyncInvoke(this.clientForLongTimeResp, request, this.logDirPath, logName);
                retry = 0;
                while (!responseFuture.isDone() && !responseFuture.isCancelled()) {
                    try {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Wait for uploading FW image......");
                        Thread.sleep(4000L);
                        if (retry % 3 != 0) continue;
                        this.keepUpdateProgressAlive(ipAddress, logName);
                    }
                    catch (InterruptedException ie) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.WARN, logName, "[" + ipAddress + "] Interrupt upload image firmware.");
                        this.jsonResults.add(new NullJSONData().setError(true).setMessages("Interrupt upload image firmware."));
                        var10_26 = false;
                        return var10_26;
                    }
                    finally {
                        ++retry;
                        if (response == null) continue;
                        response.close();
                    }
                }
                try {
                    response = responseFuture.get();
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Upload firmware success.");
                    Thread.sleep(3000L);
                }
                catch (InterruptedException | CancellationException ie) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.WARN, logName, "[" + ipAddress + "] Upload firmware interrupted, " + ie.getMessage());
                    var10_27 = false;
                    return var10_27;
                }
                catch (ExecutionException ee) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Upload firmware fail, " + ee.getMessage());
                    var10_28 = false;
                    return var10_28;
                }
                finally {
                    if (response != null) {
                        response.close();
                    }
                }
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Start verify FW image (RT=" + this.clientForLongTimeResp.getConfiguration().getProperty("jersey.config.client.readTimeout") + ", CT=" + this.clientForLongTimeResp.getConfiguration().getProperty("jersey.config.client.connectTimeout") + ").");
                request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setProtocolHeader(RESTProtocolHeaders.HTTPS)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI("/api/maintenance/firmware/verification").setHttpMethods(RESTHttpMethods.GET)).setQueryPair("flash_type", this.updateFWInfo.getUpdateType().toString())).setCookies(this.sessionData)).setContentType("application/json")).build();
                responseFuture = this.clientReceiver.asyncInvoke(this.clientForLongTimeResp, request, this.logDirPath, logName);
                retry = 0;
                while (!responseFuture.isDone() && !responseFuture.isCancelled()) {
                    try {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Wait for verifying FW image......");
                        Thread.sleep(4000L);
                    }
                    catch (InterruptedException ie) {
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.WARN, logName, "[" + ipAddress + "] Interrupt upload image firmware.");
                        this.jsonResults.add(new NullJSONData().setError(true).setMessages("Interrupt verify image firmware."));
                        var10_29 = false;
                        return var10_29;
                    }
                    finally {
                        if (response == null) continue;
                        response.close();
                    }
                }
                try {
                    response = responseFuture.get();
                    data = this.clientReceiver.deserialize(response, new GenericType<List<RestUpdateVerificationResults>>(){});
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, JacksonCommonUtil.getUtil().getPrettyPrintString(data));
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Upload firmware verification success.");
                    this.jsonResults.addAll(data);
                    Thread.sleep(2000L);
                }
                catch (InterruptedException | CancellationException ie) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.WARN, logName, "[" + ipAddress + "] Upload firmware verification interrupted, " + ie.getMessage());
                    var10_30 = false;
                    return var10_30;
                }
                catch (RESTException | ExecutionException ee) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Upload firmware verification fail, " + ee.getMessage());
                    var10_31 = false;
                    return var10_31;
                }
                finally {
                    if (response != null) {
                        response.close();
                    }
                }
            }
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Start to upgrade FW image.");
            flashConfig = new RestUpdateFlashConfig();
            flashConfig.setFlashType(this.updateFWInfo.getUpdateType().toString());
            flashConfig.setPreserveConfig(this.updateFWInfo.isPreserve() != false ? 1 : 0).setFlashStatus(this.updateFWInfo.getUpdateType().isCPLD() != false || this.updateFWInfo.getUpdateType().isFPGA() != false ? 0 : 1);
            if (this.updateFWInfo.getBackupFlag() != null) {
                flashConfig.setBackupFlag(this.updateFWInfo.getBackupFlag().intValue());
            }
            request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setProtocolHeader(RESTProtocolHeaders.HTTPS)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI("/api/maintenance/firmware/upgrade").setHttpMethods(RESTHttpMethods.PUT)).setRawJsonData(flashConfig)).setCookies(this.sessionData)).setContentType("application/json")).build();
            try {
                response = this.clientReceiver.syncInvoke(this.clientForLongTimeResp, request, this.logDirPath, logName);
                data = this.clientReceiver.deserialize(response, RestUpdateFlashConfig.class);
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, data.toString());
                this.jsonResults.add(data);
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Firmware upgrade has started.");
                Thread.sleep(2000L);
                ** if (response == null) goto lbl-1000
            }
            catch (RESTException re) {
                block74: {
                    block67: {
                        block70: {
                            block68: {
                                block69: {
                                    data = JacksonCommonUtil.getUtil().readJsonStrings(re.getUnexpectedBody(), RestErrorData.class);
                                    if (data.getCode() != 1307) break block67;
                                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Action is not support.");
                                    this.jsonResults.add(new CommandSupportStatus().setSupport(false).setSuccess(false));
                                    if (!this.resetBMCByMaintenance(ipAddress, logName)) break block68;
                                    var10_32 = true;
                                    if (response == null) break block69;
                                    response.close();
                                }
                                return var10_32;
                            }
                            var10_33 = false;
                            if (response == null) break block70;
                            response.close();
                        }
                        return var10_33;
                    }
                    break block74;
                    {
                        catch (Exception e) {
                            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Parse unexpected body fail, " + e.getMessage());
                        }
                    }
                }
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Keep checking progress...");
            }
            catch (InterruptedException ie) {
                block71: {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.WARN, logName, "[" + ipAddress + "] Interrupt FW update process.");
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Interrupt FW update process."));
                    e = false;
                    if (response == null) break block71;
                    {
                        catch (Throwable var15_39) {
                            throw var15_39;
                        }
                    }
                    response.close();
                }
                return e;
            }
lbl-1000:
            // 1 sources

            {
                response.close();
            }
lbl-1000:
            // 2 sources

            {
            }
            {
                finally {
                    if (response != null) {
                        response.close();
                    }
                }
            }
            updateProgress = true;
            retry = 0;
            request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setProtocolHeader(RESTProtocolHeaders.HTTPS)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI("/api/maintenance/firmware/flash-progress").setHttpMethods(RESTHttpMethods.GET)).setCookies(this.sessionData)).setContentType("application/json")).build();
            while (true) {
                try {
                    Thread.sleep(3000L);
                    response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
                    progressData = this.clientReceiver.deserialize(response, RestUpdateProgressData.class);
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] " + progressData.getAction() + ", progress : " + progressData.getProgress());
                    if (progressData.getProgress().contains(UpdateService.PROGRESS_COMPLETE_TAGS[0]) || progressData.getProgress().contains(UpdateService.PROGRESS_COMPLETE_TAGS[1])) {
                        Thread.sleep(3000L);
                        if (this.updateFWInfo.getDualImageConfig() == null || this.updateFWInfo.getDualImageConfig() == DualImageConfig.UNKNOWN) break block72;
                        if (progressData.getState() == 2) {
                            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Get the dual image update complete message.");
                            break block72;
                        }
                        this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Wait for the second time complete message...");
                        continue;
                    }
                    retry = !progressData.getAction().contains("Flashing") ? ++retry : 0;
                }
                catch (RESTException re) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Get progress fail.");
                    this.restExceptionMessages(re, ipAddress, logName);
                    ++retry;
                }
                catch (InterruptedException ie) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.WARN, logName, "[" + ipAddress + "] Interrupt get upgrade progress.");
                    this.jsonResults.add(new NullJSONData().setError(true).setMessages("Interrupt get upgrade progress."));
                    var10_34 = false;
                    return var10_34;
                }
                finally {
                    if (response == null) continue;
                    response.close();
                    continue;
                }
                if (retry >= 50) {
                    this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Update progress over retry times!!");
                    updateProgress = false;
                    break block72;
                }
                if (this.isOverTime(20)) break;
            }
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "[" + ipAddress + "] Update progress timeout!");
            updateProgress = false;
        }
        return updateProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean openSession(String ipAddress, String username, String password, boolean debug) {
        String logName = ipAddress + "_" + this.getServiceName() + "_" + this.updateFWInfo.getUpdateType().toString();
        this.username = username;
        this.password = password;
        this.client = this.clientReceiver.createHttpsClient(username, password, this.logDirPath, logName, debug);
        this.clientForLongTimeResp = this.clientReceiver.createHttpsClient(username, password, this.logDirPath, logName, this.connectionTimeout > 0 ? this.connectionTimeout : 20000, this.readTimeout > 0 ? this.readTimeout : 300000, debug);
        if (this.client == null) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "SSL context initialize fail.");
            return false;
        }
        if (this.clientForLongTimeResp == null) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.ERROR, logName, "SSL context initialize fail.");
            return false;
        }
        SessionRequest request = ((SessionRequest.Builder)((SessionRequest.Builder)((SessionRequest.Builder)((SessionRequest.Builder)((SessionRequest.Builder)((SessionRequest.Builder)new SessionRequest.Builder().setHttpMethods(RESTHttpMethods.POST)).setHostname(ipAddress)).setPort(this.bmcPort)).setContentType("application/x-www-form-urlencoded")).setFormData("username", username)).setFormData("password", password)).build();
        try (Response response = null;){
            response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
            this.sessionData = this.clientReceiver.deserialize(response, new GenericType<AMIRestSessionData>(){});
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Open session success.");
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.TRACE, logName, this.sessionData.toString());
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean closeSession(String ipAddress) {
        String logName = ipAddress + "_" + this.getServiceName() + "_" + this.updateFWInfo.getUpdateType().toString();
        SessionRequest request = ((SessionRequest.Builder)((SessionRequest.Builder)((SessionRequest.Builder)((SessionRequest.Builder)((SessionRequest.Builder)new SessionRequest.Builder().setHttpMethods(RESTHttpMethods.DELETE)).setHostname(ipAddress)).setPort(this.bmcPort)).setContentType("application/x-www-form-urlencoded")).setCookies(this.sessionData)).build();
        Response response = null;
        try {
            response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
            this.sessionData = this.clientReceiver.deserialize(response, new GenericType<AMIRestSessionData>(){});
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Close session success.");
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.TRACE, logName, this.sessionData.toString());
            boolean bl = true;
            return bl;
        }
        catch (RESTException re) {
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.TRACE, logName, "[" + ipAddress + "] Close session fail.");
            boolean bl = false;
            return bl;
        }
        finally {
            if (response != null) {
                response.close();
            }
            if (this.client != null) {
                this.sessionData = null;
                this.client.close();
            }
            if (this.clientForLongTimeResp != null) {
                this.clientForLongTimeResp.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setDualImageConfig(String ipAddress, String logName) {
        RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setProtocolHeader(RESTProtocolHeaders.HTTPS)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(DUALIMAGE_CONFIG_URI).setHttpMethods(RESTHttpMethods.PUT)).setRawJsonData(new RestDualImageConfig().setImageUpdate(this.updateFWInfo.getDualImageConfig().getCode()))).setCookies(this.sessionData)).setContentType("application/json")).build();
        try (Response response = null;){
            response = this.clientReceiver.syncInvoke(this.clientForLongTimeResp, request, this.logDirPath, logName);
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Set dual image configuration complete.");
            Thread.sleep(2000L);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int switchToFlashMode(String ipAddress, String logName) throws InterruptedException {
        RestUpdateFlashConfig flashConfig = new RestUpdateFlashConfig();
        flashConfig.setFlashType(this.updateFWInfo.getUpdateType().toString());
        if (this.updateFWInfo.getBackupFlag() != null) {
            flashConfig.setBackupFlag(this.updateFWInfo.getBackupFlag().intValue());
        }
        RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setProtocolHeader(RESTProtocolHeaders.HTTPS)).setHostname(ipAddress)).setPort(this.bmcPort)).setServiceURI(UPDATE_FLASH_URI).setHttpMethods(RESTHttpMethods.PUT)).setRawJsonData(flashConfig)).setCookies(this.sessionData)).setContentType("application/json")).build();
        Future<Response> responseFuture = this.clientReceiver.asyncInvoke(this.clientForLongTimeResp, request, this.logDirPath, logName);
        while (!responseFuture.isDone() && !responseFuture.isCancelled()) {
            try {
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Wait for switching to flash mode.......");
                Thread.sleep(6000L);
            }
            catch (InterruptedException ie) {
                this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.WARN, logName, "[" + ipAddress + "] Interrupt flash chip.");
                this.jsonResults.add(new NullJSONData().setError(true).setMessages("Interrupt flash chip."));
                throw ie;
            }
        }
        try (Response response = null;){
            response = responseFuture.get();
            RestUpdateFlashConfig data = this.clientReceiver.deserialize(response, RestUpdateFlashConfig.class);
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.INFO, logName, data.toString());
            this.jsonResults.add(data);
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Flash chip success.");
            Thread.sleep(2000L);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean resetBMCByMaintenance(String ipAddress, String logName) {
        RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setProtocolHeader(RESTProtocolHeaders.HTTPS)).setHttpMethods(RESTHttpMethods.POST)).setServiceURI(MAINTENANCE_RESET_URI).setHostname(ipAddress)).setPort(this.bmcPort)).setRawJsonData("{}")).setCookies(this.sessionData)).setContentType("application/json")).build();
        try (Response response = null;){
            response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Reset BMC success.");
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Please waiting 300 sec for BMC reinitialize complete.");
            Thread.sleep(2000L);
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean keepUpdateProgressAlive(String ipAddress, String logName) {
        RESTRequestImpl request = ((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)((RESTRequestImpl.Builder)RESTRequest.create().setProtocolHeader(RESTProtocolHeaders.HTTPS)).setHttpMethods(RESTHttpMethods.GET)).setServiceURI(KEEP_ALIVE_URI).setHostname(ipAddress)).setPort(this.bmcPort)).setCookies(this.sessionData)).setContentType("application/json")).build();
        try (Response response = null;){
            response = this.clientReceiver.syncInvoke(this.client, request, this.logDirPath, logName);
            this.loggerWriter.appendPath(this.logDirPath).writeLogs(GbtLogLevel.DEBUG, logName, "[" + ipAddress + "] Keep update progress alive success.");
            Thread.sleep(2000L);
            boolean bl = true;
            return bl;
        }
    }
}

