/*
 * Decompiled with CFR 0.152.
 */
package Gbt.utility.solconfig;

import Gbt.core.ipmi.GbtIPMIOptions;
import Gbt.core.ipmi.GbtIpmiCommandResponseData;
import Gbt.core.jsonapi.AbstractJSONPOJO;
import Gbt.core.jsonapi.NullJSONData;
import Gbt.utility.bmclanconfig.BMCLanProgressStates;
import Gbt.utility.solconfig.SolConfigCommand;
import Gbt.utility.solconfig.SolConfigData;
import Gbt.utility.solconfig.SolVolatileBitRates;
import com.veraxsystems.vxipmi.coding.commands.PrivilegeLevel;
import java.math.BigDecimal;
import java.math.RoundingMode;

public enum SolConfigIpmiOptions implements GbtIPMIOptions<SolConfigCommand.Builder>
{
    SET_LAN_PROGRESS(0, "Set Lan Progress States", 33),
    GET_LAN_PROGRESS(0, "Get Lan Progress States", 34),
    SET_ENABLE(1, "Set Enable", 33),
    GET_ENABLE(1, "Get Enable", 34),
    SET_AUTHENTICATION(2, "Set SOL Authentication", 33),
    GET_AUTHENTICATION(2, "Get SOL Authentication", 34),
    SET_CHARACTER_CONFIG(3, "Set Character Accumulate Interval & Character Send Threshold.", 33),
    GET_CHARACTER_CONFIG(3, "Get Character Accumulate Interval & Character Send Threshold.", 34),
    SET_RETRY(4, "Set Retry", 33),
    GET_RETRY(4, "Get Retry", 34),
    SET_NON_VOLATILE_BIT_RATE(5, "Set non-volatile bit rate", 33),
    GET_NON_VOLATILE_BIT_RATE(5, "Get non-volatile bit rate", 34),
    SET_VOLATILE_BIT_RATE(6, "Set volatile bit rate", 33),
    GET_VOLATILE_BIT_RATE(6, "Get volatile bit rate", 34),
    SET_PAYLOAD_CHANNEL(7, "Set Payload Channel", 33),
    GET_PAYLOAD_CHANNEL(7, "Get Payload Channel", 34),
    SET_PAYLOAD_PORT(8, "Set Payload Port", 33),
    GET_PAYLOAD_PORT(8, "Get Payload Port", 34);

    private static final byte NET_FN = 12;
    private static final byte SET_CMD = 33;
    private static final byte GET_CMD = 34;
    private final int optionCode;
    private final String item;
    private final byte cmd;

    private SolConfigIpmiOptions(int optionCode, String item, byte cmd) {
        this.optionCode = optionCode;
        this.item = item;
        this.cmd = cmd;
    }

    @Override
    public int getOptionCode() {
        return this.optionCode;
    }

    @Override
    public String getItem() {
        return this.item;
    }

    @Override
    public byte getNetFn() {
        return 12;
    }

    @Override
    public byte getCommandCode() {
        return this.cmd;
    }

    @Override
    public byte[] rebuildRequestData(SolConfigCommand.Builder commandArgs) {
        switch (this) {
            case GET_LAN_PROGRESS: {
                return new byte[]{1, (byte)this.optionCode, 0, 0};
            }
            case GET_ENABLE: {
                return new byte[]{1, (byte)this.optionCode, 0, 0};
            }
            case GET_AUTHENTICATION: {
                return new byte[]{1, (byte)this.optionCode, 0, 0};
            }
            case GET_CHARACTER_CONFIG: {
                return new byte[]{1, (byte)this.optionCode, 0, 0};
            }
            case GET_RETRY: {
                return new byte[]{1, (byte)this.optionCode, 0, 0};
            }
            case GET_NON_VOLATILE_BIT_RATE: {
                return new byte[]{1, (byte)this.optionCode, 0, 0};
            }
            case GET_VOLATILE_BIT_RATE: {
                return new byte[]{1, (byte)this.optionCode, 0, 0};
            }
            case GET_PAYLOAD_PORT: {
                return new byte[]{1, (byte)this.optionCode, 0, 0};
            }
            case SET_LAN_PROGRESS: {
                return new byte[]{1, (byte)this.optionCode, commandArgs.getSolConfigData().getLanProgressStates().getCode()};
            }
            case SET_ENABLE: {
                return new byte[]{1, (byte)this.optionCode, commandArgs.getSolConfigData().getEnabled() != false ? (byte)1 : 0};
            }
            case SET_AUTHENTICATION: {
                boolean isForceEncryption = commandArgs.getSolConfigData().getForceEncryption();
                boolean isForcePayload = commandArgs.getSolConfigData().getForceAuthentication();
                byte privilegeLevel = commandArgs.getSolConfigData().getPrivilegeLevel().getCode();
                byte finalData = (byte)((isForceEncryption ? 128 : 0) | (isForcePayload ? 64 : 0) | privilegeLevel);
                return new byte[]{1, (byte)this.optionCode, finalData};
            }
            case SET_CHARACTER_CONFIG: {
                byte charInterval = commandArgs.getSolConfigData().getCharacterAccumulateLeve().divide(new BigDecimal(5), 0, RoundingMode.DOWN).byteValue();
                byte charThreshold = commandArgs.getSolConfigData().getCharacterSendThreshold().byteValue();
                return new byte[]{1, (byte)this.optionCode, charInterval, charThreshold};
            }
            case SET_RETRY: {
                byte retryCount = commandArgs.getSolConfigData().getRetryCount().byteValue();
                byte retryInterval = commandArgs.getSolConfigData().getRetryInterval().divide(new BigDecimal(10), 0, RoundingMode.DOWN).byteValue();
                return new byte[]{1, (byte)this.optionCode, retryCount, retryInterval};
            }
            case SET_NON_VOLATILE_BIT_RATE: {
                return new byte[]{1, (byte)this.optionCode, commandArgs.getSolConfigData().getNonVolatileBitRate().getCode()};
            }
            case SET_VOLATILE_BIT_RATE: {
                return new byte[]{1, (byte)this.optionCode, commandArgs.getSolConfigData().getVolatileBitRate().getCode()};
            }
            case SET_PAYLOAD_PORT: {
                int port = commandArgs.getSolConfigData().getPayloadPort().intValue();
                return new byte[]{1, (byte)this.optionCode, (byte)((port & 0xFF00) >> 4), (byte)(port & 0xFF)};
            }
        }
        return new byte[0];
    }

    @Override
    public AbstractJSONPOJO parserResponseData(GbtIpmiCommandResponseData gbtResponseData) {
        SolConfigData solConfigData = new SolConfigData();
        switch (this) {
            case GET_LAN_PROGRESS: {
                solConfigData.setLanProgressStates(BMCLanProgressStates.parseByByte(gbtResponseData.getResponseData(1)));
                return solConfigData;
            }
            case GET_ENABLE: {
                solConfigData.setEnabled(gbtResponseData.getResponseData(1) == 1);
                return solConfigData;
            }
            case GET_AUTHENTICATION: {
                solConfigData.setForceEncryption((gbtResponseData.getResponseData(1) & 0x80) == 128);
                solConfigData.setForceAuthentication((gbtResponseData.getResponseData(1) & 0x40) == 64);
                solConfigData.setPrivilegeLevel(PrivilegeLevel.parseByByte((byte)(gbtResponseData.getResponseData(1) & 0x3F)));
                return solConfigData;
            }
            case GET_CHARACTER_CONFIG: {
                solConfigData.setCharacterAccumulateLeve(new BigDecimal(gbtResponseData.getResponseData(1)).multiply(new BigDecimal(5)));
                solConfigData.setCharacterSendThreshold(new BigDecimal(gbtResponseData.getResponseData(2)));
                return solConfigData;
            }
            case GET_RETRY: {
                solConfigData.setRetryCount(new BigDecimal(gbtResponseData.getResponseData(1)));
                solConfigData.setRetryInterval(new BigDecimal(gbtResponseData.getResponseData(2)).multiply(new BigDecimal(10)));
                return solConfigData;
            }
            case GET_NON_VOLATILE_BIT_RATE: {
                solConfigData.setNonVolatileBitRate(SolVolatileBitRates.parseByByte(gbtResponseData.getResponseData(1)));
                return solConfigData;
            }
            case GET_VOLATILE_BIT_RATE: {
                solConfigData.setVolatileBitRate(SolVolatileBitRates.parseByByte(gbtResponseData.getResponseData(1)));
                return solConfigData;
            }
            case GET_PAYLOAD_CHANNEL: {
                solConfigData.setPayloadChannel(new BigDecimal(1));
                return solConfigData;
            }
            case GET_PAYLOAD_PORT: {
                int temp = (gbtResponseData.getResponseData(2) & 0xFF) << 8 | gbtResponseData.getResponseData(1) & 0xFF;
                solConfigData.setPayloadPort(new BigDecimal(temp));
                return solConfigData;
            }
            case SET_LAN_PROGRESS: {
                return new NullJSONData().setError(false).setMessages(this.getItem() + " success.");
            }
            case SET_ENABLE: {
                return new NullJSONData().setError(false).setMessages(this.getItem() + " success.");
            }
            case SET_AUTHENTICATION: {
                return new NullJSONData().setError(false).setMessages(this.getItem() + " success.");
            }
            case SET_CHARACTER_CONFIG: {
                return new NullJSONData().setError(false).setMessages(this.getItem() + " success.");
            }
            case SET_RETRY: {
                return new NullJSONData().setError(false).setMessages(this.getItem() + " success.");
            }
            case SET_NON_VOLATILE_BIT_RATE: {
                return new NullJSONData().setError(false).setMessages(this.getItem() + " success.");
            }
            case SET_VOLATILE_BIT_RATE: {
                return new NullJSONData().setError(false).setMessages(this.getItem() + " success.");
            }
            case SET_PAYLOAD_CHANNEL: {
                return new NullJSONData().setError(true).setMessages("Not allow to set payload channel.");
            }
            case SET_PAYLOAD_PORT: {
                return new NullJSONData().setError(false).setMessages(this.getItem() + " success.");
            }
        }
        return new NullJSONData().setError(true).setMessages("Unknown SOL config command options.");
    }

    public static final SolConfigIpmiOptions parseOptionByCode(int optionCode, boolean getMode) {
        if (getMode) {
            switch (optionCode) {
                case 0: {
                    return GET_LAN_PROGRESS;
                }
                case 1: {
                    return GET_ENABLE;
                }
                case 2: {
                    return GET_AUTHENTICATION;
                }
                case 3: {
                    return GET_CHARACTER_CONFIG;
                }
                case 4: {
                    return GET_RETRY;
                }
                case 5: {
                    return GET_NON_VOLATILE_BIT_RATE;
                }
                case 6: {
                    return GET_VOLATILE_BIT_RATE;
                }
                case 7: {
                    return GET_PAYLOAD_CHANNEL;
                }
                case 8: {
                    return GET_PAYLOAD_PORT;
                }
            }
            return GET_LAN_PROGRESS;
        }
        switch (optionCode) {
            case 0: {
                return SET_LAN_PROGRESS;
            }
            case 1: {
                return SET_ENABLE;
            }
            case 2: {
                return SET_AUTHENTICATION;
            }
            case 3: {
                return SET_CHARACTER_CONFIG;
            }
            case 4: {
                return SET_RETRY;
            }
            case 5: {
                return SET_NON_VOLATILE_BIT_RATE;
            }
            case 6: {
                return SET_VOLATILE_BIT_RATE;
            }
            case 7: {
                return SET_PAYLOAD_CHANNEL;
            }
            case 8: {
                return SET_PAYLOAD_PORT;
            }
        }
        return SET_LAN_PROGRESS;
    }
}

