/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.coding.commands.payload;

import com.veraxsystems.vxipmi.coding.commands.IpmiCommandCoder;
import com.veraxsystems.vxipmi.coding.commands.IpmiVersion;
import com.veraxsystems.vxipmi.coding.commands.payload.DeactivatePayloadCompletionCode;
import com.veraxsystems.vxipmi.coding.commands.payload.DeactivatePayloadResponseData;
import com.veraxsystems.vxipmi.coding.payload.CompletionCode;
import com.veraxsystems.vxipmi.coding.payload.IpmiPayload;
import com.veraxsystems.vxipmi.coding.payload.lan.IPMIException;
import com.veraxsystems.vxipmi.coding.payload.lan.IpmiLanRequest;
import com.veraxsystems.vxipmi.coding.payload.lan.IpmiLanResponse;
import com.veraxsystems.vxipmi.coding.payload.lan.NetworkFunction;
import com.veraxsystems.vxipmi.coding.protocol.AuthenticationType;
import com.veraxsystems.vxipmi.coding.protocol.IpmiMessage;
import com.veraxsystems.vxipmi.coding.protocol.PayloadType;
import com.veraxsystems.vxipmi.coding.security.CipherSuite;
import com.veraxsystems.vxipmi.common.MessageComposer;
import com.veraxsystems.vxipmi.common.TypeConverter;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;

public class DeactivatePayload
extends IpmiCommandCoder {
    private static final int REQUEST_DATA_LENGTH = 6;
    private final PayloadType payloadType;
    private final int payloadInstance;

    public DeactivatePayload(CipherSuite cipherSuite, PayloadType payloadType, int payloadInstance) {
        super(IpmiVersion.V20, cipherSuite, AuthenticationType.RMCPPlus);
        this.payloadType = payloadType;
        this.payloadInstance = payloadInstance;
    }

    @Override
    public byte getCommandCode() {
        return 73;
    }

    public DeactivatePayload(PayloadType payloadType, int payloadInstance) {
        this.payloadType = payloadType;
        this.payloadInstance = payloadInstance;
    }

    @Override
    public NetworkFunction getNetworkFunction() {
        return NetworkFunction.ApplicationRequest;
    }

    @Override
    protected IpmiPayload preparePayload(int sequenceNumber) {
        byte[] message = MessageComposer.get(6).appendField(TypeConverter.intToByte(this.payloadType.getCode())).appendField(TypeConverter.intToByte(this.payloadInstance)).getMessage();
        return new IpmiLanRequest(this.getNetworkFunction(), this.getCommandCode(), message, TypeConverter.intToByte(sequenceNumber));
    }

    @Override
    public DeactivatePayloadResponseData getResponseData(IpmiMessage message) throws IPMIException, NoSuchAlgorithmException, InvalidKeyException {
        DeactivatePayloadCompletionCode specificCompletionCode;
        if (!this.isCommandResponse(message)) {
            return null;
        }
        if (!(message.getPayload() instanceof IpmiLanResponse)) {
            return null;
        }
        CompletionCode completionCode = ((IpmiLanResponse)message.getPayload()).getCompletionCode();
        if (completionCode != CompletionCode.Ok && (specificCompletionCode = DeactivatePayloadCompletionCode.parseInt(completionCode.getCode())) != DeactivatePayloadCompletionCode.PAYLOAD_ALREADY_DEACTIVATED) {
            throw new IPMIException(((IpmiLanResponse)message.getPayload()).getCompletionCode());
        }
        return new DeactivatePayloadResponseData();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeactivatePayload that = (DeactivatePayload)o;
        if (this.payloadInstance != that.payloadInstance) {
            return false;
        }
        if (this.payloadType != that.payloadType) {
            return false;
        }
        return this.getCipherSuite().equals(that.getCipherSuite());
    }

    public int hashCode() {
        int result = this.payloadInstance;
        result = 31 * result + this.payloadType.getCode();
        result = 31 * result + (this.getCipherSuite() == null ? 0 : this.getCipherSuite().hashCode());
        return result;
    }
}

