/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.coding.commands.sdr;

import Gbt.utility.SDR.record.FullSensorRecord;
import com.veraxsystems.vxipmi.coding.commands.IpmiCommandCoder;
import com.veraxsystems.vxipmi.coding.commands.IpmiVersion;
import com.veraxsystems.vxipmi.coding.commands.ResponseData;
import com.veraxsystems.vxipmi.coding.commands.sdr.SetSensorThresholdResponseData;
import com.veraxsystems.vxipmi.coding.payload.CompletionCode;
import com.veraxsystems.vxipmi.coding.payload.IpmiPayload;
import com.veraxsystems.vxipmi.coding.payload.lan.IPMIException;
import com.veraxsystems.vxipmi.coding.payload.lan.IpmiLanRequest;
import com.veraxsystems.vxipmi.coding.payload.lan.IpmiLanResponse;
import com.veraxsystems.vxipmi.coding.payload.lan.NetworkFunction;
import com.veraxsystems.vxipmi.coding.protocol.AuthenticationType;
import com.veraxsystems.vxipmi.coding.protocol.IpmiMessage;
import com.veraxsystems.vxipmi.coding.security.CipherSuite;
import com.veraxsystems.vxipmi.common.TypeConverter;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;

public class SetSensorThreshold
extends IpmiCommandCoder {
    private FullSensorRecord record;

    public SetSensorThreshold(IpmiVersion version, CipherSuite cipherSuite, AuthenticationType authenticationType, FullSensorRecord record) {
        super(version, cipherSuite, authenticationType);
        this.record = record;
    }

    @Override
    public byte getCommandCode() {
        return 38;
    }

    @Override
    public NetworkFunction getNetworkFunction() {
        return NetworkFunction.SensorRequest;
    }

    @Override
    protected IpmiPayload preparePayload(int sequenceNumber) throws NoSuchAlgorithmException, InvalidKeyException {
        byte[] payloadData = new byte[]{this.record.getSensorNumber(), this.record.getSettableThresholdMask()[0], (byte)(this.record.revertFormula(this.record.getLowerNonCriticalThreshold()) & 0xFF), (byte)(this.record.revertFormula(this.record.getLowerCriticalThreshold()) & 0xFF), (byte)(this.record.revertFormula(this.record.getLowerNonRecoverableThreshold()) & 0xFF), (byte)(this.record.revertFormula(this.record.getUpperNonCriticalThreshold()) & 0xFF), (byte)(this.record.revertFormula(this.record.getUpperCriticalThreshold()) & 0xFF), (byte)(this.record.revertFormula(this.record.getUpperNonRecoverableThreshold()) & 0xFF)};
        System.out.println(Hex.encodeHexString((byte[])payloadData));
        return new IpmiLanRequest(this.getNetworkFunction(), this.getCommandCode(), payloadData, TypeConverter.intToByte(sequenceNumber));
    }

    @Override
    public ResponseData getResponseData(IpmiMessage message) throws IPMIException, NoSuchAlgorithmException, InvalidKeyException {
        if (!this.isCommandResponse(message)) {
            throw new IllegalArgumentException("This is not a response for Set Sensor Threshold command");
        }
        if (!(message.getPayload() instanceof IpmiLanResponse)) {
            throw new IllegalArgumentException("Invalid response payload");
        }
        if (((IpmiLanResponse)message.getPayload()).getCompletionCode() != CompletionCode.Ok) {
            throw new IPMIException(((IpmiLanResponse)message.getPayload()).getCompletionCode());
        }
        return new SetSensorThresholdResponseData(((IpmiLanResponse)message.getPayload()).getCompletionCode());
    }
}

