/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.coding.payload.sol;

import com.veraxsystems.vxipmi.coding.payload.sol.SolAckState;
import com.veraxsystems.vxipmi.coding.payload.sol.SolStatus;
import com.veraxsystems.vxipmi.common.TypeConverter;
import java.util.HashSet;
import java.util.Set;

public class SolInboundStatusField {
    private final SolAckState ackState;
    private final Set<SolStatus> statuses;

    public SolInboundStatusField(Set<SolStatus> statuses) {
        this.ackState = SolAckState.ACK;
        this.statuses = statuses;
    }

    public SolInboundStatusField(SolAckState ackState, Set<SolStatus> statuses) {
        this.ackState = ackState;
        this.statuses = statuses;
    }

    public SolInboundStatusField(byte raw) {
        this.ackState = SolAckState.extractFromByte(raw);
        this.statuses = this.extractStatusesFromByte(raw);
    }

    private Set<SolStatus> extractStatusesFromByte(byte raw) {
        HashSet<SolStatus> result = new HashSet<SolStatus>();
        for (SolStatus status : SolStatus.values()) {
            if (!TypeConverter.isBitSetOnPosition(status.getStatusNumber(), raw)) continue;
            result.add(status);
        }
        return result;
    }

    public Set<SolStatus> getStatuses() {
        return this.statuses;
    }

    public SolAckState getAckState() {
        return this.ackState;
    }

    public byte convertToByte() {
        byte value = 0;
        value = this.ackState.encodeInByte(value);
        for (SolStatus status : this.statuses) {
            value = TypeConverter.setBitOnPosition(status.getStatusNumber(), value);
        }
        return value;
    }
}

