/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.coding.protocol.decoder;

import com.veraxsystems.vxipmi.coding.protocol.AuthenticationType;
import com.veraxsystems.vxipmi.coding.protocol.IpmiMessage;
import com.veraxsystems.vxipmi.coding.protocol.Ipmiv15Message;
import com.veraxsystems.vxipmi.coding.protocol.PayloadType;
import com.veraxsystems.vxipmi.coding.protocol.decoder.ProtocolDecoder;
import com.veraxsystems.vxipmi.coding.rmcp.RmcpMessage;
import com.veraxsystems.vxipmi.common.TypeConverter;

public class Protocolv15Decoder
extends ProtocolDecoder {
    @Override
    public IpmiMessage decode(RmcpMessage rmcpMessage) {
        Ipmiv15Message message = new Ipmiv15Message();
        byte[] raw = rmcpMessage.getData();
        if (raw[4] == 64) {
            return message;
        }
        message.setAuthenticationType(Protocolv15Decoder.decodeAuthenticationType(raw[0]));
        int offset = 1;
        message.setSessionSequenceNumber(this.decodeSessionSequenceNumber(raw, offset));
        message.setSessionID(Protocolv15Decoder.decodeSessionID(raw, offset += 4));
        offset += 4;
        if (message.getAuthenticationType() != AuthenticationType.None) {
            message.setAuthCode(this.decodeAuthCode(raw, offset));
            offset += 16;
        }
        int payloadLength = this.decodePayloadLength(raw, offset);
        message.setPayloadLength(payloadLength);
        message.setPayload(this.decodePayload(raw, ++offset, payloadLength, message.getConfidentialityAlgorithm(), PayloadType.Ipmi));
        return message;
    }

    private byte[] decodeAuthCode(byte[] rawMessage, int offset) {
        byte[] authCode = new byte[16];
        System.arraycopy(rawMessage, offset, authCode, 0, 16);
        return authCode;
    }

    @Override
    protected int decodePayloadLength(byte[] rawData, int offset) {
        return TypeConverter.byteToInt(rawData[offset]);
    }
}

