/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.coding.security;

import com.veraxsystems.vxipmi.common.TypeConverter;
import java.security.InvalidKeyException;

public abstract class IntegrityAlgorithm {
    protected byte[] sik;

    public void initialize(byte[] sik) throws InvalidKeyException {
        this.sik = sik;
    }

    public abstract byte getCode();

    public abstract byte[] generateAuthCode(byte[] var1);

    protected byte[] injectIntegrityPad(byte[] base, int authCodeLength) {
        int pad = 0;
        if ((base.length + authCodeLength) % 4 != 0) {
            pad = 4 - (base.length + authCodeLength) % 4;
        }
        if (pad != 0) {
            byte[] newBase = new byte[base.length + pad];
            System.arraycopy(base, 0, newBase, 0, base.length - 2);
            for (int i = base.length - 2; i < base.length - 2 + pad; ++i) {
                newBase[i] = TypeConverter.intToByte(255);
            }
            newBase[newBase.length - 2] = TypeConverter.intToByte(pad);
            newBase[newBase.length - 1] = base[base.length - 1];
            return newBase;
        }
        return base;
    }
}

