/*
 * Decompiled with CFR 0.152.
 */
package com.veraxsystems.vxipmi.connection;

import com.veraxsystems.vxipmi.api.async.ConnectionHandle;
import com.veraxsystems.vxipmi.coding.commands.PrivilegeLevel;
import com.veraxsystems.vxipmi.coding.commands.session.GetChannelAuthenticationCapabilitiesResponseData;
import com.veraxsystems.vxipmi.coding.security.CipherSuite;
import com.veraxsystems.vxipmi.coding.security.DefaultCipherSuiteSelector;
import com.veraxsystems.vxipmi.common.PropertiesManager;
import com.veraxsystems.vxipmi.connection.Connection;
import com.veraxsystems.vxipmi.connection.ConnectionException;
import com.veraxsystems.vxipmi.connection.ConnectionListener;
import com.veraxsystems.vxipmi.connection.Session;
import com.veraxsystems.vxipmi.transport.Messenger;
import com.veraxsystems.vxipmi.transport.UdpMessenger;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.text.CharacterPredicate;
import org.apache.commons.text.CharacterPredicates;
import org.apache.commons.text.RandomStringGenerator;

public class ConnectionManager {
    private static int pingPeriod = -1;
    private static Integer sessionId = 100;
    private final AtomicInteger sessionlessTag;
    private final List<Integer> reservedTags;
    private volatile int ipmiRandomLength = 12;
    private final Messenger messenger;
    private final ConcurrentMap<String, Connection> connections;
    private final ConcurrentMap<String, Session> sessions;
    private final RandomStringGenerator randomStringGenerator;

    public ConnectionManager(int port) throws IOException {
        this.messenger = new UdpMessenger(port);
        this.connections = new ConcurrentHashMap<String, Connection>();
        this.sessions = new ConcurrentHashMap<String, Session>();
        this.randomStringGenerator = new RandomStringGenerator.Builder().withinRange(48, 122).filteredBy(new CharacterPredicate[]{CharacterPredicates.LETTERS, CharacterPredicates.DIGITS}).build();
        this.sessionlessTag = new AtomicInteger(0);
        this.reservedTags = new ArrayList<Integer>();
        if (pingPeriod == -1) {
            pingPeriod = Integer.parseInt(PropertiesManager.getInstance().getProperty("pingPeriod"));
        }
        this.ipmiRandomLength = 12;
    }

    public ConnectionManager(int port, InetAddress address) throws IOException {
        this.messenger = new UdpMessenger(port, address);
        this.connections = new ConcurrentHashMap<String, Connection>();
        this.sessions = new ConcurrentHashMap<String, Session>();
        this.randomStringGenerator = new RandomStringGenerator.Builder().withinRange(48, 122).filteredBy(new CharacterPredicate[]{CharacterPredicates.LETTERS, CharacterPredicates.DIGITS}).build();
        this.sessionlessTag = new AtomicInteger(0);
        this.reservedTags = new ArrayList<Integer>();
        if (pingPeriod == -1) {
            pingPeriod = Integer.parseInt(PropertiesManager.getInstance().getProperty("pingPeriod"));
        }
        this.ipmiRandomLength = 12;
    }

    public static synchronized int generateSessionId() {
        Integer n = sessionId = Integer.valueOf(sessionId % 0x1FFFFFFF);
        Integer n2 = sessionId = Integer.valueOf(sessionId + 1);
        return n;
    }

    public void close() {
        for (Connection connection : this.connections.values()) {
            if (connection == null || !connection.isActive()) continue;
            connection.disconnect();
        }
        this.messenger.closeConnection();
        this.connections.clear();
        this.sessions.clear();
        this.reservedTags.clear();
        this.sessionlessTag.set(0);
        sessionId = 100;
    }

    public ConnectionHandle createConnection(InetAddress address, int port) {
        return this.createConnection(address, port, pingPeriod, false);
    }

    public ConnectionHandle createConnection(InetAddress address, int port, int pingPeriod, boolean skipCiphers) {
        String ipmiConnectionHandleId = address.getHostAddress() + "-" + this.randomStringGenerator.generate(this.ipmiRandomLength);
        Connection connection = new Connection(this.messenger, ipmiConnectionHandleId);
        connection.connect(address, port, pingPeriod, skipCiphers);
        this.connections.putIfAbsent(ipmiConnectionHandleId, connection);
        return new ConnectionHandle(ipmiConnectionHandleId, address, port);
    }

    public Connection getConnection(ConnectionHandle ipmiConnectionHandle) {
        return (Connection)this.connections.get(ipmiConnectionHandle.getConnectionHandleId());
    }

    public Connection getConnection(String ipmiConnectionHandleId) {
        return (Connection)this.connections.get(ipmiConnectionHandleId);
    }

    public void closeConnection(ConnectionHandle ipmiConnectionHandle) {
        if (this.connections.containsKey(ipmiConnectionHandle.getConnectionHandleId())) {
            ((Connection)this.connections.get(ipmiConnectionHandle.getConnectionHandleId())).disconnect();
            this.connections.remove(ipmiConnectionHandle.getConnectionHandleId());
        }
    }

    public List<CipherSuite> getAvailableCipherSuites(ConnectionHandle ipmiConnectionHandle) throws ConnectionException {
        List<CipherSuite> suites;
        int tag = this.generateSessionlessTag();
        try {
            suites = ((Connection)this.connections.get(ipmiConnectionHandle.getConnectionHandleId())).getAvailableCipherSuites(tag);
        }
        catch (ConnectionException e) {
            this.freeTag(tag);
            throw e;
        }
        this.freeTag(tag);
        return suites;
    }

    public GetChannelAuthenticationCapabilitiesResponseData getChannelAuthenticationCapabilities(ConnectionHandle connectionHandle, List<CipherSuite> cipherSuites, PrivilegeLevel requestedPrivilegeLevel) throws ConnectionException {
        int tag = this.generateSessionlessTag();
        DefaultCipherSuiteSelector cipherSuiteSelectionHandler = DefaultCipherSuiteSelector.getInstance();
        CipherSuite pickupCipherSuite = cipherSuiteSelectionHandler.choose(cipherSuites);
        if (pickupCipherSuite == null) {
            throw new ConnectionException("Cannot pick up available cipher suite (3).");
        }
        connectionHandle.setCipherSuite(pickupCipherSuite);
        connectionHandle.setPrivilegeLevel(requestedPrivilegeLevel);
        try {
            GetChannelAuthenticationCapabilitiesResponseData responseData = ((Connection)this.connections.get(connectionHandle.getConnectionHandleId())).getChannelAuthenticationCapabilities(tag, connectionHandle.getCipherSuite(), requestedPrivilegeLevel);
            this.freeTag(tag);
            return responseData;
        }
        catch (ConnectionException ce) {
            this.freeTag(tag);
            throw ce;
        }
    }

    public int startSession(ConnectionHandle ipmiConnectionHandle, CipherSuite cipherSuite, PrivilegeLevel privilegeLevel, String username, String password, byte[] bmcKey) throws Exception {
        int sessionId;
        int tag = this.generateSessionlessTag();
        try {
            sessionId = ((Connection)this.connections.get(ipmiConnectionHandle.getConnectionHandleId())).startSession(tag, cipherSuite, privilegeLevel, username, password, bmcKey);
        }
        catch (Exception e) {
            this.freeTag(tag);
            throw e;
        }
        this.freeTag(tag);
        return sessionId;
    }

    public Session registerSession(int sessionId, ConnectionHandle ipmiConnectionHandle) throws ConnectionException {
        if (ipmiConnectionHandle.getUser() == null || ipmiConnectionHandle.getRemoteAddress() == null) {
            throw new ConnectionException("Given connection handle is incomplete (lacks user or remote address)");
        }
        Session newSession = new Session(sessionId, ipmiConnectionHandle);
        Session currentSession = this.sessions.putIfAbsent(ipmiConnectionHandle.getConnectionHandleId(), newSession);
        return currentSession != null ? currentSession : newSession;
    }

    public void unregisterSession(ConnectionHandle ipmiConnectionHandle) {
        this.sessions.remove(ipmiConnectionHandle.getConnectionHandleId());
    }

    public void registerListener(ConnectionHandle ipmiConnectionHandle, ConnectionListener listener) {
        ((Connection)this.connections.get(ipmiConnectionHandle.getConnectionHandleId())).registerListener(listener);
    }

    public void unregisterListener(ConnectionHandle ipmiConnectionHandle, ConnectionListener listener) {
        ((Connection)this.connections.get(ipmiConnectionHandle.getConnectionHandleId())).unregisterListener(listener);
    }

    public int sendRmcpPingMessage(ConnectionHandle ipmiConnectionHandle) throws ConnectionException {
        return ((Connection)this.connections.get(ipmiConnectionHandle.getConnectionHandleId())).sendRmcpPingMessage();
    }

    public Session getSessionForCriteria(InetAddress remoteAddress, int remotePort, String user) {
        for (Session session : this.sessions.values()) {
            ConnectionHandle sessionConnectionHandle = session.getConnectionHandle();
            if (!sessionConnectionHandle.getUser().equals(user) || !sessionConnectionHandle.getRemoteAddress().equals(remoteAddress) || sessionConnectionHandle.getRemotePort() != remotePort) continue;
            return session;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int generateSessionlessTag() {
        AtomicInteger atomicInteger = this.sessionlessTag;
        synchronized (atomicInteger) {
            List<Integer> list;
            boolean wait = true;
            while (wait) {
                this.sessionlessTag.incrementAndGet();
                this.sessionlessTag.set(this.sessionlessTag.get() % 60);
                list = this.reservedTags;
                synchronized (list) {
                    if (!this.reservedTags.contains(this.sessionlessTag.get())) {
                        wait = false;
                    }
                }
                if (!wait) continue;
                try {
                    this.sessionlessTag.wait(1L);
                }
                catch (InterruptedException ie) {
                    Thread.yield();
                }
            }
            list = this.reservedTags;
            synchronized (list) {
                this.reservedTags.add(this.sessionlessTag.get());
            }
            return this.sessionlessTag.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freeTag(int tag) {
        List<Integer> list = this.reservedTags;
        synchronized (list) {
            this.reservedTags.remove((Object)tag);
        }
    }
}

