/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.model.message;

import java.io.UnsupportedEncodingException;
import org.fourthline.cling.model.message.UpnpHeaders;
import org.fourthline.cling.model.message.UpnpOperation;
import org.fourthline.cling.model.message.header.ContentTypeHeader;
import org.fourthline.cling.model.message.header.UpnpHeader;
import org.seamless.util.MimeType;

public abstract class UpnpMessage<O extends UpnpOperation> {
    private int udaMajorVersion = 1;
    private int udaMinorVersion = 0;
    private O operation;
    private UpnpHeaders headers = new UpnpHeaders();
    private Object body;
    private BodyType bodyType = BodyType.STRING;

    protected UpnpMessage(UpnpMessage<O> source) {
        this.operation = source.getOperation();
        this.headers = source.getHeaders();
        this.body = source.getBody();
        this.bodyType = source.getBodyType();
        this.udaMajorVersion = source.getUdaMajorVersion();
        this.udaMinorVersion = source.getUdaMinorVersion();
    }

    protected UpnpMessage(O operation) {
        this.operation = operation;
    }

    protected UpnpMessage(O operation, BodyType bodyType, Object body) {
        this.operation = operation;
        this.bodyType = bodyType;
        this.body = body;
    }

    public int getUdaMajorVersion() {
        return this.udaMajorVersion;
    }

    public void setUdaMajorVersion(int udaMajorVersion) {
        this.udaMajorVersion = udaMajorVersion;
    }

    public int getUdaMinorVersion() {
        return this.udaMinorVersion;
    }

    public void setUdaMinorVersion(int udaMinorVersion) {
        this.udaMinorVersion = udaMinorVersion;
    }

    public UpnpHeaders getHeaders() {
        return this.headers;
    }

    public void setHeaders(UpnpHeaders headers) {
        this.headers = headers;
    }

    public Object getBody() {
        return this.body;
    }

    public void setBody(String string) {
        this.bodyType = BodyType.STRING;
        this.body = string;
    }

    public void setBody(BodyType bodyType, Object body) {
        this.bodyType = bodyType;
        this.body = body;
    }

    public void setBodyCharacters(byte[] characterData) throws UnsupportedEncodingException {
        this.setBody(BodyType.STRING, new String(characterData, this.getContentTypeCharset() != null ? this.getContentTypeCharset() : "UTF-8"));
    }

    public boolean hasBody() {
        return this.getBody() != null;
    }

    public BodyType getBodyType() {
        return this.bodyType;
    }

    public void setBodyType(BodyType bodyType) {
        this.bodyType = bodyType;
    }

    public String getBodyString() {
        try {
            if (!this.hasBody()) {
                return null;
            }
            if (this.getBodyType().equals((Object)BodyType.STRING)) {
                String body = (String)this.getBody();
                if (body.charAt(0) == '\ufeff') {
                    body = body.substring(1);
                }
                return body;
            }
            return new String((byte[])this.getBody(), "UTF-8");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public byte[] getBodyBytes() {
        try {
            if (!this.hasBody()) {
                return null;
            }
            if (this.getBodyType().equals((Object)BodyType.STRING)) {
                return this.getBodyString().getBytes();
            }
            return (byte[])this.getBody();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public O getOperation() {
        return this.operation;
    }

    public boolean isContentTypeMissingOrText() {
        ContentTypeHeader contentTypeHeader = this.getContentTypeHeader();
        if (contentTypeHeader == null) {
            return true;
        }
        return contentTypeHeader.isText();
    }

    public ContentTypeHeader getContentTypeHeader() {
        return this.getHeaders().getFirstHeader(UpnpHeader.Type.CONTENT_TYPE, ContentTypeHeader.class);
    }

    public boolean isContentTypeText() {
        ContentTypeHeader ct = this.getContentTypeHeader();
        return ct != null && ct.isText();
    }

    public boolean isContentTypeTextUDA() {
        ContentTypeHeader ct = this.getContentTypeHeader();
        return ct != null && ct.isUDACompliantXML();
    }

    public String getContentTypeCharset() {
        ContentTypeHeader ct = this.getContentTypeHeader();
        return ct != null ? (String)((MimeType)ct.getValue()).getParameters().get("charset") : null;
    }

    public boolean hasHostHeader() {
        return this.getHeaders().getFirstHeader(UpnpHeader.Type.HOST) != null;
    }

    public boolean isBodyNonEmptyString() {
        return this.hasBody() && this.getBodyType().equals((Object)BodyType.STRING) && this.getBodyString().length() > 0;
    }

    public String toString() {
        return "(" + this.getClass().getSimpleName() + ") " + this.getOperation().toString();
    }

    public static enum BodyType {
        STRING,
        BYTES;

    }
}

