/*
 * Decompiled with CFR 0.152.
 */
package Gbt.core.engines.records;

import Gbt.core.engines.records.EngineRecordStates;
import Gbt.core.engines.records.EngineRecords;
import java.util.ArrayList;
import java.util.List;

public final class LocalCmdRecords
extends EngineRecords {
    private StringBuilder stdOutBuffer = new StringBuilder();
    private StringBuilder stdErrBuffer = new StringBuilder();
    private List<String> stdOutList = new ArrayList<String>();
    private List<String> stdErrList = new ArrayList<String>();

    public LocalCmdRecords(String recordID) {
        super(recordID);
    }

    @Override
    public LocalCmdRecords setStates(EngineRecordStates states) {
        this.states = states;
        return this;
    }

    public LocalCmdRecords addMessages(String mesg, boolean isError) {
        if (isError) {
            this.stdErrBuffer.append(mesg).append("\n");
            this.stdErrList.add(mesg);
        } else {
            this.stdOutBuffer.append(mesg).append("\n");
            this.stdOutList.add(mesg);
        }
        return this;
    }

    public String getResults() {
        return this.stdOutBuffer.toString();
    }

    public List<String> getLineResults() {
        return this.stdOutList;
    }

    public String getErrors() {
        return this.stdErrBuffer.toString();
    }

    public List<String> getLineErrors() {
        return this.stdErrList;
    }

    public void clearMesg() {
        this.stdOutBuffer.setLength(0);
        this.stdErrBuffer.setLength(0);
        this.stdOutList.clear();
        this.stdErrList.clear();
    }
}

